/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.contextualtextio;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import junit.framework.Assert;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.TestUtils;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.contextualtextio.ContextualTextIO;
import org.apache.beam.sdk.io.contextualtextio.ContextualTextIOSource;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.SourceTestUtils;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.UsesUnboundedSplittableParDo;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.ToString;
import org.apache.beam.sdk.transforms.Watch;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.AfterPane;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Charsets;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorOutputStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.Parameterized;

public class ContextualTextIOTest {
    private static final int NUM_LINES_FOR_LARGE = 1024;
    private static final List<String> EMPTY = Collections.emptyList();
    private static final List<String> TINY = Arrays.asList("ABC", "DEF", "HIJ");
    private static final List<String> LARGE = ContextualTextIOTest.makeLines(1024);
    private static final String VALUE = "value";

    private static File writeToFile(List<String> lines, TemporaryFolder folder, String fileName, Compression compression) throws IOException {
        File file = folder.getRoot().toPath().resolve(fileName).toFile();
        OutputStream output = new FileOutputStream(file);
        switch (compression) {
            case UNCOMPRESSED: {
                break;
            }
            case GZIP: {
                output = new GZIPOutputStream(output);
                break;
            }
            case BZIP2: {
                output = new BZip2CompressorOutputStream(output);
                break;
            }
            case ZIP: {
                ZipOutputStream zipOutput = new ZipOutputStream(output);
                zipOutput.putNextEntry(new ZipEntry("entry"));
                output = zipOutput;
                break;
            }
            case DEFLATE: {
                output = new DeflateCompressorOutputStream(output);
                break;
            }
            default: {
                throw new UnsupportedOperationException(compression.toString());
            }
        }
        ContextualTextIOTest.writeToStreamAndClose(lines, output);
        return file;
    }

    private static void writeToStreamAndClose(List<String> lines, OutputStream outputStream) {
        try (PrintStream writer = new PrintStream(outputStream);){
            for (String line : lines) {
                writer.println(line);
            }
        }
    }

    private static List<String> makeLines(int n) {
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            lines.add("Line " + i);
        }
        return lines;
    }

    private static void assertReadingCompressedFileMatchesExpected(File file, Compression compression, List<String> expected, Pipeline p) {
        ContextualTextIO.Read read = ContextualTextIO.read().from(file.getPath()).withCompression(compression);
        ArrayList<String> expectedOutput = new ArrayList<String>();
        for (int lineNum = 0; lineNum < expected.size(); ++lineNum) {
            expectedOutput.add(file.getName() + " " + expected.get(lineNum));
        }
        ArrayList<String> expectedOutputWithRecordNum = new ArrayList<String>();
        for (int lineNum = 0; lineNum < expected.size(); ++lineNum) {
            expectedOutputWithRecordNum.add(file.getName() + " " + lineNum + " " + expected.get(lineNum));
        }
        PAssert.that((PCollection)((PCollection)((PCollection)p.apply("Read_" + file + "_" + compression.toString(), (PTransform)read)).apply("ConvertRecordToString", (PTransform)ParDo.of((DoFn)new ConvertRecordToString())))).containsInAnyOrder(expectedOutput);
        PAssert.that((PCollection)((PCollection)((PCollection)p.apply("Read_" + file + "_" + compression.toString() + "_many", (PTransform)read.withHintMatchesManyFiles())).apply("ConvertRecordToString_many", (PTransform)ParDo.of((DoFn)new ConvertRecordToString())))).containsInAnyOrder(expectedOutput);
        PAssert.that((PCollection)((PCollection)((PCollection)p.apply("Read_" + file + "_" + compression.toString() + "_withRFC4180", (PTransform)read.withHasMultilineCSVRecords(Boolean.valueOf(true)))).apply("ConvertRecordToString_withRFC4180", (PTransform)ParDo.of((DoFn)new ConvertRecordToString())))).containsInAnyOrder(expectedOutput);
        PAssert.that((PCollection)((PCollection)((PCollection)p.apply("Read_" + file + "_" + compression.toString() + "_withRecordNumMetadata", (PTransform)read.withRecordNumMetadata())).apply("ConvertRecordWithMetadataToString_many", (PTransform)ParDo.of((DoFn)new ConvertRecordWithMetadataToString())))).containsInAnyOrder(expectedOutputWithRecordNum);
        PAssert.that((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)p.apply("Create_Paths_ReadFiles_" + file, (PTransform)Create.of((Object)file.getPath(), (Object[])new String[0]))).apply("Match_" + file, (PTransform)FileIO.matchAll())).apply("ReadMatches_" + file, (PTransform)FileIO.readMatches().withCompression(compression))).apply("ReadFiles_" + compression.toString(), (PTransform)ContextualTextIO.readFiles())).apply("ConvertRecordToStringWithFileIO", (PTransform)ParDo.of((DoFn)new ConvertRecordToString())))).containsInAnyOrder(expectedOutput);
        PAssert.that((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)p.apply("Create_Paths_ReadFiles_ForRecordNum" + file, (PTransform)Create.of((Object)file.getPath(), (Object[])new String[0]))).apply("Match_ForRecordNum" + file, (PTransform)FileIO.matchAll())).apply("ReadMatches_ForRecordNum" + file, (PTransform)FileIO.readMatches().withCompression(compression))).apply("ReadFiles_ForRecordNum" + compression.toString(), (PTransform)ContextualTextIO.readFiles().withRecordNumMetadata())).apply("ConvertRecordWithMetadataToStringWithFileIO", (PTransform)ParDo.of((DoFn)new ConvertRecordWithMetadataToString())))).containsInAnyOrder(expectedOutputWithRecordNum);
    }

    private static File createZipFile(List<String> expected, TemporaryFolder folder, String filename, String[] ... fieldsEntries) throws Exception {
        File tmpFile = folder.getRoot().toPath().resolve(filename).toFile();
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(tmpFile));
        PrintStream writer = new PrintStream(out, true);
        int index = 0;
        for (String[] entry : fieldsEntries) {
            out.putNextEntry(new ZipEntry(Integer.toString(index)));
            for (String field : entry) {
                writer.println(field);
                expected.add(field);
            }
            out.closeEntry();
            ++index;
        }
        writer.close();
        out.close();
        return tmpFile;
    }

    private static ContextualTextIOSource prepareSource(TemporaryFolder temporaryFolder, byte[] data, byte[] delimiter, boolean hasRFC4180Multiline) throws IOException {
        Path path = temporaryFolder.newFile().toPath();
        Files.write(path, data, new OpenOption[0]);
        return new ContextualTextIOSource((ValueProvider)ValueProvider.StaticValueProvider.of((Object)path.toString()), EmptyMatchTreatment.DISALLOW, delimiter, hasRFC4180Multiline);
    }

    private static String getFileSuffix(Compression compression) {
        switch (compression) {
            case UNCOMPRESSED: {
                return ".txt";
            }
            case GZIP: {
                return ".gz";
            }
            case BZIP2: {
                return ".bz2";
            }
            case ZIP: {
                return ".zip";
            }
            case DEFLATE: {
                return ".deflate";
            }
        }
        return "";
    }

    @RunWith(value=JUnit4.class)
    public static class BasicIOTest {
        @Rule
        public TemporaryFolder tempFolder = new TemporaryFolder();
        @Rule
        public TestPipeline p = TestPipeline.create();

        private void runTestRead(String[] expected) throws Exception {
            File tmpFile = this.tempFolder.newFile();
            String filename = tmpFile.getPath();
            try (PrintStream writer = new PrintStream(new FileOutputStream(tmpFile));){
                for (String elem : expected) {
                    byte[] encodedElem = CoderUtils.encodeToByteArray((Coder)StringUtf8Coder.of(), (Object)elem);
                    String line = new String(encodedElem, Charsets.UTF_8);
                    writer.println(line);
                }
            }
            ContextualTextIO.Read read = ContextualTextIO.read().from(filename);
            PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)read)).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)L -> L.getString(ContextualTextIOTest.VALUE)));
            PAssert.that((PCollection)output).containsInAnyOrder((Object[])expected);
            this.p.run();
        }

        private void runTestReadLineNumsAndFileName(String[] expected) throws Exception {
            File tmpFile = this.tempFolder.newFile();
            String filePath = tmpFile.getPath();
            ArrayList<String> actualExpected = new ArrayList<String>();
            try (PrintStream writer = new PrintStream(new FileOutputStream(tmpFile));){
                int lineNum = 0;
                for (String elem : expected) {
                    byte[] encodedElem = CoderUtils.encodeToByteArray((Coder)StringUtf8Coder.of(), (Object)elem);
                    String line = new String(encodedElem, Charsets.UTF_8);
                    writer.println(line);
                    actualExpected.add(lineNum + " " + filePath + " " + line);
                    ++lineNum;
                }
            }
            ContextualTextIO.Read read = ContextualTextIO.read().withRecordNumMetadata().from(filePath);
            PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)read)).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)L -> L.getInt64("recordNum") + " " + ((ResourceId)L.getLogicalTypeValue("resourceId", ResourceId.class)).toString() + " " + L.getString(ContextualTextIOTest.VALUE)));
            PAssert.that((PCollection)output).containsInAnyOrder(actualExpected);
            this.p.run();
        }

        @Test
        public void testDelimiterSelfOverlaps() {
            Assert.assertFalse((boolean)ContextualTextIO.Read.isSelfOverlapping((byte[])new byte[]{97, 98, 99}));
            Assert.assertFalse((boolean)ContextualTextIO.Read.isSelfOverlapping((byte[])new byte[]{99, 97, 98, 100, 97, 98}));
            Assert.assertFalse((boolean)ContextualTextIO.Read.isSelfOverlapping((byte[])new byte[]{97, 98, 99, 97, 98, 100}));
            Assert.assertTrue((boolean)ContextualTextIO.Read.isSelfOverlapping((byte[])new byte[]{97, 98, 97}));
            Assert.assertTrue((boolean)ContextualTextIO.Read.isSelfOverlapping((byte[])new byte[]{97, 98, 99, 97, 98}));
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testReadStringsWithCustomDelimiter() throws Exception {
            Object[] inputStrings = new String[]{"To be, or not to be: that |is the question: ", "To be, or not to be: that *is the question: ", "Whether 'tis nobler in the mind to suffer |*", "The slings and arrows of outrageous fortune,|"};
            File tmpFile = this.tempFolder.newFile("tmpfile.txt");
            String filename = tmpFile.getPath();
            try (BufferedWriter writer = Files.newBufferedWriter(tmpFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.write(Joiner.on((String)"").join(inputStrings));
            }
            PAssert.that((PCollection)((PCollection)((PCollection)this.p.apply((PTransform)ContextualTextIO.read().from(filename).withDelimiter(new byte[]{124, 42}))).apply((PTransform)ParDo.of((DoFn)new GetLines())))).containsInAnyOrder((Object[])new String[]{"To be, or not to be: that |is the question: To be, or not to be: that *is the question: Whether 'tis nobler in the mind to suffer ", "The slings and arrows of outrageous fortune,|"});
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testReadStringsWithCustomDelimiterAndContext() throws Exception {
            Object[] inputStrings = new String[]{"To be, or not to be: that |is the question: ", "To be, or not to be: that *is the question: ", "Whether 'tis nobler in the mind to suffer |*", "The slings and arrows of outrageous fortune,|"};
            String fileName = "tmpFile.txt";
            File tmpFile = this.tempFolder.newFile(fileName);
            String absoluteFilePath = tmpFile.getPath();
            try (BufferedWriter writer = Files.newBufferedWriter(tmpFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.write(Joiner.on((String)"").join(inputStrings));
            }
            PAssert.that((PCollection)((PCollection)((PCollection)this.p.apply((PTransform)ContextualTextIO.read().withRecordNumMetadata().from(absoluteFilePath).withDelimiter(new byte[]{124, 42}))).apply((PTransform)ParDo.of((DoFn)new GetDetails())))).containsInAnyOrder((Object[])new String[]{tmpFile + " 0 To be, or not to be: that |is the question: To be, or not to be: that *is the question: Whether 'tis nobler in the mind to suffer ", tmpFile + " 1 The slings and arrows of outrageous fortune,|"});
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testReadStrings() throws Exception {
            this.runTestRead(TestUtils.LINES_ARRAY);
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testReadStringsWithContext() throws Exception {
            this.runTestReadLineNumsAndFileName(TestUtils.LINES_ARRAY);
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testReadEmptyStrings() throws Exception {
            this.runTestRead(TestUtils.NO_LINES_ARRAY);
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testReadEmptyStringsWithContext() throws Exception {
            this.runTestReadLineNumsAndFileName(TestUtils.NO_LINES_ARRAY);
        }

        @Test
        public void testReadDisplayData() {
            ContextualTextIO.Read read = ContextualTextIO.read().from("foo.*").withCompression(Compression.BZIP2);
            DisplayData displayData = DisplayData.from((HasDisplayData)read);
            MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"filePattern", (String)"foo.*"));
            MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"compressionType", (String)Compression.BZIP2.toString()));
        }

        @Test
        public void testRuntimeOptionsNotCalledInApply() throws Exception {
            this.p.enableAbandonedNodeEnforcement(false);
            RuntimeTestOptions options = (RuntimeTestOptions)PipelineOptionsFactory.as(RuntimeTestOptions.class);
            this.p.apply((PTransform)ContextualTextIO.read().from(options.getInput()));
        }

        @Test
        public void testCompressionIsSet() throws Exception {
            ContextualTextIO.Read read = ContextualTextIO.read().from("/tmp/test");
            Assert.assertEquals((Object)Compression.AUTO, (Object)read.getCompression());
            read = ContextualTextIO.read().from("/tmp/test").withCompression(Compression.GZIP);
            Assert.assertEquals((Object)Compression.GZIP, (Object)read.getCompression());
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testSmallCompressedGzipReadActuallyUncompressed() throws Exception {
            File smallGzNotCompressed = ContextualTextIOTest.writeToFile(TINY, this.tempFolder, "tiny_uncompressed.gz", Compression.UNCOMPRESSED);
            ContextualTextIOTest.assertReadingCompressedFileMatchesExpected(smallGzNotCompressed, Compression.GZIP, TINY, (Pipeline)this.p);
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testSmallCompressedAutoReadActuallyUncompressed() throws Exception {
            File smallGzNotCompressed = ContextualTextIOTest.writeToFile(TINY, this.tempFolder, "tiny_uncompressed.gz", Compression.UNCOMPRESSED);
            ContextualTextIOTest.assertReadingCompressedFileMatchesExpected(smallGzNotCompressed, Compression.AUTO, TINY, (Pipeline)this.p);
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testZipCompressedReadWithNoEntries() throws Exception {
            File file = ContextualTextIOTest.createZipFile(new ArrayList(), this.tempFolder, "empty zip file", new String[0][]);
            ContextualTextIOTest.assertReadingCompressedFileMatchesExpected(file, Compression.ZIP, EMPTY, (Pipeline)this.p);
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testZipCompressedReadWithMultiEntriesFile() throws Exception {
            String[] entry0 = new String[]{"first", "second", "three"};
            String[] entry1 = new String[]{"four", "five", "six"};
            String[] entry2 = new String[]{"seven", "eight", "nine"};
            ArrayList expected = new ArrayList();
            File file = ContextualTextIOTest.createZipFile(expected, this.tempFolder, "multiple entries", new String[][]{entry0, entry1, entry2});
            ContextualTextIOTest.assertReadingCompressedFileMatchesExpected(file, Compression.ZIP, expected, (Pipeline)this.p);
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testZipCompressedReadWithComplexEmptyAndPresentEntries() throws Exception {
            File file = ContextualTextIOTest.createZipFile(new ArrayList(), this.tempFolder, "complex empty and present entries", new String[][]{{"cat"}, new String[0], new String[0], {"dog"}});
            ContextualTextIOTest.assertReadingCompressedFileMatchesExpected(file, Compression.ZIP, Arrays.asList("cat", "dog"), (Pipeline)this.p);
            this.p.run();
        }

        @Test
        public void testContextualTextIOGetName() {
            Assert.assertEquals((String)"ContextualTextIO.Read", (String)ContextualTextIO.read().from("somefile").getName());
            Assert.assertEquals((String)"ContextualTextIO.Read", (String)ContextualTextIO.read().from("somefile").toString());
        }

        private ContextualTextIOSource prepareSource(byte[] data, boolean hasRFC4180Multiline) throws IOException {
            return ContextualTextIOTest.prepareSource(this.tempFolder, data, null, hasRFC4180Multiline);
        }

        private ContextualTextIOSource prepareSource(byte[] data) throws IOException {
            return ContextualTextIOTest.prepareSource(this.tempFolder, data, null, false);
        }

        @Test
        public void testProgressEmptyFile() throws IOException {
            try (BoundedSource.BoundedReader reader = this.prepareSource(new byte[0]).createReader(PipelineOptionsFactory.create());){
                Assert.assertEquals((double)0.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
                Assert.assertEquals((long)0L, (long)reader.getSplitPointsConsumed());
                Assert.assertEquals((long)-1L, (long)reader.getSplitPointsRemaining());
                Assert.assertFalse((boolean)reader.start());
                Assert.assertEquals((double)1.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
                Assert.assertEquals((long)0L, (long)reader.getSplitPointsConsumed());
                Assert.assertEquals((long)0L, (long)reader.getSplitPointsRemaining());
            }
        }

        @Test
        public void testProgressTextFile() throws IOException {
            String file = "line1\nline2\nline3";
            try (BoundedSource.BoundedReader reader = this.prepareSource(file.getBytes(Charsets.UTF_8)).createReader(PipelineOptionsFactory.create());){
                Assert.assertEquals((double)0.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
                Assert.assertEquals((long)0L, (long)reader.getSplitPointsConsumed());
                Assert.assertEquals((long)-1L, (long)reader.getSplitPointsRemaining());
                Assert.assertTrue((boolean)reader.start());
                Assert.assertEquals((long)0L, (long)reader.getSplitPointsConsumed());
                Assert.assertEquals((long)-1L, (long)reader.getSplitPointsRemaining());
                Assert.assertTrue((boolean)reader.advance());
                Assert.assertEquals((long)1L, (long)reader.getSplitPointsConsumed());
                Assert.assertEquals((long)-1L, (long)reader.getSplitPointsRemaining());
                Assert.assertTrue((boolean)reader.advance());
                Assert.assertEquals((long)2L, (long)reader.getSplitPointsConsumed());
                Assert.assertEquals((long)1L, (long)reader.getSplitPointsRemaining());
                Assert.assertFalse((boolean)reader.advance());
                Assert.assertEquals((double)1.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
                Assert.assertEquals((long)3L, (long)reader.getSplitPointsConsumed());
                Assert.assertEquals((long)0L, (long)reader.getSplitPointsRemaining());
            }
        }

        @Test
        public void testProgressAfterSplitting() throws IOException {
            BoundedSource remainder;
            String file = "line1\nline2\nline3";
            ContextualTextIOSource source = this.prepareSource(file.getBytes(Charsets.UTF_8));
            try (BoundedSource.BoundedReader readerOrig = source.createReader(PipelineOptionsFactory.create());){
                Assert.assertEquals((double)0.0, (double)readerOrig.getFractionConsumed(), (double)1.0E-6);
                Assert.assertEquals((long)0L, (long)readerOrig.getSplitPointsConsumed());
                Assert.assertEquals((long)-1L, (long)readerOrig.getSplitPointsRemaining());
                Assert.assertTrue((boolean)readerOrig.start());
                Assert.assertEquals((long)0L, (long)readerOrig.getSplitPointsConsumed());
                Assert.assertEquals((long)-1L, (long)readerOrig.getSplitPointsRemaining());
                remainder = readerOrig.splitAtFraction(0.1);
                System.err.println(readerOrig.getCurrentSource());
                Assert.assertNotNull((Object)remainder);
                Assert.assertEquals((long)0L, (long)readerOrig.getSplitPointsConsumed());
                Assert.assertEquals((long)1L, (long)readerOrig.getSplitPointsRemaining());
                Assert.assertFalse((boolean)readerOrig.advance());
                Assert.assertEquals((double)1.0, (double)readerOrig.getFractionConsumed(), (double)1.0E-6);
                Assert.assertEquals((long)1L, (long)readerOrig.getSplitPointsConsumed());
                Assert.assertEquals((long)0L, (long)readerOrig.getSplitPointsRemaining());
            }
            var5_4 = null;
            try (BoundedSource.BoundedReader reader = remainder.createReader(PipelineOptionsFactory.create());){
                Assert.assertEquals((double)0.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
                Assert.assertEquals((long)0L, (long)reader.getSplitPointsConsumed());
                Assert.assertEquals((long)-1L, (long)reader.getSplitPointsRemaining());
                Assert.assertTrue((boolean)reader.start());
                Assert.assertEquals((long)0L, (long)reader.getSplitPointsConsumed());
                Assert.assertEquals((long)-1L, (long)reader.getSplitPointsRemaining());
                Assert.assertTrue((boolean)reader.advance());
                Assert.assertEquals((long)1L, (long)reader.getSplitPointsConsumed());
                Assert.assertEquals((long)1L, (long)reader.getSplitPointsRemaining());
                Assert.assertFalse((boolean)reader.advance());
                Assert.assertEquals((double)1.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
                Assert.assertEquals((long)2L, (long)reader.getSplitPointsConsumed());
                Assert.assertEquals((long)0L, (long)reader.getSplitPointsRemaining());
            }
            catch (Throwable throwable) {
                var5_4 = throwable;
                throw throwable;
            }
        }

        @Test
        public void testInitialSplitAutoModeGz() throws Exception {
            PipelineOptions options = TestPipeline.testingPipelineOptions();
            long desiredBundleSize = 1000L;
            File largeGz = ContextualTextIOTest.writeToFile(LARGE, this.tempFolder, "large.gz", Compression.GZIP);
            MatcherAssert.assertThat((Object)largeGz.length(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(2L * desiredBundleSize)));
            FileBasedSource source = ContextualTextIO.read().from(largeGz.getPath()).getSource();
            List splits = source.split(desiredBundleSize, options);
            MatcherAssert.assertThat((Object)splits, (Matcher)Matchers.hasSize((Matcher)Matchers.equalTo((Object)1)));
            SourceTestUtils.assertSourcesEqualReferenceSource((BoundedSource)source, (List)splits, (PipelineOptions)options);
        }

        @Test
        public void testInitialSplitGzipModeTxt() throws Exception {
            PipelineOptions options = TestPipeline.testingPipelineOptions();
            long desiredBundleSize = 1000L;
            File largeTxt = ContextualTextIOTest.writeToFile(LARGE, this.tempFolder, "large.txt", Compression.UNCOMPRESSED);
            MatcherAssert.assertThat((Object)largeTxt.length(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(2L * desiredBundleSize)));
            FileBasedSource source = ContextualTextIO.read().from(largeTxt.getPath()).withCompression(Compression.GZIP).getSource();
            List splits = source.split(desiredBundleSize, options);
            MatcherAssert.assertThat((Object)splits, (Matcher)Matchers.hasSize((Matcher)Matchers.equalTo((Object)1)));
            SourceTestUtils.assertSourcesEqualReferenceSource((BoundedSource)source, (List)splits, (PipelineOptions)options);
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testReadFiles() throws IOException {
            Path tempFolderPath = this.tempFolder.getRoot().toPath();
            ContextualTextIOTest.writeToFile(TINY, this.tempFolder, "readAllTiny1.zip", Compression.ZIP);
            ContextualTextIOTest.writeToFile(TINY, this.tempFolder, "readAllTiny2.txt", Compression.UNCOMPRESSED);
            ContextualTextIOTest.writeToFile(LARGE, this.tempFolder, "readAllLarge1.zip", Compression.ZIP);
            ContextualTextIOTest.writeToFile(LARGE, this.tempFolder, "readAllLarge2.txt", Compression.UNCOMPRESSED);
            PCollection lines = (PCollection)((PCollection)((PCollection)((PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)tempFolderPath.resolve("readAllTiny*").toString(), (Object[])new String[]{tempFolderPath.resolve("readAllLarge*").toString()}))).apply((PTransform)FileIO.matchAll())).apply((PTransform)FileIO.readMatches().withCompression(Compression.AUTO))).apply((PTransform)ContextualTextIO.readFiles().withDesiredBundleSizeBytes(10L))).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)L -> L.getString(ContextualTextIOTest.VALUE)));
            PAssert.that((PCollection)lines).containsInAnyOrder(Iterables.concat((Iterable)TINY, (Iterable)TINY, (Iterable)LARGE, (Iterable)LARGE));
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class, UsesUnboundedSplittableParDo.class})
        public void testReadWatchForNewFiles() throws IOException, InterruptedException {
            Path basePath = this.tempFolder.getRoot().toPath().resolve("readWatch");
            basePath.toFile().mkdir();
            ((PCollection)((PCollection)((PCollection)this.p.apply((PTransform)GenerateSequence.from((long)0L).to(10L).withRate(1L, Duration.millis((long)100L)))).apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)150L))).withAllowedLateness(Duration.ZERO).triggering((Trigger)Repeatedly.forever((Trigger)AfterPane.elementCountAtLeast((int)1))).discardingFiredPanes())).apply(ToString.elements())).apply((PTransform)TextIO.write().to(basePath.resolve("data").toString()).withNumShards(1).withWindowedWrites());
            PCollection lines = (PCollection)((PCollection)((PCollection)((PCollection)this.p.apply((PTransform)FileIO.match().filepattern(basePath.resolve("*").toString()).continuously(Duration.millis((long)100L), (Watch.Growth.TerminationCondition)Watch.Growth.afterTimeSinceNewOutput((ReadableDuration)Duration.standardSeconds((long)3L))))).apply((PTransform)FileIO.readMatches())).apply((PTransform)ContextualTextIO.readFiles())).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)L -> L.getString(ContextualTextIOTest.VALUE)));
            PAssert.that((PCollection)lines).containsInAnyOrder((Object[])new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"});
            this.p.run();
        }

        public static interface RuntimeTestOptions
        extends PipelineOptions {
            public ValueProvider<String> getInput();

            public void setInput(ValueProvider<String> var1);
        }

        public static class GetDetails
        extends DoFn<Row, String> {
            @DoFn.ProcessElement
            public void processElement(@DoFn.Element Row record, DoFn.OutputReceiver<String> out) {
                out.output((Object)(((ResourceId)record.getLogicalTypeValue("resourceId", ResourceId.class)).toString() + " " + record.getInt64("recordNum") + " " + record.getString(ContextualTextIOTest.VALUE)));
            }
        }

        public static class GetLines
        extends DoFn<Row, String> {
            @DoFn.ProcessElement
            public void processElement(@DoFn.Element Row record, DoFn.OutputReceiver<String> out) {
                out.output((Object)record.getString(ContextualTextIOTest.VALUE));
            }
        }
    }

    @RunWith(value=JUnit4.class)
    public static class ContextualTextIOSpecificTests {
        @Rule
        public TemporaryFolder tempFolder = new TemporaryFolder();
        @Rule
        public TestPipeline p = TestPipeline.create();
        public static final char CR = '\r';
        public static final char LF = '\n';
        public static final String CRLF = "\r\n";

        public String createFileFromList(List<String> input) throws Exception {
            File tmpFile = this.tempFolder.newFile();
            String filename = tmpFile.getPath();
            try (PrintStream writer = new PrintStream(new FileOutputStream(tmpFile));){
                for (String elem : input) {
                    byte[] encodedElem = CoderUtils.encodeToByteArray((Coder)StringUtf8Coder.of(), (Object)elem);
                    String line = new String(encodedElem, Charsets.UTF_8);
                    writer.println(line);
                }
            }
            return filename;
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void multipleFilesTest() throws Exception {
            List<File> files = Arrays.asList(this.tempFolder.newFile("File1"), this.tempFolder.newFile("File2"), this.tempFolder.newFile("File3"));
            int numLines = 10;
            for (File tmpFile : files) {
                numLines += 2;
                String filename = tmpFile.getPath();
                try (PrintStream writer = new PrintStream(new FileOutputStream(tmpFile));){
                    for (int lineNum = 0; lineNum < numLines; ++lineNum) {
                        String elem = filename + " " + lineNum;
                        byte[] encodedElem = CoderUtils.encodeToByteArray((Coder)StringUtf8Coder.of(), (Object)elem);
                        String line = new String(encodedElem, Charsets.UTF_8);
                        writer.println(line);
                    }
                }
            }
            String filePath = this.tempFolder.getRoot().toPath() + "/*";
            ((PCollection)this.p.apply((PTransform)ContextualTextIO.read().withRecordNumMetadata().from(filePath))).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)L -> {
                String expectedLineNum = L.getString(ContextualTextIOTest.VALUE).substring(L.getString(ContextualTextIOTest.VALUE).lastIndexOf(32) + 1);
                Assert.assertEquals((long)Long.parseLong(expectedLineNum), (long)L.getInt64("recordNum"));
                return "";
            }));
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testWithHintMatchesManyFiles() throws IOException {
            List<File> files = Arrays.asList(this.tempFolder.newFile("File1"), this.tempFolder.newFile("File2"), this.tempFolder.newFile("File3"));
            int num = 0;
            for (File tmpFile : files) {
                num += 2;
                String filename = tmpFile.getPath();
                try (PrintStream writer = new PrintStream(new FileOutputStream(tmpFile));){
                    for (int lineNum = 0; lineNum < 10 + num; ++lineNum) {
                        String elem = filename + " " + lineNum;
                        byte[] encodedElem = CoderUtils.encodeToByteArray((Coder)StringUtf8Coder.of(), (Object)elem);
                        String line = new String(encodedElem, Charsets.UTF_8);
                        writer.println(line);
                    }
                }
            }
            String filePath = this.tempFolder.getRoot().toPath() + "/*";
            ((PCollection)this.p.apply((PTransform)ContextualTextIO.read().withRecordNumMetadata().from(filePath).withHintMatchesManyFiles())).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)L -> {
                String expectedLineNum = L.getString(ContextualTextIOTest.VALUE).substring(L.getString(ContextualTextIOTest.VALUE).lastIndexOf(32) + 1);
                Assert.assertEquals((long)Long.parseLong(expectedLineNum), (long)L.getInt64("recordNum"));
                return "";
            }));
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void runBasicReadTest() throws Exception {
            ImmutableList input = ImmutableList.of((Object)"1", (Object)"2");
            ContextualTextIO.Read read = ContextualTextIO.read().from(this.createFileFromList((List<String>)input));
            PCollection output = (PCollection)this.p.apply((PTransform)read);
            PCollection result = (PCollection)output.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)x -> String.valueOf(x.getString(ContextualTextIOTest.VALUE))));
            PAssert.that((PCollection)result).containsInAnyOrder((Object[])new String[]{"1", "2"});
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void runBasicReadTestWithRFC4180Set() throws Exception {
            ImmutableList input = ImmutableList.of((Object)"1", (Object)"2");
            ContextualTextIO.Read read = ContextualTextIO.read().from(this.createFileFromList((List<String>)input)).withHasMultilineCSVRecords(Boolean.valueOf(true));
            PCollection output = (PCollection)this.p.apply((PTransform)read);
            PCollection result = (PCollection)output.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)x -> String.valueOf(x.getString(ContextualTextIOTest.VALUE))));
            PAssert.that((PCollection)result).containsInAnyOrder((Object[])new String[]{"1", "2"});
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void runSmallRFC4180MultiLineReadTest() throws Exception {
            List<String> input = IntStream.range(0, 2).mapToObj(x -> "\"" + x + CRLF + x + "\"").collect(Collectors.toList());
            ContextualTextIO.Read read = ContextualTextIO.read().from(this.createFileFromList(input)).withHasMultilineCSVRecords(Boolean.valueOf(true));
            PCollection output = (PCollection)this.p.apply((PTransform)read);
            PCollection result = (PCollection)output.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)x -> x.getString(ContextualTextIOTest.VALUE)));
            PAssert.that((PCollection)result).containsInAnyOrder(input);
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void runSmallRFC4180EscapedCharcatersReadTest() throws Exception {
            List<String> input = IntStream.range(0, 2).mapToObj(x -> "\"aaa\",\"b\"\"bb\",\"ccc\"").collect(Collectors.toList());
            ContextualTextIO.Read read = ContextualTextIO.read().from(this.createFileFromList(input)).withHasMultilineCSVRecords(Boolean.valueOf(true));
            PCollection output = (PCollection)this.p.apply((PTransform)read);
            PCollection result = (PCollection)output.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)x -> x.getString(ContextualTextIOTest.VALUE)));
            PAssert.that((PCollection)result).containsInAnyOrder(input);
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void runLargeRFC4180MultiLineReadTest() throws Exception {
            List<String> input = IntStream.range(0, 1000).mapToObj(x -> "\"" + x + CRLF + x + "\"").collect(Collectors.toList());
            ContextualTextIO.Read read = ContextualTextIO.read().from(this.createFileFromList(input)).withHasMultilineCSVRecords(Boolean.valueOf(true));
            PCollection output = (PCollection)this.p.apply((PTransform)read);
            PCollection result = (PCollection)output.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)x -> x.getString(ContextualTextIOTest.VALUE)));
            PAssert.that((PCollection)result).containsInAnyOrder(input);
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void runLargeRFC4180MultiLineAndEscapedReadTest() throws Exception {
            List<String> input = IntStream.range(0, 1000).mapToObj(x -> "\"a\r\naa\",\"b\"\"\r\nbb\",\"ccc\",\"\"\"\\nHello\"").collect(Collectors.toList());
            ContextualTextIO.Read read = ContextualTextIO.read().from(this.createFileFromList(input)).withHasMultilineCSVRecords(Boolean.valueOf(true));
            PCollection output = (PCollection)this.p.apply((PTransform)read);
            PCollection result = (PCollection)output.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)x -> x.getString(ContextualTextIOTest.VALUE)));
            PAssert.that((PCollection)result).containsInAnyOrder(input);
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testFileNameIsPreserved() throws Exception {
            List<String> input = IntStream.range(1, 1000).mapToObj(x -> Integer.toString(x)).collect(Collectors.toList());
            ContextualTextIO.Read read = ContextualTextIO.read().from(this.createFileFromList(input)).withHasMultilineCSVRecords(Boolean.valueOf(true));
            PCollection output = (PCollection)this.p.apply((PTransform)read);
            PCollection result = (PCollection)output.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)x -> x.getString(ContextualTextIOTest.VALUE)));
            PAssert.that((PCollection)result).containsInAnyOrder(input);
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testFileNameIsPreservedWithoutLineMetadata() throws Exception {
            List<String> input = IntStream.range(1, 1000).mapToObj(x -> Integer.toString(x)).collect(Collectors.toList());
            ContextualTextIO.Read read = ContextualTextIO.read().from(this.createFileFromList(input)).withHasMultilineCSVRecords(Boolean.valueOf(true));
            PCollection output = (PCollection)this.p.apply((PTransform)read);
            PCollection result = (PCollection)output.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)x -> x.getString(ContextualTextIOTest.VALUE)));
            PAssert.that((PCollection)result).containsInAnyOrder(input);
            this.p.run();
        }
    }

    @RunWith(value=Parameterized.class)
    public static class ReadWithDelimiterAndRFC4180 {
        static final ImmutableList<String> EXPECTED = ImmutableList.of((Object)"\"asdf\nhjkl\nmnop\"", (Object)"xyz");
        @Rule
        public TemporaryFolder tempFolder = new TemporaryFolder();
        @Parameterized.Parameter(value=0)
        public String line;
        @Parameterized.Parameter(value=1)
        public ImmutableList<String> expected;

        @Parameterized.Parameters(name="{index}: {0}")
        public static Iterable<Object[]> data() {
            return ImmutableList.builder().add((Object)new Object[]{"\n\n\n", ImmutableList.of((Object)"", (Object)"", (Object)"")}).add((Object)new Object[]{"\"asdf\nhjkl\"\nxyz\n", ImmutableList.of((Object)"\"asdf\nhjkl\"", (Object)"xyz")}).add((Object)new Object[]{"\"asdf\nhjkl\nmnop\"\nxyz\n", EXPECTED}).add((Object)new Object[]{"\"asdf\nhjkl\nmnop\"\nxyz\r", EXPECTED}).add((Object)new Object[]{"\"asdf\nhjkl\nmnop\"\r\nxyz\n", EXPECTED}).add((Object)new Object[]{"\"asdf\nhjkl\nmnop\"\r\nxyz\r\n", EXPECTED}).add((Object)new Object[]{"\"asdf\nhjkl\nmnop\"\rxyz\r\n", EXPECTED}).build();
        }

        @Test
        public void testReadLinesWithDelimiter() throws Exception {
            this.runTestReadWithData(this.line.getBytes(StandardCharsets.UTF_8), (List<String>)this.expected);
        }

        private ContextualTextIOSource prepareSource(byte[] data, boolean hasRFC4180Multiline) throws IOException {
            return ContextualTextIOTest.prepareSource(this.tempFolder, data, null, hasRFC4180Multiline);
        }

        private void runTestReadWithData(byte[] data, List<String> expectedResults) throws Exception {
            ContextualTextIOSource source = this.prepareSource(data, true);
            List actual = SourceTestUtils.readFromSource((BoundedSource)source, (PipelineOptions)PipelineOptionsFactory.create());
            ArrayList actualOutput = new ArrayList();
            actual.forEach(L -> actualOutput.add((String)L.getValue(ContextualTextIOTest.VALUE)));
            MatcherAssert.assertThat(actualOutput, (Matcher)Matchers.containsInAnyOrder((Object[])new ArrayList<String>(expectedResults).toArray(new String[0])));
        }
    }

    @RunWith(value=Parameterized.class)
    public static class ReadWithDelimiterTest {
        private static final ImmutableList<String> EXPECTED = ImmutableList.of((Object)"asdf", (Object)"hjkl", (Object)"xyz");
        @Rule
        public TemporaryFolder tempFolder = new TemporaryFolder();
        @Parameterized.Parameter(value=0)
        public String line;
        @Parameterized.Parameter(value=1)
        public ImmutableList<String> expected;

        @Parameterized.Parameters(name="{index}: {0}")
        public static Iterable<Object[]> data() {
            return ImmutableList.builder().add((Object)new Object[]{"asdf\nhjkl\nxyz\n", EXPECTED}).add((Object)new Object[]{"asdf\rhjkl\rxyz\r", EXPECTED}).add((Object)new Object[]{"asdf\r\nhjkl\r\nxyz\r\n", EXPECTED}).add((Object)new Object[]{"asdf\rhjkl\r\nxyz\n", EXPECTED}).add((Object)new Object[]{"asdf\nhjkl\nxyz", EXPECTED}).add((Object)new Object[]{"asdf\rhjkl\rxyz", EXPECTED}).add((Object)new Object[]{"asdf\r\nhjkl\r\nxyz", EXPECTED}).add((Object)new Object[]{"asdf\rhjkl\r\nxyz", EXPECTED}).build();
        }

        @Test
        public void testReadLinesWithDelimiter() throws Exception {
            this.runTestReadWithData(this.line.getBytes(StandardCharsets.UTF_8), (List<String>)this.expected);
        }

        private ContextualTextIOSource prepareSource(byte[] data, boolean hasRFC4180Multiline) throws IOException {
            return ContextualTextIOTest.prepareSource(this.tempFolder, data, null, hasRFC4180Multiline);
        }

        private void runTestReadWithData(byte[] data, List<String> expectedResults) throws Exception {
            ContextualTextIOSource source = this.prepareSource(data, false);
            List actual = SourceTestUtils.readFromSource((BoundedSource)source, (PipelineOptions)PipelineOptionsFactory.create());
            ArrayList actualOutput = new ArrayList();
            actual.forEach(L -> actualOutput.add(L.getString(ContextualTextIOTest.VALUE)));
            MatcherAssert.assertThat(actualOutput, (Matcher)Matchers.containsInAnyOrder((Object[])new ArrayList<String>(expectedResults).toArray(new String[0])));
        }
    }

    @RunWith(value=Parameterized.class)
    public static class CompressedReadTest {
        @Rule
        public TemporaryFolder tempFolder = new TemporaryFolder();
        @Rule
        public TestPipeline p = TestPipeline.create();
        @Parameterized.Parameter(value=0)
        public List<String> lines;
        @Parameterized.Parameter(value=1)
        public Compression compression;

        @Parameterized.Parameters(name="{index}: {1}")
        public static Iterable<Object[]> data() {
            return ImmutableList.builder().add((Object)new Object[]{EMPTY, Compression.UNCOMPRESSED}).add((Object)new Object[]{EMPTY, Compression.GZIP}).add((Object)new Object[]{EMPTY, Compression.BZIP2}).add((Object)new Object[]{EMPTY, Compression.ZIP}).add((Object)new Object[]{EMPTY, Compression.DEFLATE}).add((Object)new Object[]{TINY, Compression.UNCOMPRESSED}).add((Object)new Object[]{TINY, Compression.GZIP}).add((Object)new Object[]{TINY, Compression.BZIP2}).add((Object)new Object[]{TINY, Compression.ZIP}).add((Object)new Object[]{TINY, Compression.DEFLATE}).add((Object)new Object[]{LARGE, Compression.UNCOMPRESSED}).add((Object)new Object[]{LARGE, Compression.GZIP}).add((Object)new Object[]{LARGE, Compression.BZIP2}).add((Object)new Object[]{LARGE, Compression.ZIP}).add((Object)new Object[]{LARGE, Compression.DEFLATE}).build();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testCompressedReadWithoutExtension() throws Exception {
            String fileName = this.lines.size() + "_" + this.compression + "_no_extension";
            File fileWithNoExtension = ContextualTextIOTest.writeToFile(this.lines, this.tempFolder, fileName, this.compression);
            ContextualTextIOTest.assertReadingCompressedFileMatchesExpected(fileWithNoExtension, this.compression, this.lines, (Pipeline)this.p);
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testCompressedReadWithExtension() throws Exception {
            String fileName = this.lines.size() + "_" + this.compression + "_no_extension" + ContextualTextIOTest.getFileSuffix(this.compression);
            File fileWithExtension = ContextualTextIOTest.writeToFile(this.lines, this.tempFolder, fileName, this.compression);
            if (this.lines.size() == 1024 && !this.compression.equals((Object)Compression.UNCOMPRESSED)) {
                File uncompressedFile = ContextualTextIOTest.writeToFile(this.lines, this.tempFolder, "large.txt", Compression.UNCOMPRESSED);
                MatcherAssert.assertThat((Object)uncompressedFile.length(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(fileWithExtension.length())));
            }
            ContextualTextIOTest.assertReadingCompressedFileMatchesExpected(fileWithExtension, this.compression, this.lines, (Pipeline)this.p);
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testReadWithAuto() throws Exception {
            String fileName = this.lines.size() + "_" + this.compression + "_no_extension" + ContextualTextIOTest.getFileSuffix(this.compression);
            File fileWithExtension = ContextualTextIOTest.writeToFile(this.lines, this.tempFolder, fileName, this.compression);
            ContextualTextIOTest.assertReadingCompressedFileMatchesExpected(fileWithExtension, Compression.AUTO, this.lines, (Pipeline)this.p);
            this.p.run();
        }
    }

    private static class ConvertRecordWithMetadataToString
    extends DoFn<Row, String> {
        private ConvertRecordWithMetadataToString() {
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element Row record, DoFn.OutputReceiver<String> out) {
            String resourceId = ((ResourceId)record.getLogicalTypeValue("resourceId", ResourceId.class)).toString();
            String file = resourceId.substring(resourceId.lastIndexOf(47) + 1);
            out.output((Object)(file + " " + record.getValue("recordNum") + " " + record.getString(ContextualTextIOTest.VALUE)));
        }
    }

    private static class ConvertRecordToString
    extends DoFn<Row, String> {
        private ConvertRecordToString() {
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element Row record, DoFn.OutputReceiver<String> out) {
            String resourceId = ((ResourceId)record.getLogicalTypeValue("resourceId", ResourceId.class)).toString();
            String file = resourceId.substring(resourceId.lastIndexOf(47) + 1);
            out.output((Object)(file + " " + record.getString(ContextualTextIOTest.VALUE)));
        }
    }
}

