/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.common;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.apache.beam.sdk.io.common.AutoValue_TestRow;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdks.java.io.common.repackaged.com.google.common.collect.ImmutableMap;

@AutoValue
public abstract class TestRow
implements Serializable,
Comparable<TestRow> {
    private static final Map<Integer, String> EXPECTED_HASHES = ImmutableMap.of((Object)1000, (Object)"7d94d63a41164be058a9680002914358", (Object)100000, (Object)"c7cbddb319209e200f1c5eebef8fe960", (Object)600000, (Object)"e2add2f680de9024e9bc46cd3912545e", (Object)5000000, (Object)"c44f8a5648cd9207c9c6f77395a998dc");

    public static TestRow create(Integer id, String name) {
        return new AutoValue_TestRow(id, name);
    }

    public abstract Integer id();

    public abstract String name();

    @Override
    public int compareTo(TestRow other) {
        return this.id().compareTo(other.id());
    }

    public static TestRow fromSeed(Integer seed) {
        return TestRow.create(seed, TestRow.getNameForSeed(seed));
    }

    public static String getNameForSeed(Integer seed) {
        return "Testval" + seed;
    }

    public static Iterable<TestRow> getExpectedValues(int rangeStart, int rangeEnd) {
        ArrayList<TestRow> ret = new ArrayList<TestRow>(rangeEnd - rangeStart + 1);
        for (int i = rangeStart; i < rangeEnd; ++i) {
            ret.add(TestRow.fromSeed(i));
        }
        return ret;
    }

    public static String getExpectedHashForRowCount(int rowCount) throws UnsupportedOperationException {
        String hash = EXPECTED_HASHES.get(rowCount);
        if (hash == null) {
            throw new UnsupportedOperationException("No hash for that row count");
        }
        return hash;
    }

    public static class SelectNameFn
    extends DoFn<TestRow, String> {
        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output((Object)((TestRow)c.element()).name());
        }
    }

    public static class DeterministicallyConstructTestRowFn
    extends DoFn<Long, TestRow> {
        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output((Object)TestRow.fromSeed(((Long)c.element()).intValue()));
        }
    }
}

