/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.common;

import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.testing.TestPipelineOptions;

public interface IOTestPipelineOptions
extends TestPipelineOptions {
    @Description(value="Server name for postgres server (host name/ip address)")
    @Default.String(value="postgres-server-name")
    public String getPostgresServerName();

    public void setPostgresServerName(String var1);

    @Description(value="Username for postgres server")
    @Default.String(value="postgres-username")
    public String getPostgresUsername();

    public void setPostgresUsername(String var1);

    @Description(value="Password for postgres server")
    @Default.String(value="postgres-password")
    public String getPostgresPassword();

    public void setPostgresPassword(String var1);

    @Description(value="Database name for postgres server")
    @Default.String(value="postgres-database-name")
    public String getPostgresDatabaseName();

    public void setPostgresDatabaseName(String var1);

    @Description(value="Port for postgres server")
    @Default.Integer(value=0)
    public Integer getPostgresPort();

    public void setPostgresPort(Integer var1);

    @Description(value="Whether the postgres server uses SSL")
    @Default.Boolean(value=true)
    public Boolean getPostgresSsl();

    public void setPostgresSsl(Boolean var1);

    @Description(value="Server name for Elasticsearch server (host name/ip address)")
    @Default.String(value="elasticsearch-server-name")
    public String getElasticsearchServer();

    public void setElasticsearchServer(String var1);

    @Description(value="Http port for elasticsearch server")
    @Default.Integer(value=9200)
    public Integer getElasticsearchHttpPort();

    public void setElasticsearchHttpPort(Integer var1);

    @Description(value="Address of Zookeeper server for Solr")
    @Default.String(value="zookeeper-server")
    public String getSolrZookeeperServer();

    public void setSolrZookeeperServer(String var1);

    @Description(value="Host for Cassandra server (host name/ip address)")
    @Default.String(value="cassandra-host")
    public String getCassandraHost();

    public void setCassandraHost(String var1);

    @Description(value="Port for Cassandra server")
    @Default.Integer(value=7001)
    public Integer getCassandraPort();

    public void setCassandraPort(Integer var1);

    @Description(value="Number records that will be written and read by the test")
    @Default.Integer(value=100000)
    public Integer getNumberOfRecords();

    public void setNumberOfRecords(Integer var1);

    @Description(value="Destination prefix for files generated by the test")
    @Validation.Required
    public String getFilenamePrefix();

    public void setFilenamePrefix(String var1);

    @Description(value="File compression type for writing and reading test files")
    @Default.String(value="UNCOMPRESSED")
    public String getCompressionType();

    public void setCompressionType(String var1);
}

