/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.common;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.sql.DataSource;
import org.apache.beam.sdk.io.common.IOTestPipelineOptions;
import org.postgresql.ds.PGSimpleDataSource;

public class DatabaseTestHelper {
    public static PGSimpleDataSource getPostgresDataSource(IOTestPipelineOptions options) {
        PGSimpleDataSource dataSource = new PGSimpleDataSource();
        dataSource.setDatabaseName(options.getPostgresDatabaseName());
        dataSource.setServerName(options.getPostgresServerName());
        dataSource.setPortNumber(options.getPostgresPort().intValue());
        dataSource.setUser(options.getPostgresUsername());
        dataSource.setPassword(options.getPostgresPassword());
        dataSource.setSsl(options.getPostgresSsl().booleanValue());
        return dataSource;
    }

    public static void createTable(DataSource dataSource, String tableName) throws SQLException {
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(String.format("create table %s (id INT, name VARCHAR(500))", tableName));
        }
    }

    public static void deleteTable(DataSource dataSource, String tableName) throws SQLException {
        if (tableName != null) {
            try (Connection connection = dataSource.getConnection();
                 Statement statement = connection.createStatement();){
                statement.executeUpdate(String.format("drop table %s", tableName));
            }
        }
    }

    public static String getTestTableName(String testIdentifier) {
        SimpleDateFormat formatter = new SimpleDateFormat();
        formatter.applyPattern("yyyy_MM_dd_HH_mm_ss_S");
        return String.format("BEAMTEST_%s_%s", testIdentifier, formatter.format(new Date()));
    }

    public static String getPostgresDBUrl(IOTestPipelineOptions options) {
        return String.format("jdbc:postgresql://%s:%s/%s", options.getPostgresServerName(), options.getPostgresPort(), options.getPostgresDatabaseName());
    }
}

