/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.common;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.beam.sdk.io.common.AutoValue_TestRow;
import org.apache.beam.sdk.io.common.IOITHelper;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

@AutoValue
public abstract class TestRow
implements Serializable,
Comparable<TestRow> {
    private static final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized String> EXPECTED_HASHES = ImmutableMap.of((Object)1000, (Object)"7d94d63a41164be058a9680002914358", (Object)100000, (Object)"c7cbddb319209e200f1c5eebef8fe960", (Object)600000, (Object)"e2add2f680de9024e9bc46cd3912545e", (Object)5000000, (Object)"c44f8a5648cd9207c9c6f77395a998dc");

    public static @UnknownKeyFor @NonNull @Initialized TestRow create(@UnknownKeyFor @NonNull @Initialized Integer id, @UnknownKeyFor @NonNull @Initialized String name) {
        return new AutoValue_TestRow(id, name);
    }

    public abstract @UnknownKeyFor @NonNull @Initialized Integer id();

    public abstract @UnknownKeyFor @NonNull @Initialized String name();

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized int compareTo(@UnknownKeyFor @NonNull @Initialized TestRow other) {
        return this.id().compareTo(other.id());
    }

    public static @UnknownKeyFor @NonNull @Initialized TestRow fromSeed(@UnknownKeyFor @NonNull @Initialized Integer seed) {
        return TestRow.create(seed, TestRow.getNameForSeed(seed));
    }

    public static @UnknownKeyFor @NonNull @Initialized String getNameForSeed(@UnknownKeyFor @NonNull @Initialized Integer seed) {
        return "Testval" + seed;
    }

    public static @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized TestRow> getExpectedValues(@UnknownKeyFor @NonNull @Initialized int rangeStart, @UnknownKeyFor @NonNull @Initialized int rangeEnd) {
        ArrayList<TestRow> ret = new ArrayList<TestRow>(rangeEnd - rangeStart + 1);
        for (int i = rangeStart; i < rangeEnd; ++i) {
            ret.add(TestRow.fromSeed(i));
        }
        return ret;
    }

    public static @UnknownKeyFor @NonNull @Initialized String getExpectedHashForRowCount(@UnknownKeyFor @NonNull @Initialized int rowCount) throws @UnknownKeyFor @NonNull @Initialized UnsupportedOperationException {
        return IOITHelper.getHashForRecordCount(rowCount, EXPECTED_HASHES);
    }

    public static class SelectNameFn
    extends DoFn<TestRow, String> {
        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            c.output((Object)((TestRow)c.element()).name());
        }
    }

    public static class DeterministicallyConstructTestRowFn
    extends DoFn<Long, TestRow> {
        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            c.output((Object)TestRow.fromSeed(((Long)c.element()).intValue()));
        }
    }
}

