/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.common;

import org.apache.beam.sdk.io.common.IOTestPipelineOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.Validation;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface PostgresIOTestPipelineOptions
extends IOTestPipelineOptions {
    @Description(value="Server name for postgres server (host name/ip address)")
    @Validation.Required
    public @UnknownKeyFor @NonNull @Initialized String getPostgresServerName();

    public void setPostgresServerName(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Username for postgres server")
    @Validation.Required
    public @UnknownKeyFor @NonNull @Initialized String getPostgresUsername();

    public void setPostgresUsername(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Password for postgres server")
    @Validation.Required
    public @UnknownKeyFor @NonNull @Initialized String getPostgresPassword();

    public void setPostgresPassword(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Database name for postgres server")
    @Validation.Required
    public @UnknownKeyFor @NonNull @Initialized String getPostgresDatabaseName();

    public void setPostgresDatabaseName(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Port for postgres server")
    @Default.Integer(value=5432)
    public @UnknownKeyFor @NonNull @Initialized Integer getPostgresPort();

    public void setPostgresPort(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="Whether the postgres server uses SSL")
    @Default.Boolean(value=true)
    public @UnknownKeyFor @NonNull @Initialized Boolean getPostgresSsl();

    public void setPostgresSsl(@UnknownKeyFor @NonNull @Initialized Boolean var1);
}

