/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.common;

import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.beam.sdk.io.common.IOITHelper;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IOITHelperTest {
    private static @UnknownKeyFor @NonNull @Initialized long startTimeMeasure;
    private static @UnknownKeyFor @NonNull @Initialized String message;
    private static @UnknownKeyFor @NonNull @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized Exception> listOfExceptionsThrown;
    @Rule
    public @UnknownKeyFor @NonNull @Initialized ExpectedException exceptionRule = ExpectedException.none();

    @Before
    public void setup() {
        listOfExceptionsThrown = new ArrayList();
    }

    @Test
    public void retryHealthyFunction() throws @UnknownKeyFor @NonNull @Initialized Exception {
        IOITHelper.executeWithRetry(IOITHelperTest::validFunction);
        Assert.assertEquals((Object)"The healthy function.", (Object)message);
    }

    @Test
    public void retryFunctionThatWillFail() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.exceptionRule.expect(SQLException.class);
        this.exceptionRule.expectMessage("Problem with connection");
        IOITHelper.executeWithRetry(IOITHelperTest::failingFunction);
        Assert.assertEquals((long)3L, (long)listOfExceptionsThrown.size());
    }

    @Test
    public void retryFunctionThatFailsWithMoreAttempts() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.exceptionRule.expect(SQLException.class);
        this.exceptionRule.expectMessage("Problem with connection");
        IOITHelper.executeWithRetry(4, 1000L, IOITHelperTest::failingFunction);
        Assert.assertEquals((long)4L, (long)listOfExceptionsThrown.size());
    }

    @Test
    public void retryFunctionThatRecovers() throws @UnknownKeyFor @NonNull @Initialized Exception {
        startTimeMeasure = System.currentTimeMillis();
        IOITHelper.executeWithRetry(IOITHelperTest::recoveringFunction);
        Assert.assertEquals((long)1L, (long)listOfExceptionsThrown.size());
    }

    @Test
    public void retryFunctionThatRecoversAfterBiggerDelay() throws @UnknownKeyFor @NonNull @Initialized Exception {
        startTimeMeasure = System.currentTimeMillis();
        IOITHelper.executeWithRetry(3, 2000L, IOITHelperTest::recoveringFunctionWithBiggerDelay);
        Assert.assertEquals((long)1L, (long)listOfExceptionsThrown.size());
    }

    private static void failingFunction() throws @UnknownKeyFor @NonNull @Initialized SQLException {
        SQLException e = new SQLException("Problem with connection");
        listOfExceptionsThrown.add(e);
        throw e;
    }

    private static void recoveringFunction() throws @UnknownKeyFor @NonNull @Initialized SQLException {
        if (System.currentTimeMillis() - startTimeMeasure < 1001L) {
            SQLException e = new SQLException("Problem with connection");
            listOfExceptionsThrown.add(e);
            throw e;
        }
    }

    private static void recoveringFunctionWithBiggerDelay() throws @UnknownKeyFor @NonNull @Initialized SQLException {
        if (System.currentTimeMillis() - startTimeMeasure < 2001L) {
            SQLException e = new SQLException("Problem with connection");
            listOfExceptionsThrown.add(e);
            throw e;
        }
    }

    private static void validFunction() throws @UnknownKeyFor @NonNull @Initialized SQLException {
        message = "The healthy function.";
    }

    static {
        message = "";
    }
}

