/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.common;

import java.util.Map;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.PipelineOptionsValidator;
import org.apache.beam.sdk.testing.TestPipeline;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOITHelper {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(IOITHelper.class);
    private static final @UnknownKeyFor @NonNull @Initialized int maxAttempts = 3;
    private static final @UnknownKeyFor @NonNull @Initialized long minDelay = 1000L;

    private IOITHelper() {
    }

    public static @UnknownKeyFor @NonNull @Initialized String getHashForRecordCount(@UnknownKeyFor @NonNull @Initialized int recordCount, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized String> hashes) {
        String hash = hashes.get(recordCount);
        if (hash == null) {
            throw new UnsupportedOperationException(String.format("No hash for that record count: %s", recordCount));
        }
        return hash;
    }

    public static <T extends PipelineOptions> T readIOTestPipelineOptions(@UnknownKeyFor @NonNull @Initialized Class<T> optionsType) {
        PipelineOptionsFactory.register(optionsType);
        PipelineOptions options = TestPipeline.testingPipelineOptions().as(optionsType);
        return (T)PipelineOptionsValidator.validate(optionsType, (PipelineOptions)options);
    }

    public static void executeWithRetry(@UnknownKeyFor @NonNull @Initialized RetryFunction function) throws @UnknownKeyFor @NonNull @Initialized Exception {
        IOITHelper.executeWithRetry(3, 1000L, function);
    }

    public static void executeWithRetry(@UnknownKeyFor @NonNull @Initialized int maxAttempts, @UnknownKeyFor @NonNull @Initialized long minDelay, @UnknownKeyFor @NonNull @Initialized RetryFunction function) throws @UnknownKeyFor @NonNull @Initialized Exception {
        long delay = minDelay;
        for (int attempts = 1; attempts <= maxAttempts; ++attempts) {
            try {
                function.run();
                return;
            }
            catch (Exception e) {
                LOG.warn("Attempt #{} of {} failed: {}.", new Object[]{attempts, maxAttempts, e.getMessage()});
                if (attempts == maxAttempts) {
                    throw e;
                }
                long nextDelay = (long)Math.pow(2.0, attempts) * delay;
                LOG.warn("Retrying in {} ms.", (Object)nextDelay);
                Thread.sleep(nextDelay);
                continue;
            }
        }
    }

    @FunctionalInterface
    public static interface RetryFunction {
        public void run() throws @UnknownKeyFor @NonNull @Initialized Exception;
    }
}

