/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.HashCode;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Hashing;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class HashingFn
extends Combine.CombineFn<String, Accum, String> {
    public @UnknownKeyFor @NonNull @Initialized Accum addInput(@UnknownKeyFor @NonNull @Initialized Accum accum, @UnknownKeyFor @NonNull @Initialized String input) {
        ArrayList elementHashes = Lists.newArrayList();
        if (accum.hashCode != null) {
            elementHashes.add(accum.hashCode);
        }
        HashCode inputHashCode = Hashing.murmur3_128().hashString((CharSequence)input, StandardCharsets.UTF_8);
        elementHashes.add(inputHashCode);
        accum.hashCode = Hashing.combineUnordered((Iterable)elementHashes);
        return accum;
    }

    public @UnknownKeyFor @NonNull @Initialized Accum mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Accum> accums) {
        Accum merged = this.createAccumulator();
        ArrayList elementHashes = Lists.newArrayList();
        for (Accum accum : accums) {
            if (accum.hashCode == null) continue;
            elementHashes.add(accum.hashCode);
        }
        merged.hashCode = Hashing.combineUnordered((Iterable)elementHashes);
        return merged;
    }

    public @UnknownKeyFor @NonNull @Initialized String extractOutput(@UnknownKeyFor @NonNull @Initialized Accum accum) {
        String consolidatedHash = "";
        if (accum.hashCode != null) {
            consolidatedHash = accum.hashCode.toString();
        }
        return consolidatedHash;
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Accum> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized String> inputCoder) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
        return SerializableCoder.of(Accum.class);
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized String> getDefaultOutputCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized String> inputCoder) {
        return inputCoder;
    }

    public @UnknownKeyFor @NonNull @Initialized Accum createAccumulator() {
        return new Accum(null);
    }

    public static class Accum
    implements Serializable {
        @UnknownKeyFor @NonNull @Initialized HashCode hashCode = null;

        public Accum(@UnknownKeyFor @NonNull @Initialized HashCode value) {
            this.hashCode = value;
        }

        private void readObject(@UnknownKeyFor @NonNull @Initialized ObjectInputStream in) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
            in.defaultReadObject();
        }

        private void writeObject(@UnknownKeyFor @NonNull @Initialized ObjectOutputStream out) throws @UnknownKeyFor @NonNull @Initialized IOException {
            out.defaultWriteObject();
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Accum accum = (Accum)o;
            return this.hashCode != null ? this.hashCode.equals((Object)accum.hashCode) : accum.hashCode == null;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return this.hashCode != null ? this.hashCode.hashCode() : 0;
        }
    }
}

