/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.common;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.beam.sdk.io.common.PostgresIOTestPipelineOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.postgresql.ds.PGSimpleDataSource;

public class DatabaseTestHelper {
    public static @UnknownKeyFor @NonNull @Initialized PGSimpleDataSource getPostgresDataSource(@UnknownKeyFor @NonNull @Initialized PostgresIOTestPipelineOptions options) {
        PGSimpleDataSource dataSource = new PGSimpleDataSource();
        dataSource.setDatabaseName(options.getPostgresDatabaseName());
        dataSource.setServerName(options.getPostgresServerName());
        dataSource.setPortNumber(options.getPostgresPort().intValue());
        dataSource.setUser(options.getPostgresUsername());
        dataSource.setPassword(options.getPostgresPassword());
        dataSource.setSsl(options.getPostgresSsl().booleanValue());
        return dataSource;
    }

    public static void createTable(@UnknownKeyFor @NonNull @Initialized DataSource dataSource, @UnknownKeyFor @NonNull @Initialized String tableName) throws @UnknownKeyFor @NonNull @Initialized SQLException {
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(String.format("create table %s (id INT, name VARCHAR(500))", tableName));
        }
    }

    public static void createTableForRowWithSchema(@UnknownKeyFor @NonNull @Initialized DataSource dataSource, @UnknownKeyFor @NonNull @Initialized String tableName) throws @UnknownKeyFor @NonNull @Initialized SQLException {
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(String.format("create table %s (name VARCHAR(500), id INT)", tableName));
        }
    }

    public static void deleteTable(@UnknownKeyFor @NonNull @Initialized DataSource dataSource, @UnknownKeyFor @NonNull @Initialized String tableName) throws @UnknownKeyFor @NonNull @Initialized SQLException {
        if (tableName != null) {
            try (Connection connection = dataSource.getConnection();
                 Statement statement = connection.createStatement();){
                statement.executeUpdate(String.format("drop table %s", tableName));
            }
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized String getTestTableName(@UnknownKeyFor @NonNull @Initialized String testIdentifier) {
        SimpleDateFormat formatter = new SimpleDateFormat();
        formatter.applyPattern("yyyy_MM_dd_HH_mm_ss_S");
        return String.format("BEAMTEST_%s_%s", testIdentifier, formatter.format(new Date()));
    }

    public static @UnknownKeyFor @NonNull @Initialized String getPostgresDBUrl(@UnknownKeyFor @NonNull @Initialized PostgresIOTestPipelineOptions options) {
        return String.format("jdbc:postgresql://%s:%s/%s", options.getPostgresServerName(), options.getPostgresPort(), options.getPostgresDatabaseName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Long> getPostgresTableSize(@UnknownKeyFor @NonNull @Initialized DataSource dataSource, @UnknownKeyFor @NonNull @Initialized String tableName) {
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            ResultSet resultSet = statement.executeQuery(String.format("select pg_relation_size('%s')", tableName));
            if (!resultSet.next()) return Optional.empty();
            Optional<Long> optional = Optional.of(resultSet.getLong(1));
            return optional;
        }
        catch (SQLException e) {
            return Optional.empty();
        }
    }

    public static void createTableWithStatement(@UnknownKeyFor @NonNull @Initialized DataSource dataSource, @UnknownKeyFor @NonNull @Initialized String stmt) throws @UnknownKeyFor @NonNull @Initialized SQLException {
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(stmt);
        }
    }
}

