/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdks.java.io.common.repackaged.com.google.common.collect.Lists;
import org.apache.beam.sdks.java.io.common.repackaged.com.google.common.hash.HashCode;
import org.apache.beam.sdks.java.io.common.repackaged.com.google.common.hash.Hashing;

public class HashingFn
extends Combine.CombineFn<String, Accum, String> {
    public Accum addInput(Accum accum, String input) {
        ArrayList elementHashes = Lists.newArrayList();
        if (accum.hashCode != null) {
            elementHashes.add(accum.hashCode);
        }
        HashCode inputHashCode = Hashing.murmur3_128().hashString((CharSequence)input, StandardCharsets.UTF_8);
        elementHashes.add(inputHashCode);
        accum.hashCode = Hashing.combineUnordered((Iterable)elementHashes);
        return accum;
    }

    public Accum mergeAccumulators(Iterable<Accum> accums) {
        Accum merged = this.createAccumulator();
        ArrayList elementHashes = Lists.newArrayList();
        for (Accum accum : accums) {
            if (accum.hashCode == null) continue;
            elementHashes.add(accum.hashCode);
        }
        merged.hashCode = Hashing.combineUnordered((Iterable)elementHashes);
        return merged;
    }

    public String extractOutput(Accum accum) {
        String consolidatedHash = "";
        if (accum.hashCode != null) {
            consolidatedHash = accum.hashCode.toString();
        }
        return consolidatedHash;
    }

    public Coder<Accum> getAccumulatorCoder(CoderRegistry registry, Coder<String> inputCoder) throws CannotProvideCoderException {
        return SerializableCoder.of(Accum.class);
    }

    public Coder<String> getDefaultOutputCoder(CoderRegistry registry, Coder<String> inputCoder) {
        return inputCoder;
    }

    public Accum createAccumulator() {
        return new Accum(null);
    }

    public static class Accum
    implements Serializable {
        HashCode hashCode = null;

        public Accum(HashCode value) {
            this.hashCode = value;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
        }
    }
}

