/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.clickhouse;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.beam.sdk.io.clickhouse.AutoValue_TableSchema;
import org.apache.beam.sdk.io.clickhouse.AutoValue_TableSchema_Column;
import org.apache.beam.sdk.io.clickhouse.AutoValue_TableSchema_ColumnType;
import org.apache.beam.sdk.io.clickhouse.impl.parser.ColumnTypeParser;
import org.apache.beam.sdk.io.clickhouse.impl.parser.ParseException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.FixedBytes;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoValue
public abstract class TableSchema
implements Serializable {
    public abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Column> columns();

    public static @UnknownKeyFor @NonNull @Initialized TableSchema of(Column ... columns) {
        return new AutoValue_TableSchema(Arrays.asList(columns));
    }

    public static @UnknownKeyFor @NonNull @Initialized Schema getEquivalentSchema(@UnknownKeyFor @NonNull @Initialized TableSchema tableSchema) {
        return (Schema)tableSchema.columns().stream().map(x -> {
            if (x.columnType().nullable()) {
                return Schema.Field.nullable((String)x.name(), (Schema.FieldType)TableSchema.getEquivalentFieldType(x.columnType()));
            }
            return Schema.Field.of((String)x.name(), (Schema.FieldType)TableSchema.getEquivalentFieldType(x.columnType()));
        }).collect(Schema.toSchema());
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType getEquivalentFieldType(@UnknownKeyFor @NonNull @Initialized ColumnType columnType) {
        switch (columnType.typeName()) {
            case DATE: 
            case DATETIME: {
                return Schema.FieldType.DATETIME;
            }
            case STRING: {
                return Schema.FieldType.STRING;
            }
            case FIXEDSTRING: {
                int size = columnType.fixedStringSize();
                return Schema.FieldType.logicalType((Schema.LogicalType)FixedBytes.of((int)size));
            }
            case FLOAT32: {
                return Schema.FieldType.FLOAT;
            }
            case FLOAT64: {
                return Schema.FieldType.DOUBLE;
            }
            case INT8: {
                return Schema.FieldType.BYTE;
            }
            case INT16: {
                return Schema.FieldType.INT16;
            }
            case INT32: {
                return Schema.FieldType.INT32;
            }
            case INT64: {
                return Schema.FieldType.INT64;
            }
            case UINT8: {
                return Schema.FieldType.INT16;
            }
            case UINT16: {
                return Schema.FieldType.INT32;
            }
            case UINT32: {
                return Schema.FieldType.INT64;
            }
            case UINT64: {
                return Schema.FieldType.INT64;
            }
            case ARRAY: {
                return Schema.FieldType.array((Schema.FieldType)TableSchema.getEquivalentFieldType(columnType.arrayElementType()));
            }
            case ENUM8: 
            case ENUM16: {
                return Schema.FieldType.STRING;
            }
        }
        throw new AssertionError((Object)("Unexpected type: " + (Object)((Object)columnType.typeName())));
    }

    @AutoValue
    public static abstract class ColumnType
    implements Serializable {
        public static final @UnknownKeyFor @NonNull @Initialized ColumnType DATE = ColumnType.of(TypeName.DATE);
        public static final @UnknownKeyFor @NonNull @Initialized ColumnType DATETIME = ColumnType.of(TypeName.DATETIME);
        public static final @UnknownKeyFor @NonNull @Initialized ColumnType FLOAT32 = ColumnType.of(TypeName.FLOAT32);
        public static final @UnknownKeyFor @NonNull @Initialized ColumnType FLOAT64 = ColumnType.of(TypeName.FLOAT64);
        public static final @UnknownKeyFor @NonNull @Initialized ColumnType INT8 = ColumnType.of(TypeName.INT8);
        public static final @UnknownKeyFor @NonNull @Initialized ColumnType INT16 = ColumnType.of(TypeName.INT16);
        public static final @UnknownKeyFor @NonNull @Initialized ColumnType INT32 = ColumnType.of(TypeName.INT32);
        public static final @UnknownKeyFor @NonNull @Initialized ColumnType INT64 = ColumnType.of(TypeName.INT64);
        public static final @UnknownKeyFor @NonNull @Initialized ColumnType STRING = ColumnType.of(TypeName.STRING);
        public static final @UnknownKeyFor @NonNull @Initialized ColumnType UINT8 = ColumnType.of(TypeName.UINT8);
        public static final @UnknownKeyFor @NonNull @Initialized ColumnType UINT16 = ColumnType.of(TypeName.UINT16);
        public static final @UnknownKeyFor @NonNull @Initialized ColumnType UINT32 = ColumnType.of(TypeName.UINT32);
        public static final @UnknownKeyFor @NonNull @Initialized ColumnType UINT64 = ColumnType.of(TypeName.UINT64);

        public abstract @UnknownKeyFor @NonNull @Initialized boolean nullable();

        public abstract @UnknownKeyFor @NonNull @Initialized TypeName typeName();

        public abstract @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> enumValues();

        public abstract @Nullable @UnknownKeyFor @Initialized Integer fixedStringSize();

        public abstract @Nullable @UnknownKeyFor @Initialized ColumnType arrayElementType();

        public @UnknownKeyFor @NonNull @Initialized ColumnType withNullable(@UnknownKeyFor @NonNull @Initialized boolean nullable) {
            return this.toBuilder().nullable(nullable).build();
        }

        public static @UnknownKeyFor @NonNull @Initialized ColumnType of(@UnknownKeyFor @NonNull @Initialized TypeName typeName) {
            return ColumnType.builder().typeName(typeName).nullable(false).build();
        }

        public static @UnknownKeyFor @NonNull @Initialized ColumnType nullable(@UnknownKeyFor @NonNull @Initialized TypeName typeName) {
            return ColumnType.builder().typeName(typeName).nullable(true).build();
        }

        public static @UnknownKeyFor @NonNull @Initialized ColumnType fixedString(@UnknownKeyFor @NonNull @Initialized int size) {
            return ColumnType.builder().typeName(TypeName.FIXEDSTRING).nullable(false).fixedStringSize(size).build();
        }

        public static @UnknownKeyFor @NonNull @Initialized ColumnType enum8(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> enumValues) {
            return ColumnType.builder().typeName(TypeName.ENUM8).nullable(false).enumValues(enumValues).build();
        }

        public static @UnknownKeyFor @NonNull @Initialized ColumnType enum16(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> enumValues) {
            return ColumnType.builder().typeName(TypeName.ENUM16).nullable(false).enumValues(enumValues).build();
        }

        public static @UnknownKeyFor @NonNull @Initialized ColumnType array(@UnknownKeyFor @NonNull @Initialized ColumnType arrayElementType) {
            return ColumnType.builder().typeName(TypeName.ARRAY).nullable(false).arrayElementType(arrayElementType).build();
        }

        public static @UnknownKeyFor @NonNull @Initialized ColumnType parse(@UnknownKeyFor @NonNull @Initialized String str) {
            try {
                return new ColumnTypeParser(new StringReader(str)).parse();
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("failed to parse", e);
            }
        }

        public static @UnknownKeyFor @NonNull @Initialized Object parseDefaultExpression(@UnknownKeyFor @NonNull @Initialized ColumnType columnType, @UnknownKeyFor @NonNull @Initialized String value) {
            switch (columnType.typeName()) {
                case INT8: {
                    return Byte.valueOf(value);
                }
                case INT16: {
                    return Short.valueOf(value);
                }
                case INT32: {
                    return Integer.valueOf(value);
                }
                case INT64: {
                    return Long.valueOf(value);
                }
                case STRING: 
                case FIXEDSTRING: 
                case ENUM8: 
                case ENUM16: {
                    return value;
                }
                case UINT8: {
                    return Short.valueOf(value);
                }
                case UINT16: {
                    return Integer.valueOf(value);
                }
                case UINT32: {
                    return Long.valueOf(value);
                }
                case UINT64: {
                    return Long.valueOf(value);
                }
            }
            throw new UnsupportedOperationException("Unsupported type: " + columnType);
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_TableSchema_ColumnType.Builder();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            public abstract @UnknownKeyFor @NonNull @Initialized Builder typeName(@UnknownKeyFor @NonNull @Initialized TypeName var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder arrayElementType(@UnknownKeyFor @NonNull @Initialized ColumnType var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder nullable(@UnknownKeyFor @NonNull @Initialized boolean var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder enumValues(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder fixedStringSize(@UnknownKeyFor @NonNull @Initialized Integer var1);

            public abstract @UnknownKeyFor @NonNull @Initialized ColumnType build();
        }
    }

    public static enum DefaultType {
        DEFAULT,
        MATERIALIZED,
        ALIAS;


        public static @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized DefaultType> parse(@UnknownKeyFor @NonNull @Initialized String str) {
            if ("".equals(str)) {
                return Optional.empty();
            }
            return Optional.of(DefaultType.valueOf(str));
        }
    }

    public static enum TypeName {
        DATE,
        DATETIME,
        ENUM8,
        ENUM16,
        FIXEDSTRING,
        FLOAT32,
        FLOAT64,
        INT8,
        INT16,
        INT32,
        INT64,
        STRING,
        UINT8,
        UINT16,
        UINT32,
        UINT64,
        ARRAY;

    }

    @AutoValue
    public static abstract class Column
    implements Serializable {
        public abstract @UnknownKeyFor @NonNull @Initialized String name();

        public abstract @UnknownKeyFor @NonNull @Initialized ColumnType columnType();

        public abstract @Nullable @UnknownKeyFor @Initialized DefaultType defaultType();

        public abstract @Nullable @UnknownKeyFor @Initialized Object defaultValue();

        public @UnknownKeyFor @NonNull @Initialized boolean materializedOrAlias() {
            return DefaultType.MATERIALIZED.equals((Object)this.defaultType()) || DefaultType.ALIAS.equals((Object)this.defaultType());
        }

        public static @UnknownKeyFor @NonNull @Initialized Column of(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized ColumnType columnType) {
            return Column.of(name, columnType, null, null);
        }

        public static @UnknownKeyFor @NonNull @Initialized Column of(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized ColumnType columnType, @Nullable @UnknownKeyFor @Initialized DefaultType defaultType, @Nullable @UnknownKeyFor @Initialized Object defaultValue) {
            return new AutoValue_TableSchema_Column(name, columnType, defaultType, defaultValue);
        }
    }
}

