/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.clickhouse;

import com.clickhouse.client.ClickHouseOutputStream;
import com.clickhouse.client.data.BinaryStreamUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.beam.sdk.io.clickhouse.TableSchema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Charsets;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Days;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class ClickHouseWriter {
    private static final @UnknownKeyFor @NonNull @Initialized Instant EPOCH_INSTANT = new Instant(0L);

    static void writeNullableValue(@UnknownKeyFor @NonNull @Initialized ClickHouseOutputStream stream, @UnknownKeyFor @NonNull @Initialized TableSchema.ColumnType columnType, @UnknownKeyFor @NonNull @Initialized Object value) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (value == null) {
            BinaryStreamUtils.writeNull((OutputStream)stream);
        } else {
            BinaryStreamUtils.writeNonNull((OutputStream)stream);
            ClickHouseWriter.writeValue(stream, columnType, value);
        }
    }

    static void writeValue(@UnknownKeyFor @NonNull @Initialized ClickHouseOutputStream stream, @UnknownKeyFor @NonNull @Initialized TableSchema.ColumnType columnType, @UnknownKeyFor @NonNull @Initialized Object value) throws @UnknownKeyFor @NonNull @Initialized IOException {
        switch (columnType.typeName()) {
            case FIXEDSTRING: {
                byte[] bytes = value instanceof String ? ((String)value).getBytes(Charsets.UTF_8) : (byte[])value;
                stream.writeBytes(bytes);
                break;
            }
            case FLOAT32: {
                BinaryStreamUtils.writeFloat32((OutputStream)stream, (float)((Float)value).floatValue());
                break;
            }
            case FLOAT64: {
                BinaryStreamUtils.writeFloat64((OutputStream)stream, (double)((Double)value));
                break;
            }
            case INT8: {
                BinaryStreamUtils.writeInt8((OutputStream)stream, (byte)((Byte)value));
                break;
            }
            case INT16: {
                BinaryStreamUtils.writeInt16((OutputStream)stream, (short)((Short)value));
                break;
            }
            case INT32: {
                BinaryStreamUtils.writeInt32((OutputStream)stream, (int)((Integer)value));
                break;
            }
            case INT64: {
                BinaryStreamUtils.writeInt64((OutputStream)stream, (long)((Long)value));
                break;
            }
            case STRING: {
                BinaryStreamUtils.writeString((OutputStream)stream, (String)((String)value));
                break;
            }
            case UINT8: {
                BinaryStreamUtils.writeUnsignedInt8((OutputStream)stream, (int)((Short)value).shortValue());
                break;
            }
            case UINT16: {
                BinaryStreamUtils.writeUnsignedInt16((OutputStream)stream, (int)((Integer)value));
                break;
            }
            case UINT32: {
                BinaryStreamUtils.writeUnsignedInt32((OutputStream)stream, (long)((Long)value));
                break;
            }
            case UINT64: {
                BinaryStreamUtils.writeUnsignedInt64((OutputStream)stream, (long)((Long)value));
                break;
            }
            case ENUM8: {
                Integer enum8 = columnType.enumValues().get((String)value);
                Preconditions.checkNotNull((Object)enum8, (Object)("unknown enum value '" + value + "', possible values: " + columnType.enumValues()));
                BinaryStreamUtils.writeInt8((OutputStream)stream, (int)enum8);
                break;
            }
            case ENUM16: {
                Integer enum16 = columnType.enumValues().get((String)value);
                Preconditions.checkNotNull((Object)enum16, (Object)("unknown enum value '" + value + "', possible values: " + columnType.enumValues()));
                BinaryStreamUtils.writeInt16((OutputStream)stream, (int)enum16);
                break;
            }
            case DATE: {
                Days epochDays = Days.daysBetween((ReadableInstant)EPOCH_INSTANT, (ReadableInstant)((ReadableInstant)value));
                BinaryStreamUtils.writeUnsignedInt16((OutputStream)stream, (int)epochDays.getDays());
                break;
            }
            case DATETIME: {
                long epochSeconds = ((ReadableInstant)value).getMillis() / 1000L;
                BinaryStreamUtils.writeUnsignedInt32((OutputStream)stream, (long)epochSeconds);
                break;
            }
            case ARRAY: {
                List values = (List)value;
                BinaryStreamUtils.writeVarInt((OutputStream)stream, (long)values.size());
                for (Object arrayValue : values) {
                    ClickHouseWriter.writeValue(stream, columnType.arrayElementType(), arrayValue);
                }
                break;
            }
        }
    }

    static void writeRow(@UnknownKeyFor @NonNull @Initialized ClickHouseOutputStream stream, @UnknownKeyFor @NonNull @Initialized TableSchema schema, @UnknownKeyFor @NonNull @Initialized Row row) throws @UnknownKeyFor @NonNull @Initialized IOException {
        for (TableSchema.Column column : schema.columns()) {
            if (column.materializedOrAlias()) continue;
            Object value = row.getValue(column.name());
            if (column.columnType().nullable()) {
                ClickHouseWriter.writeNullableValue(stream, column.columnType(), value);
                continue;
            }
            if (value == null) {
                value = column.defaultValue();
            }
            ClickHouseWriter.writeValue(stream, column.columnType(), value);
        }
    }
}

