/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.clickhouse;

import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.jdbc.ClickHouseConnection;
import com.clickhouse.jdbc.ClickHouseDataSource;
import com.clickhouse.jdbc.ClickHouseStatement;
import com.google.auto.value.AutoValue;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.clickhouse.AutoValue_ClickHouseIO_Write;
import org.apache.beam.sdk.io.clickhouse.AutoValue_ClickHouseIO_WriteFn;
import org.apache.beam.sdk.io.clickhouse.ClickHouseWriter;
import org.apache.beam.sdk.io.clickhouse.TableSchema;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickHouseIO {
    public static final @UnknownKeyFor @NonNull @Initialized long DEFAULT_MAX_INSERT_BLOCK_SIZE = 1000000L;
    public static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_MAX_RETRIES = 5;
    public static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_MAX_CUMULATIVE_BACKOFF = Duration.standardDays((long)1000L);
    public static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_INITIAL_BACKOFF = Duration.standardSeconds((long)5L);

    public static <T> @UnknownKeyFor @NonNull @Initialized Write<T> write(@UnknownKeyFor @NonNull @Initialized String jdbcUrl, @UnknownKeyFor @NonNull @Initialized String table) {
        return new AutoValue_ClickHouseIO_Write.Builder().jdbcUrl(jdbcUrl).table(table).properties(new Properties()).maxInsertBlockSize(1000000L).initialBackoff(DEFAULT_INITIAL_BACKOFF).maxRetries(5).maxCumulativeBackoff(DEFAULT_MAX_CUMULATIVE_BACKOFF).build().withInsertDeduplicate(true).withInsertDistributedSync(true);
    }

    /*
     * Exception decompiling
     */
    public static @UnknownKeyFor @NonNull @Initialized TableSchema getTableSchema(@UnknownKeyFor @NonNull @Initialized String jdbcUrl, @UnknownKeyFor @NonNull @Initialized String table) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static @UnknownKeyFor @NonNull @Initialized String quoteIdentifier(@UnknownKeyFor @NonNull @Initialized String identifier) {
        String backslash = "\\\\";
        String quote = "\"";
        return quote + identifier.replaceAll(quote, backslash + quote) + quote;
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    @AutoValue
    static abstract class WriteFn<@UnknownKeyFor T>
    extends DoFn<T, Void> {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(WriteFn.class);
        private static final @UnknownKeyFor @NonNull @Initialized String RETRY_ATTEMPT_LOG = "Error writing to ClickHouse. Retry attempt[{}]";
        private @UnknownKeyFor @NonNull @Initialized ClickHouseConnection connection;
        private @UnknownKeyFor @NonNull @Initialized FluentBackoff retryBackoff;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Row> buffer = new ArrayList<Row>();
        private final @UnknownKeyFor @NonNull @Initialized Distribution batchSize = Metrics.distribution(Write.class, (String)"batch_size");
        private final @UnknownKeyFor @NonNull @Initialized Counter retries = Metrics.counter(Write.class, (String)"retries");
        @DoFn.FieldAccess(value="filterFields")
        final @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccessDescriptor = FieldAccessDescriptor.withAllFields();

        WriteFn() {
        }

        public abstract @UnknownKeyFor @NonNull @Initialized String jdbcUrl();

        public abstract @UnknownKeyFor @NonNull @Initialized String table();

        public abstract @UnknownKeyFor @NonNull @Initialized long maxInsertBlockSize();

        public abstract @UnknownKeyFor @NonNull @Initialized int maxRetries();

        public abstract @UnknownKeyFor @NonNull @Initialized Duration maxCumulativeBackoff();

        public abstract @UnknownKeyFor @NonNull @Initialized Duration initialBackoff();

        public abstract @UnknownKeyFor @NonNull @Initialized TableSchema schema();

        public abstract @UnknownKeyFor @NonNull @Initialized Properties properties();

        @VisibleForTesting
        static @UnknownKeyFor @NonNull @Initialized String insertSql(@UnknownKeyFor @NonNull @Initialized TableSchema schema, @UnknownKeyFor @NonNull @Initialized String table) {
            String columnsStr = schema.columns().stream().filter(x -> !x.materializedOrAlias()).map(x -> ClickHouseIO.quoteIdentifier(x.name())).collect(Collectors.joining(", "));
            return "INSERT INTO " + ClickHouseIO.quoteIdentifier(table) + " (" + columnsStr + ")";
        }

        @DoFn.Setup
        public void setup() throws @UnknownKeyFor @NonNull @Initialized SQLException {
            this.connection = new ClickHouseDataSource(this.jdbcUrl(), this.properties()).getConnection();
            this.retryBackoff = FluentBackoff.DEFAULT.withMaxRetries(this.maxRetries()).withMaxCumulativeBackoff(this.maxCumulativeBackoff()).withInitialBackoff(this.initialBackoff());
        }

        @DoFn.Teardown
        public void tearDown() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.connection.close();
        }

        @DoFn.StartBundle
        public void startBundle() {
            this.buffer.clear();
        }

        @DoFn.FinishBundle
        public void finishBundle() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.flush();
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.FieldAccess(value="filterFields") @DoFn.Element @UnknownKeyFor @NonNull @Initialized Row input) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.buffer.add(input);
            if ((long)this.buffer.size() >= this.maxInsertBlockSize()) {
                this.flush();
            }
        }

        private void flush() throws @UnknownKeyFor @NonNull @Initialized Exception {
            BackOff backOff = this.retryBackoff.backoff();
            int attempt = 0;
            if (this.buffer.isEmpty()) {
                return;
            }
            this.batchSize.update((long)this.buffer.size());
            while (true) {
                try (ClickHouseStatement statement = this.connection.createStatement();){
                    ((ClickHouseRequest.Mutation)((ClickHouseRequest)statement.unwrap(ClickHouseRequest.class)).write().table(this.table())).format(ClickHouseFormat.RowBinary).data(out -> {
                        for (Row row : this.buffer) {
                            ClickHouseWriter.writeRow(out, this.schema(), row);
                        }
                    }).sendAndWait();
                    this.buffer.clear();
                }
                catch (SQLException e) {
                    if (!BackOffUtils.next((Sleeper)Sleeper.DEFAULT, (BackOff)backOff)) {
                        throw e;
                    }
                    this.retries.inc();
                    LOG.warn(RETRY_ATTEMPT_LOG, (Object)attempt, (Object)e);
                    ++attempt;
                    continue;
                }
                break;
            }
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> jdbcUrl(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> table(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> maxInsertBlockSize(@UnknownKeyFor @NonNull @Initialized long var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> schema(@UnknownKeyFor @NonNull @Initialized TableSchema var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> properties(@UnknownKeyFor @NonNull @Initialized Properties var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> maxRetries(@UnknownKeyFor @NonNull @Initialized int var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> maxCumulativeBackoff(@UnknownKeyFor @NonNull @Initialized Duration var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> initialBackoff(@UnknownKeyFor @NonNull @Initialized Duration var1);

            public abstract @UnknownKeyFor @NonNull @Initialized WriteFn<T> build();
        }
    }

    @AutoValue
    public static abstract class Write<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PDone> {
        public abstract @UnknownKeyFor @NonNull @Initialized String jdbcUrl();

        public abstract @UnknownKeyFor @NonNull @Initialized String table();

        public abstract @UnknownKeyFor @NonNull @Initialized Properties properties();

        public abstract @UnknownKeyFor @NonNull @Initialized long maxInsertBlockSize();

        public abstract @UnknownKeyFor @NonNull @Initialized int maxRetries();

        public abstract @UnknownKeyFor @NonNull @Initialized Duration maxCumulativeBackoff();

        public abstract @UnknownKeyFor @NonNull @Initialized Duration initialBackoff();

        public abstract @Nullable @UnknownKeyFor @Initialized TableSchema tableSchema();

        public abstract @Nullable @UnknownKeyFor @Initialized Boolean insertDistributedSync();

        public abstract @Nullable @UnknownKeyFor @Initialized Long insertQuorum();

        public abstract @Nullable @UnknownKeyFor @Initialized Boolean insertDeduplicate();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            TableSchema tableSchema = this.tableSchema();
            if (tableSchema == null) {
                tableSchema = ClickHouseIO.getTableSchema(this.jdbcUrl(), this.table());
            }
            Properties properties = this.properties();
            Write.set(properties, "max_insert_block_size", this.maxInsertBlockSize());
            Write.set(properties, "insert_quorum", this.insertQuorum());
            Write.set(properties, "insert_distributed_sync", this.insertDistributedSync());
            Write.set(properties, "insert_deduplication", this.insertDeduplicate());
            WriteFn fn = new AutoValue_ClickHouseIO_WriteFn.Builder().jdbcUrl(this.jdbcUrl()).table(this.table()).maxInsertBlockSize(this.maxInsertBlockSize()).schema(tableSchema).properties(properties).initialBackoff(this.initialBackoff()).maxCumulativeBackoff(this.maxCumulativeBackoff()).maxRetries(this.maxRetries()).build();
            input.apply((PTransform)ParDo.of(fn));
            return PDone.in((Pipeline)input.getPipeline());
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withMaxInsertBlockSize(@UnknownKeyFor @NonNull @Initialized long value) {
            return this.toBuilder().maxInsertBlockSize(value).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withInsertDistributedSync(@Nullable @UnknownKeyFor @Initialized Boolean value) {
            return this.toBuilder().insertDistributedSync(value).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withInsertQuorum(@Nullable @UnknownKeyFor @Initialized Long value) {
            return this.toBuilder().insertQuorum(value).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withInsertDeduplicate(@UnknownKeyFor @NonNull @Initialized Boolean value) {
            return this.toBuilder().insertDeduplicate(value).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withMaxRetries(@UnknownKeyFor @NonNull @Initialized int value) {
            return this.toBuilder().maxRetries(value).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withMaxCumulativeBackoff(@UnknownKeyFor @NonNull @Initialized Duration value) {
            return this.toBuilder().maxCumulativeBackoff(value).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withInitialBackoff(@UnknownKeyFor @NonNull @Initialized Duration value) {
            return this.toBuilder().initialBackoff(value).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withTableSchema(@Nullable @UnknownKeyFor @Initialized TableSchema tableSchema) {
            return this.toBuilder().tableSchema(tableSchema).build();
        }

        private static void set(@UnknownKeyFor @NonNull @Initialized Properties properties, @UnknownKeyFor @NonNull @Initialized String param, @UnknownKeyFor @NonNull @Initialized Object value) {
            if (value != null) {
                properties.put(param, value);
            }
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> jdbcUrl(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> table(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> maxInsertBlockSize(@UnknownKeyFor @NonNull @Initialized long var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> tableSchema(@UnknownKeyFor @NonNull @Initialized TableSchema var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> insertDistributedSync(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> insertQuorum(@UnknownKeyFor @NonNull @Initialized Long var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> insertDeduplicate(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> properties(@UnknownKeyFor @NonNull @Initialized Properties var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> maxRetries(@UnknownKeyFor @NonNull @Initialized int var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> maxCumulativeBackoff(@UnknownKeyFor @NonNull @Initialized Duration var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> initialBackoff(@UnknownKeyFor @NonNull @Initialized Duration var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Write<T> build();
        }
    }
}

