/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.clickhouse;

import java.util.Map;
import org.apache.beam.sdk.io.clickhouse.TableSchema;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_TableSchema_ColumnType
extends TableSchema.ColumnType {
    private final boolean nullable;
    private final TableSchema.TypeName typeName;
    private final @Nullable Map<String, Integer> enumValues;
    private final @Nullable Integer fixedStringSize;
    private final  @Nullable TableSchema.ColumnType arrayElementType;

    private AutoValue_TableSchema_ColumnType(boolean nullable, TableSchema.TypeName typeName, @Nullable Map<String, Integer> enumValues, @Nullable Integer fixedStringSize,  @Nullable TableSchema.ColumnType arrayElementType) {
        this.nullable = nullable;
        this.typeName = typeName;
        this.enumValues = enumValues;
        this.fixedStringSize = fixedStringSize;
        this.arrayElementType = arrayElementType;
    }

    @Override
    public boolean nullable() {
        return this.nullable;
    }

    @Override
    public TableSchema.TypeName typeName() {
        return this.typeName;
    }

    @Override
    public @Nullable Map<String, Integer> enumValues() {
        return this.enumValues;
    }

    @Override
    public @Nullable Integer fixedStringSize() {
        return this.fixedStringSize;
    }

    @Override
    public  @Nullable TableSchema.ColumnType arrayElementType() {
        return this.arrayElementType;
    }

    public String toString() {
        return "ColumnType{nullable=" + this.nullable + ", typeName=" + (Object)((Object)this.typeName) + ", enumValues=" + this.enumValues + ", fixedStringSize=" + this.fixedStringSize + ", arrayElementType=" + this.arrayElementType + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TableSchema.ColumnType) {
            TableSchema.ColumnType that = (TableSchema.ColumnType)o;
            return this.nullable == that.nullable() && this.typeName.equals((Object)that.typeName()) && (this.enumValues == null ? that.enumValues() == null : this.enumValues.equals(that.enumValues())) && (this.fixedStringSize == null ? that.fixedStringSize() == null : this.fixedStringSize.equals(that.fixedStringSize())) && (this.arrayElementType == null ? that.arrayElementType() == null : this.arrayElementType.equals(that.arrayElementType()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.nullable ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.typeName.hashCode();
        h$ *= 1000003;
        h$ ^= this.enumValues == null ? 0 : this.enumValues.hashCode();
        h$ *= 1000003;
        h$ ^= this.fixedStringSize == null ? 0 : this.fixedStringSize.hashCode();
        h$ *= 1000003;
        return h$ ^= this.arrayElementType == null ? 0 : this.arrayElementType.hashCode();
    }

    @Override
    TableSchema.ColumnType.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends TableSchema.ColumnType.Builder {
        private Boolean nullable;
        private TableSchema.TypeName typeName;
        private @Nullable Map<String, Integer> enumValues;
        private @Nullable Integer fixedStringSize;
        private  @Nullable TableSchema.ColumnType arrayElementType;

        Builder() {
        }

        private Builder(TableSchema.ColumnType source) {
            this.nullable = source.nullable();
            this.typeName = source.typeName();
            this.enumValues = source.enumValues();
            this.fixedStringSize = source.fixedStringSize();
            this.arrayElementType = source.arrayElementType();
        }

        @Override
        public TableSchema.ColumnType.Builder nullable(boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        @Override
        public TableSchema.ColumnType.Builder typeName(TableSchema.TypeName typeName) {
            if (typeName == null) {
                throw new NullPointerException("Null typeName");
            }
            this.typeName = typeName;
            return this;
        }

        @Override
        public TableSchema.ColumnType.Builder enumValues(Map<String, Integer> enumValues) {
            this.enumValues = enumValues;
            return this;
        }

        @Override
        public TableSchema.ColumnType.Builder fixedStringSize(Integer fixedStringSize) {
            this.fixedStringSize = fixedStringSize;
            return this;
        }

        @Override
        public TableSchema.ColumnType.Builder arrayElementType(TableSchema.ColumnType arrayElementType) {
            this.arrayElementType = arrayElementType;
            return this;
        }

        @Override
        public TableSchema.ColumnType build() {
            if (this.nullable == null || this.typeName == null) {
                StringBuilder missing = new StringBuilder();
                if (this.nullable == null) {
                    missing.append(" nullable");
                }
                if (this.typeName == null) {
                    missing.append(" typeName");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_TableSchema_ColumnType(this.nullable, this.typeName, this.enumValues, this.fixedStringSize, this.arrayElementType);
        }
    }
}

