/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.clickhouse;

import java.util.Properties;
import org.apache.beam.sdk.io.clickhouse.ClickHouseIO;
import org.apache.beam.sdk.io.clickhouse.TableSchema;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

final class AutoValue_ClickHouseIO_Write<T>
extends ClickHouseIO.Write<T> {
    private final String jdbcUrl;
    private final String table;
    private final Properties properties;
    private final long maxInsertBlockSize;
    private final int maxRetries;
    private final Duration maxCumulativeBackoff;
    private final Duration initialBackoff;
    private final @Nullable TableSchema tableSchema;
    private final @Nullable Boolean insertDistributedSync;
    private final @Nullable Long insertQuorum;
    private final @Nullable Boolean insertDeduplicate;

    private AutoValue_ClickHouseIO_Write(String jdbcUrl, String table, Properties properties, long maxInsertBlockSize, int maxRetries, Duration maxCumulativeBackoff, Duration initialBackoff, @Nullable TableSchema tableSchema, @Nullable Boolean insertDistributedSync, @Nullable Long insertQuorum, @Nullable Boolean insertDeduplicate) {
        this.jdbcUrl = jdbcUrl;
        this.table = table;
        this.properties = properties;
        this.maxInsertBlockSize = maxInsertBlockSize;
        this.maxRetries = maxRetries;
        this.maxCumulativeBackoff = maxCumulativeBackoff;
        this.initialBackoff = initialBackoff;
        this.tableSchema = tableSchema;
        this.insertDistributedSync = insertDistributedSync;
        this.insertQuorum = insertQuorum;
        this.insertDeduplicate = insertDeduplicate;
    }

    @Override
    public String jdbcUrl() {
        return this.jdbcUrl;
    }

    @Override
    public String table() {
        return this.table;
    }

    @Override
    public Properties properties() {
        return this.properties;
    }

    @Override
    public long maxInsertBlockSize() {
        return this.maxInsertBlockSize;
    }

    @Override
    public int maxRetries() {
        return this.maxRetries;
    }

    @Override
    public Duration maxCumulativeBackoff() {
        return this.maxCumulativeBackoff;
    }

    @Override
    public Duration initialBackoff() {
        return this.initialBackoff;
    }

    @Override
    public @Nullable TableSchema tableSchema() {
        return this.tableSchema;
    }

    @Override
    public @Nullable Boolean insertDistributedSync() {
        return this.insertDistributedSync;
    }

    @Override
    public @Nullable Long insertQuorum() {
        return this.insertQuorum;
    }

    @Override
    public @Nullable Boolean insertDeduplicate() {
        return this.insertDeduplicate;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ClickHouseIO.Write) {
            ClickHouseIO.Write that = (ClickHouseIO.Write)((Object)o);
            return this.jdbcUrl.equals(that.jdbcUrl()) && this.table.equals(that.table()) && this.properties.equals(that.properties()) && this.maxInsertBlockSize == that.maxInsertBlockSize() && this.maxRetries == that.maxRetries() && this.maxCumulativeBackoff.equals((Object)that.maxCumulativeBackoff()) && this.initialBackoff.equals((Object)that.initialBackoff()) && (this.tableSchema == null ? that.tableSchema() == null : this.tableSchema.equals(that.tableSchema())) && (this.insertDistributedSync == null ? that.insertDistributedSync() == null : this.insertDistributedSync.equals(that.insertDistributedSync())) && (this.insertQuorum == null ? that.insertQuorum() == null : this.insertQuorum.equals(that.insertQuorum())) && (this.insertDeduplicate == null ? that.insertDeduplicate() == null : this.insertDeduplicate.equals(that.insertDeduplicate()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.jdbcUrl.hashCode();
        h$ *= 1000003;
        h$ ^= this.table.hashCode();
        h$ *= 1000003;
        h$ ^= this.properties.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.maxInsertBlockSize >>> 32 ^ this.maxInsertBlockSize);
        h$ *= 1000003;
        h$ ^= this.maxRetries;
        h$ *= 1000003;
        h$ ^= this.maxCumulativeBackoff.hashCode();
        h$ *= 1000003;
        h$ ^= this.initialBackoff.hashCode();
        h$ *= 1000003;
        h$ ^= this.tableSchema == null ? 0 : this.tableSchema.hashCode();
        h$ *= 1000003;
        h$ ^= this.insertDistributedSync == null ? 0 : this.insertDistributedSync.hashCode();
        h$ *= 1000003;
        h$ ^= this.insertQuorum == null ? 0 : this.insertQuorum.hashCode();
        h$ *= 1000003;
        return h$ ^= this.insertDeduplicate == null ? 0 : this.insertDeduplicate.hashCode();
    }

    @Override
    ClickHouseIO.Write.Builder<T> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends ClickHouseIO.Write.Builder<T> {
        private String jdbcUrl;
        private String table;
        private Properties properties;
        private Long maxInsertBlockSize;
        private Integer maxRetries;
        private Duration maxCumulativeBackoff;
        private Duration initialBackoff;
        private @Nullable TableSchema tableSchema;
        private @Nullable Boolean insertDistributedSync;
        private @Nullable Long insertQuorum;
        private @Nullable Boolean insertDeduplicate;

        Builder() {
        }

        private Builder(ClickHouseIO.Write<T> source) {
            this.jdbcUrl = source.jdbcUrl();
            this.table = source.table();
            this.properties = source.properties();
            this.maxInsertBlockSize = source.maxInsertBlockSize();
            this.maxRetries = source.maxRetries();
            this.maxCumulativeBackoff = source.maxCumulativeBackoff();
            this.initialBackoff = source.initialBackoff();
            this.tableSchema = source.tableSchema();
            this.insertDistributedSync = source.insertDistributedSync();
            this.insertQuorum = source.insertQuorum();
            this.insertDeduplicate = source.insertDeduplicate();
        }

        @Override
        public ClickHouseIO.Write.Builder<T> jdbcUrl(String jdbcUrl) {
            if (jdbcUrl == null) {
                throw new NullPointerException("Null jdbcUrl");
            }
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        @Override
        public ClickHouseIO.Write.Builder<T> table(String table) {
            if (table == null) {
                throw new NullPointerException("Null table");
            }
            this.table = table;
            return this;
        }

        @Override
        public ClickHouseIO.Write.Builder<T> properties(Properties properties) {
            if (properties == null) {
                throw new NullPointerException("Null properties");
            }
            this.properties = properties;
            return this;
        }

        @Override
        public ClickHouseIO.Write.Builder<T> maxInsertBlockSize(long maxInsertBlockSize) {
            this.maxInsertBlockSize = maxInsertBlockSize;
            return this;
        }

        @Override
        public ClickHouseIO.Write.Builder<T> maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        @Override
        public ClickHouseIO.Write.Builder<T> maxCumulativeBackoff(Duration maxCumulativeBackoff) {
            if (maxCumulativeBackoff == null) {
                throw new NullPointerException("Null maxCumulativeBackoff");
            }
            this.maxCumulativeBackoff = maxCumulativeBackoff;
            return this;
        }

        @Override
        public ClickHouseIO.Write.Builder<T> initialBackoff(Duration initialBackoff) {
            if (initialBackoff == null) {
                throw new NullPointerException("Null initialBackoff");
            }
            this.initialBackoff = initialBackoff;
            return this;
        }

        @Override
        public ClickHouseIO.Write.Builder<T> tableSchema(TableSchema tableSchema) {
            this.tableSchema = tableSchema;
            return this;
        }

        @Override
        public ClickHouseIO.Write.Builder<T> insertDistributedSync(Boolean insertDistributedSync) {
            this.insertDistributedSync = insertDistributedSync;
            return this;
        }

        @Override
        public ClickHouseIO.Write.Builder<T> insertQuorum(Long insertQuorum) {
            this.insertQuorum = insertQuorum;
            return this;
        }

        @Override
        public ClickHouseIO.Write.Builder<T> insertDeduplicate(Boolean insertDeduplicate) {
            this.insertDeduplicate = insertDeduplicate;
            return this;
        }

        @Override
        public ClickHouseIO.Write<T> build() {
            if (this.jdbcUrl == null || this.table == null || this.properties == null || this.maxInsertBlockSize == null || this.maxRetries == null || this.maxCumulativeBackoff == null || this.initialBackoff == null) {
                StringBuilder missing = new StringBuilder();
                if (this.jdbcUrl == null) {
                    missing.append(" jdbcUrl");
                }
                if (this.table == null) {
                    missing.append(" table");
                }
                if (this.properties == null) {
                    missing.append(" properties");
                }
                if (this.maxInsertBlockSize == null) {
                    missing.append(" maxInsertBlockSize");
                }
                if (this.maxRetries == null) {
                    missing.append(" maxRetries");
                }
                if (this.maxCumulativeBackoff == null) {
                    missing.append(" maxCumulativeBackoff");
                }
                if (this.initialBackoff == null) {
                    missing.append(" initialBackoff");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ClickHouseIO_Write(this.jdbcUrl, this.table, this.properties, this.maxInsertBlockSize, this.maxRetries, this.maxCumulativeBackoff, this.initialBackoff, this.tableSchema, this.insertDistributedSync, this.insertQuorum, this.insertDeduplicate);
        }
    }
}

