/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.clickhouse;

import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Objects;
import org.apache.beam.sdk.io.clickhouse.BaseClickHouseTest;
import org.apache.beam.sdk.io.clickhouse.ClickHouseIO;
import org.apache.beam.sdk.io.clickhouse.TableSchema;
import org.apache.beam.sdk.schemas.JavaFieldSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.logicaltypes.FixedBytes;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ClickHouseIOTest
extends BaseClickHouseTest {
    @Rule
    public TestPipeline pipeline = TestPipeline.create();

    @Test
    public void testInt64() throws Exception {
        Schema schema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"f0", (Schema.FieldType)Schema.FieldType.INT64), Schema.Field.of((String)"f1", (Schema.FieldType)Schema.FieldType.INT64)});
        Row row1 = Row.withSchema((Schema)schema).addValue((Object)1L).addValue((Object)2L).build();
        Row row2 = Row.withSchema((Schema)schema).addValue((Object)2L).addValue((Object)4L).build();
        Row row3 = Row.withSchema((Schema)schema).addValue((Object)3L).addValue((Object)6L).build();
        this.executeSql("CREATE TABLE test_int64 (f0 Int64, f1 Int64) ENGINE=Log");
        ((PCollection)this.pipeline.apply((PTransform)Create.of((Object)row1, (Object[])new Row[]{row2, row3}).withRowSchema(schema))).apply(this.write("test_int64"));
        this.pipeline.run().waitUntilFinish();
        long sum0 = this.executeQueryAsLong("SELECT SUM(f0) FROM test_int64");
        long sum1 = this.executeQueryAsLong("SELECT SUM(f1) FROM test_int64");
        Assert.assertEquals((long)6L, (long)sum0);
        Assert.assertEquals((long)12L, (long)sum1);
    }

    @Test
    public void testNullableInt64() throws Exception {
        Schema schema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.nullable((String)"f0", (Schema.FieldType)Schema.FieldType.INT64)});
        Row row1 = Row.withSchema((Schema)schema).addValue((Object)1L).build();
        Row row2 = Row.withSchema((Schema)schema).addValue(null).build();
        Row row3 = Row.withSchema((Schema)schema).addValue((Object)3L).build();
        this.executeSql("CREATE TABLE test_nullable_int64 (f0 Nullable(Int64)) ENGINE=Log");
        ((PCollection)this.pipeline.apply((PTransform)Create.of((Object)row1, (Object[])new Row[]{row2, row3}).withRowSchema(schema))).apply(this.write("test_nullable_int64"));
        this.pipeline.run().waitUntilFinish();
        long sum = this.executeQueryAsLong("SELECT SUM(f0) FROM test_nullable_int64");
        long count0 = this.executeQueryAsLong("SELECT COUNT(*) FROM test_nullable_int64");
        long count1 = this.executeQueryAsLong("SELECT COUNT(f0) FROM test_nullable_int64");
        Assert.assertEquals((long)4L, (long)sum);
        Assert.assertEquals((long)3L, (long)count0);
        Assert.assertEquals((long)2L, (long)count1);
    }

    @Test
    public void testInt64WithDefault() throws Exception {
        Schema schema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.nullable((String)"f0", (Schema.FieldType)Schema.FieldType.INT64)});
        Row row1 = Row.withSchema((Schema)schema).addValue((Object)1L).build();
        Row row2 = Row.withSchema((Schema)schema).addValue(null).build();
        Row row3 = Row.withSchema((Schema)schema).addValue((Object)3L).build();
        this.executeSql("CREATE TABLE test_int64_with_default (f0 Int64 DEFAULT -1) ENGINE=Log");
        ((PCollection)this.pipeline.apply((PTransform)Create.of((Object)row1, (Object[])new Row[]{row2, row3}).withRowSchema(schema))).apply(this.write("test_int64_with_default"));
        this.pipeline.run().waitUntilFinish();
        long sum = this.executeQueryAsLong("SELECT SUM(f0) FROM test_int64_with_default");
        Assert.assertEquals((long)3L, (long)sum);
    }

    @Test
    public void testArrayOfArrayOfInt64() throws Exception {
        Schema schema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"f0", (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.INT64)))});
        Row row1 = Row.withSchema((Schema)schema).addValue(Arrays.asList(Arrays.asList(1L, 2L), Arrays.asList(2L, 3L), Arrays.asList(3L, 4L))).build();
        this.executeSql("CREATE TABLE test_array_of_array_of_int64 (f0 Array(Array(Int64))) ENGINE=Log");
        ((PCollection)this.pipeline.apply((PTransform)Create.of((Object)row1, (Object[])new Row[0]).withRowSchema(schema))).apply(this.write("test_array_of_array_of_int64"));
        this.pipeline.run().waitUntilFinish();
        long sum0 = this.executeQueryAsLong("SELECT SUM(arraySum(arrayMap(x -> arraySum(x), f0))) FROM test_array_of_array_of_int64");
        Assert.assertEquals((long)15L, (long)sum0);
    }

    @Test
    public void testPrimitiveTypes() throws Exception {
        Schema schema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"f0", (Schema.FieldType)Schema.FieldType.DATETIME), Schema.Field.of((String)"f1", (Schema.FieldType)Schema.FieldType.DATETIME), Schema.Field.of((String)"f2", (Schema.FieldType)Schema.FieldType.FLOAT), Schema.Field.of((String)"f3", (Schema.FieldType)Schema.FieldType.DOUBLE), Schema.Field.of((String)"f4", (Schema.FieldType)Schema.FieldType.BYTE), Schema.Field.of((String)"f5", (Schema.FieldType)Schema.FieldType.INT16), Schema.Field.of((String)"f6", (Schema.FieldType)Schema.FieldType.INT32), Schema.Field.of((String)"f7", (Schema.FieldType)Schema.FieldType.INT64), Schema.Field.of((String)"f8", (Schema.FieldType)Schema.FieldType.STRING), Schema.Field.of((String)"f9", (Schema.FieldType)Schema.FieldType.INT16), Schema.Field.of((String)"f10", (Schema.FieldType)Schema.FieldType.INT32), Schema.Field.of((String)"f11", (Schema.FieldType)Schema.FieldType.INT64), Schema.Field.of((String)"f12", (Schema.FieldType)Schema.FieldType.INT64), Schema.Field.of((String)"f13", (Schema.FieldType)Schema.FieldType.STRING), Schema.Field.of((String)"f14", (Schema.FieldType)Schema.FieldType.STRING), Schema.Field.of((String)"f15", (Schema.FieldType)Schema.FieldType.STRING), Schema.Field.of((String)"f16", (Schema.FieldType)Schema.FieldType.BYTES), Schema.Field.of((String)"f17", (Schema.FieldType)Schema.FieldType.logicalType((Schema.LogicalType)FixedBytes.of((int)3)))});
        Row row1 = Row.withSchema((Schema)schema).addValue((Object)new DateTime(2030, 10, 1, 0, 0, 0, DateTimeZone.UTC)).addValue((Object)new DateTime(2030, 10, 9, 8, 7, 6, DateTimeZone.UTC)).addValue((Object)Float.valueOf(2.2f)).addValue((Object)3.3).addValue((Object)4).addValue((Object)5).addValue((Object)6).addValue((Object)7L).addValue((Object)"eight").addValue((Object)9).addValue((Object)10).addValue((Object)11L).addValue((Object)12L).addValue((Object)"abc").addValue((Object)"cde").addValue((Object)"qwe").addValue((Object)new byte[]{97, 115, 100}).addValue((Object)new byte[]{122, 120, 99}).build();
        this.executeSql("CREATE TABLE test_primitive_types (f0  Date,f1  DateTime,f2  Float32,f3  Float64,f4  Int8,f5  Int16,f6  Int32,f7  Int64,f8  String,f9  UInt8,f10 UInt16,f11 UInt32,f12 UInt64,f13 Enum8('abc' = 1, 'cde' = 2),f14 Enum16('abc' = -1, 'cde' = -2),f15 FixedString(3),f16 FixedString(3),f17 FixedString(3)) ENGINE=Log");
        ((PCollection)this.pipeline.apply((PTransform)Create.of((Object)row1, (Object[])new Row[0]).withRowSchema(schema))).apply(this.write("test_primitive_types"));
        this.pipeline.run().waitUntilFinish();
        try (ResultSet rs = this.executeQuery("SELECT * FROM test_primitive_types");){
            rs.next();
            Assert.assertEquals((Object)"2030-10-01", (Object)rs.getString("f0"));
            Assert.assertEquals((Object)"2030-10-09 08:07:06", (Object)rs.getString("f1"));
            Assert.assertEquals((Object)"2.2", (Object)rs.getString("f2"));
            Assert.assertEquals((Object)"3.3", (Object)rs.getString("f3"));
            Assert.assertEquals((Object)"4", (Object)rs.getString("f4"));
            Assert.assertEquals((Object)"5", (Object)rs.getString("f5"));
            Assert.assertEquals((Object)"6", (Object)rs.getString("f6"));
            Assert.assertEquals((Object)"7", (Object)rs.getString("f7"));
            Assert.assertEquals((Object)"eight", (Object)rs.getString("f8"));
            Assert.assertEquals((Object)"9", (Object)rs.getString("f9"));
            Assert.assertEquals((Object)"10", (Object)rs.getString("f10"));
            Assert.assertEquals((Object)"11", (Object)rs.getString("f11"));
            Assert.assertEquals((Object)"12", (Object)rs.getString("f12"));
            Assert.assertEquals((Object)"abc", (Object)rs.getString("f13"));
            Assert.assertEquals((Object)"cde", (Object)rs.getString("f14"));
            Assert.assertArrayEquals((byte[])new byte[]{113, 119, 101}, (byte[])rs.getBytes("f15"));
            Assert.assertArrayEquals((byte[])new byte[]{97, 115, 100}, (byte[])rs.getBytes("f16"));
            Assert.assertArrayEquals((byte[])new byte[]{122, 120, 99}, (byte[])rs.getBytes("f17"));
        }
    }

    @Test
    public void testArrayOfPrimitiveTypes() throws Exception {
        Schema schema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"f0", (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.DATETIME)), Schema.Field.of((String)"f1", (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.DATETIME)), Schema.Field.of((String)"f2", (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.FLOAT)), Schema.Field.of((String)"f3", (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.DOUBLE)), Schema.Field.of((String)"f4", (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.BYTE)), Schema.Field.of((String)"f5", (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.INT16)), Schema.Field.of((String)"f6", (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.INT32)), Schema.Field.of((String)"f7", (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.INT64)), Schema.Field.of((String)"f8", (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.STRING)), Schema.Field.of((String)"f9", (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.INT16)), Schema.Field.of((String)"f10", (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.INT32)), Schema.Field.of((String)"f11", (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.INT64)), Schema.Field.of((String)"f12", (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.INT64)), Schema.Field.of((String)"f13", (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.STRING)), Schema.Field.of((String)"f14", (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.STRING))});
        Row row1 = Row.withSchema((Schema)schema).addArray(new Object[]{new DateTime(2030, 10, 1, 0, 0, 0, DateTimeZone.UTC), new DateTime(2031, 10, 1, 0, 0, 0, DateTimeZone.UTC)}).addArray(new Object[]{new DateTime(2030, 10, 9, 8, 7, 6, DateTimeZone.UTC), new DateTime(2031, 10, 9, 8, 7, 6, DateTimeZone.UTC)}).addArray(new Object[]{Float.valueOf(2.2f), Float.valueOf(3.3f)}).addArray(new Object[]{3.3, 4.4}).addArray(new Object[]{(byte)4, (byte)5}).addArray(new Object[]{(short)5, (short)6}).addArray(new Object[]{6, 7}).addArray(new Object[]{7L, 8L}).addArray(new Object[]{"eight", "nine"}).addArray(new Object[]{(short)9, (short)10}).addArray(new Object[]{10, 11}).addArray(new Object[]{11L, 12L}).addArray(new Object[]{12L, 13L}).addArray(new Object[]{"abc", "cde"}).addArray(new Object[]{"cde", "abc"}).build();
        this.executeSql("CREATE TABLE test_array_of_primitive_types (f0  Array(Date),f1  Array(DateTime),f2  Array(Float32),f3  Array(Float64),f4  Array(Int8),f5  Array(Int16),f6  Array(Int32),f7  Array(Int64),f8  Array(String),f9  Array(UInt8),f10 Array(UInt16),f11 Array(UInt32),f12 Array(UInt64),f13 Array(Enum8('abc' = 1, 'cde' = 2)),f14 Array(Enum16('abc' = -1, 'cde' = -2))) ENGINE=Log");
        ((PCollection)this.pipeline.apply((PTransform)Create.of((Object)row1, (Object[])new Row[0]).withRowSchema(schema))).apply(this.write("test_array_of_primitive_types"));
        this.pipeline.run().waitUntilFinish();
        try (ResultSet rs = this.executeQuery("SELECT * FROM test_array_of_primitive_types");){
            rs.next();
            Assert.assertEquals((Object)"['2030-10-01','2031-10-01']", (Object)rs.getString("f0"));
            Assert.assertEquals((Object)"['2030-10-09 08:07:06','2031-10-09 08:07:06']", (Object)rs.getString("f1"));
            Assert.assertEquals((Object)"[2.2,3.3]", (Object)rs.getString("f2"));
            Assert.assertEquals((Object)"[3.3,4.4]", (Object)rs.getString("f3"));
            Assert.assertEquals((Object)"[4,5]", (Object)rs.getString("f4"));
            Assert.assertEquals((Object)"[5,6]", (Object)rs.getString("f5"));
            Assert.assertEquals((Object)"[6,7]", (Object)rs.getString("f6"));
            Assert.assertEquals((Object)"[7,8]", (Object)rs.getString("f7"));
            Assert.assertEquals((Object)"['eight','nine']", (Object)rs.getString("f8"));
            Assert.assertEquals((Object)"[9,10]", (Object)rs.getString("f9"));
            Assert.assertEquals((Object)"[10,11]", (Object)rs.getString("f10"));
            Assert.assertEquals((Object)"[11,12]", (Object)rs.getString("f11"));
            Assert.assertEquals((Object)"[12,13]", (Object)rs.getString("f12"));
            Assert.assertEquals((Object)"['abc','cde']", (Object)rs.getString("f13"));
            Assert.assertEquals((Object)"['cde','abc']", (Object)rs.getString("f14"));
        }
    }

    @Test
    public void testInsertSql() {
        TableSchema tableSchema = TableSchema.of((TableSchema.Column[])new TableSchema.Column[]{TableSchema.Column.of((String)"f0", (TableSchema.ColumnType)TableSchema.ColumnType.INT64), TableSchema.Column.of((String)"f1", (TableSchema.ColumnType)TableSchema.ColumnType.INT64)});
        String expected = "INSERT INTO \"test_table\" (\"f0\", \"f1\")";
        Assert.assertEquals((Object)expected, (Object)ClickHouseIO.WriteFn.insertSql((TableSchema)tableSchema, (String)"test_table"));
    }

    @Ignore
    public void testPojo() throws Exception {
        POJO pojo1 = new POJO(1, 2L);
        POJO pojo2 = new POJO(2, 4L);
        POJO pojo3 = new POJO(3, 6L);
        this.executeSql("CREATE TABLE test_pojo(f0 Int32, f1 Int64) ENGINE=Log");
        ((PCollection)this.pipeline.apply((PTransform)Create.of((Object)pojo1, (Object[])new POJO[]{pojo2, pojo3}))).apply(this.write("test_pojo"));
        this.pipeline.run().waitUntilFinish();
        long sum0 = this.executeQueryAsLong("SELECT SUM(f0) FROM test_pojo");
        long sum1 = this.executeQueryAsLong("SELECT SUM(f1) FROM test_pojo");
        Assert.assertEquals((long)6L, (long)sum0);
        Assert.assertEquals((long)12L, (long)sum1);
    }

    private <T> ClickHouseIO.Write<T> write(String table) {
        return ClickHouseIO.write((String)clickHouse.getJdbcUrl(), (String)table).withMaxRetries(0);
    }

    @DefaultSchema(value=JavaFieldSchema.class)
    public static final class POJO {
        public int f0;
        public long f1;

        public POJO(int f0, long f1) {
            this.f0 = f0;
            this.f1 = f1;
        }

        public POJO() {
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            POJO pojo = (POJO)o;
            return this.f0 == pojo.f0 && this.f1 == pojo.f1;
        }

        public int hashCode() {
            return Objects.hash(this.f0, this.f1);
        }
    }
}

