/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.clickhouse;

import com.github.dockerjava.api.command.CreateContainerCmd;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.joda.time.Duration;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.ClickHouseContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.utility.DockerImageName;

public class BaseClickHouseTest {
    public static Network network;
    public static GenericContainer zookeeper;
    public static ClickHouseContainer clickHouse;
    private static final String ZOOKEEPER_VERSION = "3.4.13";
    private static final String CLICKHOUSE_IMAGE = "yandex/clickhouse-server@sha256:c75f66f3619ca70a9f7215966505eaed2fc0ca0ee7d6a7b5407d1b14df8ddefc";
    private static final Logger LOG;

    @BeforeClass
    public static void setup() throws IOException, InterruptedException {
        network = Network.newNetwork();
        zookeeper = new GenericContainer(DockerImageName.parse((String)"zookeeper").withTag(ZOOKEEPER_VERSION)).withStartupAttempts(10).withExposedPorts(new Integer[]{2181}).withNetwork(network).withNetworkAliases(new String[]{"zookeeper"});
        zookeeper.start();
        clickHouse = (ClickHouseContainer)new ClickHouseContainer(CLICKHOUSE_IMAGE).withStartupAttempts(10).withCreateContainerCmdModifier(cmd -> ((CreateContainerCmd)cmd).withMemory(Long.valueOf(0x10000000L)).withMemorySwap(Long.valueOf(0x100000000L))).withNetwork(network).withClasspathResourceMapping("config.d/zookeeper_default.xml", "/etc/clickhouse-server/config.d/zookeeper_default.xml", BindMode.READ_ONLY);
        BackOff backOff = FluentBackoff.DEFAULT.withMaxRetries(3).withInitialBackoff(Duration.standardSeconds((long)15L)).backoff();
        while (true) {
            try {
                Unreliables.retryUntilSuccess((int)10, () -> {
                    DockerClientFactory.instance().checkAndPullImage(DockerClientFactory.instance().client(), CLICKHOUSE_IMAGE);
                    return null;
                });
                clickHouse.start();
            }
            catch (Exception e) {
                if (!BackOffUtils.next((Sleeper)Sleeper.DEFAULT, (BackOff)backOff)) {
                    throw e;
                }
                List images = (List)DockerClientFactory.instance().client().listImagesCmd().withShowAll(Boolean.valueOf(true)).exec();
                String listImagesOutput = "listImagesCmd:\n" + Joiner.on((char)'\n').join((Iterable)images) + "\n";
                LOG.warn("failed to start clickhouse-server\n\n" + listImagesOutput, (Throwable)e);
                continue;
            }
            break;
        }
    }

    @AfterClass
    public static void tearDown() {
        clickHouse.close();
        zookeeper.close();
        try {
            network.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    boolean executeSql(String sql) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    ResultSet executeQuery(String sql) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    long executeQueryAsLong(String sql) throws SQLException {
        ResultSet rs = this.executeQuery(sql);
        rs.next();
        return rs.getLong(1);
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    static {
        LOG = LoggerFactory.getLogger(BaseClickHouseTest.class);
    }
}

