/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.clickhouse;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.clickhouse.AutoValue_TableSchema;
import org.apache.beam.sdk.io.clickhouse.AutoValue_TableSchema_Column;
import org.apache.beam.sdk.io.clickhouse.AutoValue_TableSchema_ColumnType;
import org.apache.beam.sdk.io.clickhouse.impl.parser.ColumnTypeParser;
import org.apache.beam.sdk.io.clickhouse.impl.parser.ParseException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.FixedBytes;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
@AutoValue
public abstract class TableSchema
implements Serializable {
    public abstract List<Column> columns();

    public static TableSchema of(Column ... columns) {
        return new AutoValue_TableSchema(Arrays.asList(columns));
    }

    public static Schema getEquivalentSchema(TableSchema tableSchema) {
        return (Schema)tableSchema.columns().stream().map(x -> {
            if (x.columnType().nullable()) {
                return Schema.Field.nullable((String)x.name(), (Schema.FieldType)TableSchema.getEquivalentFieldType(x.columnType()));
            }
            return Schema.Field.of((String)x.name(), (Schema.FieldType)TableSchema.getEquivalentFieldType(x.columnType()));
        }).collect(Schema.toSchema());
    }

    public static Schema.FieldType getEquivalentFieldType(ColumnType columnType) {
        switch (columnType.typeName()) {
            case DATE: 
            case DATETIME: {
                return Schema.FieldType.DATETIME;
            }
            case STRING: {
                return Schema.FieldType.STRING;
            }
            case FIXEDSTRING: {
                int size = columnType.fixedStringSize();
                return Schema.FieldType.logicalType((Schema.LogicalType)FixedBytes.of((int)size));
            }
            case FLOAT32: {
                return Schema.FieldType.FLOAT;
            }
            case FLOAT64: {
                return Schema.FieldType.DOUBLE;
            }
            case INT8: {
                return Schema.FieldType.BYTE;
            }
            case INT16: {
                return Schema.FieldType.INT16;
            }
            case INT32: {
                return Schema.FieldType.INT32;
            }
            case INT64: {
                return Schema.FieldType.INT64;
            }
            case UINT8: {
                return Schema.FieldType.INT16;
            }
            case UINT16: {
                return Schema.FieldType.INT32;
            }
            case UINT32: {
                return Schema.FieldType.INT64;
            }
            case UINT64: {
                return Schema.FieldType.INT64;
            }
            case ARRAY: {
                return Schema.FieldType.array((Schema.FieldType)TableSchema.getEquivalentFieldType(columnType.arrayElementType()));
            }
            case ENUM8: 
            case ENUM16: {
                return Schema.FieldType.STRING;
            }
        }
        throw new AssertionError((Object)("Unexpected type: " + (Object)((Object)columnType.typeName())));
    }

    @AutoValue
    public static abstract class ColumnType
    implements Serializable {
        public static final ColumnType DATE = ColumnType.of(TypeName.DATE);
        public static final ColumnType DATETIME = ColumnType.of(TypeName.DATETIME);
        public static final ColumnType FLOAT32 = ColumnType.of(TypeName.FLOAT32);
        public static final ColumnType FLOAT64 = ColumnType.of(TypeName.FLOAT64);
        public static final ColumnType INT8 = ColumnType.of(TypeName.INT8);
        public static final ColumnType INT16 = ColumnType.of(TypeName.INT16);
        public static final ColumnType INT32 = ColumnType.of(TypeName.INT32);
        public static final ColumnType INT64 = ColumnType.of(TypeName.INT64);
        public static final ColumnType STRING = ColumnType.of(TypeName.STRING);
        public static final ColumnType UINT8 = ColumnType.of(TypeName.UINT8);
        public static final ColumnType UINT16 = ColumnType.of(TypeName.UINT16);
        public static final ColumnType UINT32 = ColumnType.of(TypeName.UINT32);
        public static final ColumnType UINT64 = ColumnType.of(TypeName.UINT64);

        public abstract boolean nullable();

        public abstract TypeName typeName();

        public abstract @Nullable Map<String, Integer> enumValues();

        public abstract @Nullable Integer fixedStringSize();

        public abstract @Nullable ColumnType arrayElementType();

        public ColumnType withNullable(boolean nullable) {
            return this.toBuilder().nullable(nullable).build();
        }

        public static ColumnType of(TypeName typeName) {
            return ColumnType.builder().typeName(typeName).nullable(false).build();
        }

        public static ColumnType nullable(TypeName typeName) {
            return ColumnType.builder().typeName(typeName).nullable(true).build();
        }

        public static ColumnType fixedString(int size) {
            return ColumnType.builder().typeName(TypeName.FIXEDSTRING).nullable(false).fixedStringSize(size).build();
        }

        public static ColumnType enum8(Map<String, Integer> enumValues) {
            return ColumnType.builder().typeName(TypeName.ENUM8).nullable(false).enumValues(enumValues).build();
        }

        public static ColumnType enum16(Map<String, Integer> enumValues) {
            return ColumnType.builder().typeName(TypeName.ENUM16).nullable(false).enumValues(enumValues).build();
        }

        public static ColumnType array(ColumnType arrayElementType) {
            return ColumnType.builder().typeName(TypeName.ARRAY).nullable(false).arrayElementType(arrayElementType).build();
        }

        public static ColumnType parse(String str) {
            try {
                return new ColumnTypeParser(new StringReader(str)).parse();
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("failed to parse", e);
            }
        }

        public static Object parseDefaultExpression(ColumnType columnType, String str) {
            try {
                String value = new ColumnTypeParser(new StringReader(str)).parseDefaultExpression();
                switch (columnType.typeName()) {
                    case INT8: {
                        return Byte.valueOf(value);
                    }
                    case INT16: {
                        return Short.valueOf(value);
                    }
                    case INT32: {
                        return Integer.valueOf(value);
                    }
                    case INT64: {
                        return Long.valueOf(value);
                    }
                    case STRING: 
                    case FIXEDSTRING: 
                    case ENUM8: 
                    case ENUM16: {
                        return value;
                    }
                    case UINT8: {
                        return Short.valueOf(value);
                    }
                    case UINT16: {
                        return Integer.valueOf(value);
                    }
                    case UINT32: {
                        return Long.valueOf(value);
                    }
                    case UINT64: {
                        return Long.valueOf(value);
                    }
                }
                throw new UnsupportedOperationException("Unsupported type: " + columnType);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("failed to parse", e);
            }
        }

        abstract Builder toBuilder();

        public static Builder builder() {
            return new AutoValue_TableSchema_ColumnType.Builder();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            public abstract Builder typeName(TypeName var1);

            public abstract Builder arrayElementType(ColumnType var1);

            public abstract Builder nullable(boolean var1);

            public abstract Builder enumValues(Map<String, Integer> var1);

            public abstract Builder fixedStringSize(Integer var1);

            public abstract ColumnType build();
        }
    }

    public static enum DefaultType {
        DEFAULT,
        MATERIALIZED,
        ALIAS;


        public static Optional<DefaultType> parse(String str) {
            if ("".equals(str)) {
                return Optional.empty();
            }
            return Optional.of(DefaultType.valueOf(str));
        }
    }

    public static enum TypeName {
        DATE,
        DATETIME,
        ENUM8,
        ENUM16,
        FIXEDSTRING,
        FLOAT32,
        FLOAT64,
        INT8,
        INT16,
        INT32,
        INT64,
        STRING,
        UINT8,
        UINT16,
        UINT32,
        UINT64,
        ARRAY;

    }

    @AutoValue
    public static abstract class Column
    implements Serializable {
        public abstract String name();

        public abstract ColumnType columnType();

        public abstract @Nullable DefaultType defaultType();

        public abstract @Nullable Object defaultValue();

        public boolean materializedOrAlias() {
            return DefaultType.MATERIALIZED.equals((Object)this.defaultType()) || DefaultType.ALIAS.equals((Object)this.defaultType());
        }

        public static Column of(String name, ColumnType columnType) {
            return Column.of(name, columnType, null, null);
        }

        public static Column of(String name, ColumnType columnType, @Nullable DefaultType defaultType, @Nullable Object defaultValue) {
            return new AutoValue_TableSchema_Column(name, columnType, defaultType, defaultValue);
        }
    }
}

