/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.clickhouse;

import java.io.IOException;
import java.util.List;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.clickhouse.TableSchema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Charsets;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.joda.time.Days;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import ru.yandex.clickhouse.util.ClickHouseRowBinaryStream;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class ClickHouseWriter {
    private static final Instant EPOCH_INSTANT = new Instant(0L);

    static void writeNullableValue(ClickHouseRowBinaryStream stream, TableSchema.ColumnType columnType, Object value) throws IOException {
        if (value == null) {
            stream.markNextNullable(true);
        } else {
            stream.markNextNullable(false);
            ClickHouseWriter.writeValue(stream, columnType, value);
        }
    }

    static void writeValue(ClickHouseRowBinaryStream stream, TableSchema.ColumnType columnType, Object value) throws IOException {
        switch (columnType.typeName()) {
            case FIXEDSTRING: {
                byte[] bytes = value instanceof String ? ((String)value).getBytes(Charsets.UTF_8) : (byte[])value;
                stream.writeBytes(bytes);
                break;
            }
            case FLOAT32: {
                stream.writeFloat32(((Float)value).floatValue());
                break;
            }
            case FLOAT64: {
                stream.writeFloat64(((Double)value).doubleValue());
                break;
            }
            case INT8: {
                stream.writeInt8(((Byte)value).byteValue());
                break;
            }
            case INT16: {
                stream.writeInt16(((Short)value).shortValue());
                break;
            }
            case INT32: {
                stream.writeInt32(((Integer)value).intValue());
                break;
            }
            case INT64: {
                stream.writeInt64(((Long)value).longValue());
                break;
            }
            case STRING: {
                stream.writeString((String)value);
                break;
            }
            case UINT8: {
                stream.writeUInt8((int)((Short)value).shortValue());
                break;
            }
            case UINT16: {
                stream.writeUInt16(((Integer)value).intValue());
                break;
            }
            case UINT32: {
                stream.writeUInt32(((Long)value).longValue());
                break;
            }
            case UINT64: {
                stream.writeUInt64(((Long)value).longValue());
                break;
            }
            case ENUM8: {
                Integer enum8 = columnType.enumValues().get((String)value);
                Preconditions.checkNotNull((Object)enum8, (Object)("unknown enum value '" + value + "', possible values: " + columnType.enumValues()));
                stream.writeInt8(enum8.intValue());
                break;
            }
            case ENUM16: {
                Integer enum16 = columnType.enumValues().get((String)value);
                Preconditions.checkNotNull((Object)enum16, (Object)("unknown enum value '" + value + "', possible values: " + columnType.enumValues()));
                stream.writeInt16(enum16.intValue());
                break;
            }
            case DATE: {
                Days epochDays = Days.daysBetween((ReadableInstant)EPOCH_INSTANT, (ReadableInstant)((ReadableInstant)value));
                stream.writeUInt16(epochDays.getDays());
                break;
            }
            case DATETIME: {
                long epochSeconds = ((ReadableInstant)value).getMillis() / 1000L;
                stream.writeUInt32(epochSeconds);
                break;
            }
            case ARRAY: {
                List values = (List)value;
                stream.writeUnsignedLeb128(values.size());
                for (Object arrayValue : values) {
                    ClickHouseWriter.writeValue(stream, columnType.arrayElementType(), arrayValue);
                }
                break;
            }
        }
    }

    static void writeRow(ClickHouseRowBinaryStream stream, TableSchema schema, Row row) throws IOException {
        for (TableSchema.Column column : schema.columns()) {
            if (column.materializedOrAlias()) continue;
            Object value = row.getValue(column.name());
            if (column.columnType().nullable()) {
                ClickHouseWriter.writeNullableValue(stream, column.columnType(), value);
                continue;
            }
            if (value == null) {
                value = column.defaultValue();
            }
            ClickHouseWriter.writeValue(stream, column.columnType(), value);
        }
    }
}

