/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.clickhouse;

import com.google.auto.value.AutoValue;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.clickhouse.AutoValue_ClickHouseIO_Write;
import org.apache.beam.sdk.io.clickhouse.AutoValue_ClickHouseIO_WriteFn;
import org.apache.beam.sdk.io.clickhouse.ClickHouseWriter;
import org.apache.beam.sdk.io.clickhouse.TableSchema;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.clickhouse.ClickHouseConnection;
import ru.yandex.clickhouse.ClickHouseDataSource;
import ru.yandex.clickhouse.ClickHouseStatement;
import ru.yandex.clickhouse.settings.ClickHouseQueryParam;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class ClickHouseIO {
    public static final long DEFAULT_MAX_INSERT_BLOCK_SIZE = 1000000L;
    public static final int DEFAULT_MAX_RETRIES = 5;
    public static final Duration DEFAULT_MAX_CUMULATIVE_BACKOFF = Duration.standardDays((long)1000L);
    public static final Duration DEFAULT_INITIAL_BACKOFF = Duration.standardSeconds((long)5L);

    public static <T> Write<T> write(String jdbcUrl, String table) {
        return new AutoValue_ClickHouseIO_Write.Builder().jdbcUrl(jdbcUrl).table(table).properties(new Properties()).maxInsertBlockSize(1000000L).initialBackoff(DEFAULT_INITIAL_BACKOFF).maxRetries(5).maxCumulativeBackoff(DEFAULT_MAX_CUMULATIVE_BACKOFF).build().withInsertDeduplicate(true).withInsertDistributedSync(true);
    }

    /*
     * Exception decompiling
     */
    public static TableSchema getTableSchema(String jdbcUrl, String table) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static String quoteIdentifier(String identifier) {
        String backslash = "\\\\";
        String quote = "\"";
        return quote + identifier.replaceAll(quote, backslash + quote) + quote;
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    @AutoValue
    static abstract class WriteFn<T>
    extends DoFn<T, Void> {
        private static final Logger LOG = LoggerFactory.getLogger(WriteFn.class);
        private static final String RETRY_ATTEMPT_LOG = "Error writing to ClickHouse. Retry attempt[%d]";
        private ClickHouseConnection connection;
        private FluentBackoff retryBackoff;
        private final List<Row> buffer = new ArrayList<Row>();
        private final Distribution batchSize = Metrics.distribution(Write.class, (String)"batch_size");
        private final Counter retries = Metrics.counter(Write.class, (String)"retries");
        @DoFn.FieldAccess(value="filterFields")
        final FieldAccessDescriptor fieldAccessDescriptor = FieldAccessDescriptor.withAllFields();

        WriteFn() {
        }

        public abstract String jdbcUrl();

        public abstract String table();

        public abstract long maxInsertBlockSize();

        public abstract int maxRetries();

        public abstract Duration maxCumulativeBackoff();

        public abstract Duration initialBackoff();

        public abstract TableSchema schema();

        public abstract Properties properties();

        @VisibleForTesting
        static String insertSql(TableSchema schema, String table) {
            String columnsStr = schema.columns().stream().filter(x -> !x.materializedOrAlias()).map(x -> ClickHouseIO.quoteIdentifier(x.name())).collect(Collectors.joining(", "));
            return "INSERT INTO " + ClickHouseIO.quoteIdentifier(table) + " (" + columnsStr + ")";
        }

        @DoFn.Setup
        public void setup() throws SQLException {
            this.connection = new ClickHouseDataSource(this.jdbcUrl(), this.properties()).getConnection();
            this.retryBackoff = FluentBackoff.DEFAULT.withMaxRetries(this.maxRetries()).withMaxCumulativeBackoff(this.maxCumulativeBackoff()).withInitialBackoff(this.initialBackoff());
        }

        @DoFn.Teardown
        public void tearDown() throws Exception {
            this.connection.close();
        }

        @DoFn.StartBundle
        public void startBundle() {
            this.buffer.clear();
        }

        @DoFn.FinishBundle
        public void finishBundle() throws Exception {
            this.flush();
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.FieldAccess(value="filterFields") @DoFn.Element Row input) throws Exception {
            this.buffer.add(input);
            if ((long)this.buffer.size() >= this.maxInsertBlockSize()) {
                this.flush();
            }
        }

        private void flush() throws Exception {
            BackOff backOff = this.retryBackoff.backoff();
            int attempt = 0;
            if (this.buffer.isEmpty()) {
                return;
            }
            this.batchSize.update((long)this.buffer.size());
            while (true) {
                try (ClickHouseStatement statement = this.connection.createStatement();){
                    statement.sendRowBinaryStream(WriteFn.insertSql(this.schema(), this.table()), stream -> {
                        for (Row row : this.buffer) {
                            ClickHouseWriter.writeRow(stream, this.schema(), row);
                        }
                    });
                    this.buffer.clear();
                }
                catch (SQLException e) {
                    if (!BackOffUtils.next((Sleeper)Sleeper.DEFAULT, (BackOff)backOff)) {
                        throw e;
                    }
                    this.retries.inc();
                    LOG.warn(String.format(RETRY_ATTEMPT_LOG, attempt), (Throwable)e);
                    ++attempt;
                    continue;
                }
                break;
            }
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            public abstract Builder<T> jdbcUrl(String var1);

            public abstract Builder<T> table(String var1);

            public abstract Builder<T> maxInsertBlockSize(long var1);

            public abstract Builder<T> schema(TableSchema var1);

            public abstract Builder<T> properties(Properties var1);

            public abstract Builder<T> maxRetries(int var1);

            public abstract Builder<T> maxCumulativeBackoff(Duration var1);

            public abstract Builder<T> initialBackoff(Duration var1);

            public abstract WriteFn<T> build();
        }
    }

    @AutoValue
    public static abstract class Write<T>
    extends PTransform<PCollection<T>, PDone> {
        public abstract String jdbcUrl();

        public abstract String table();

        public abstract Properties properties();

        public abstract long maxInsertBlockSize();

        public abstract int maxRetries();

        public abstract Duration maxCumulativeBackoff();

        public abstract Duration initialBackoff();

        public abstract @Nullable Boolean insertDistributedSync();

        public abstract @Nullable Long insertQuorum();

        public abstract @Nullable Boolean insertDeduplicate();

        abstract Builder<T> toBuilder();

        public PDone expand(PCollection<T> input) {
            TableSchema tableSchema = ClickHouseIO.getTableSchema(this.jdbcUrl(), this.table());
            Properties properties = this.properties();
            Write.set(properties, ClickHouseQueryParam.MAX_INSERT_BLOCK_SIZE, (Object)this.maxInsertBlockSize());
            Write.set(properties, ClickHouseQueryParam.INSERT_QUORUM, (Object)this.insertQuorum());
            Write.set(properties, "insert_distributed_sync", (Object)this.insertDistributedSync());
            Write.set(properties, "insert_deduplication", (Object)this.insertDeduplicate());
            WriteFn fn = new AutoValue_ClickHouseIO_WriteFn.Builder().jdbcUrl(this.jdbcUrl()).table(this.table()).maxInsertBlockSize(this.maxInsertBlockSize()).schema(tableSchema).properties(properties).initialBackoff(this.initialBackoff()).maxCumulativeBackoff(this.maxCumulativeBackoff()).maxRetries(this.maxRetries()).build();
            input.apply((PTransform)ParDo.of(fn));
            return PDone.in((Pipeline)input.getPipeline());
        }

        public Write<T> withMaxInsertBlockSize(long value) {
            return this.toBuilder().maxInsertBlockSize(value).build();
        }

        public Write<T> withInsertDistributedSync(@Nullable Boolean value) {
            return this.toBuilder().insertDistributedSync(value).build();
        }

        public Write<T> withInsertQuorum(@Nullable Long value) {
            return this.toBuilder().insertQuorum(value).build();
        }

        public Write<T> withInsertDeduplicate(Boolean value) {
            return this.toBuilder().insertDeduplicate(value).build();
        }

        public Write<T> withMaxRetries(int value) {
            return this.toBuilder().maxRetries(value).build();
        }

        public Write<T> withMaxCumulativeBackoff(Duration value) {
            return this.toBuilder().maxCumulativeBackoff(value).build();
        }

        public Write<T> withInitialBackoff(Duration value) {
            return this.toBuilder().initialBackoff(value).build();
        }

        private static void set(Properties properties, ClickHouseQueryParam param, Object value) {
            if (value != null) {
                Preconditions.checkArgument((boolean)param.getClazz().isInstance(value), (Object)("Unexpected value '" + value + "' for " + param.getKey() + " got " + value.getClass().getName() + ", expected " + param.getClazz().getName()));
                properties.put(param, value);
            }
        }

        private static void set(Properties properties, String param, Object value) {
            if (value != null) {
                properties.put(param, value);
            }
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            public abstract Builder<T> jdbcUrl(String var1);

            public abstract Builder<T> table(String var1);

            public abstract Builder<T> maxInsertBlockSize(long var1);

            public abstract Builder<T> insertDistributedSync(Boolean var1);

            public abstract Builder<T> insertQuorum(Long var1);

            public abstract Builder<T> insertDeduplicate(Boolean var1);

            public abstract Builder<T> properties(Properties var1);

            public abstract Builder<T> maxRetries(int var1);

            public abstract Builder<T> maxCumulativeBackoff(Duration var1);

            public abstract Builder<T> initialBackoff(Duration var1);

            public abstract Write<T> build();
        }
    }
}

