/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.clickhouse;

import java.util.Map;
import org.apache.beam.sdk.io.clickhouse.TableSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.junit.Assert;
import org.junit.Test;

public class TableSchemaTest {
    @Test
    public void testParseDate() {
        Assert.assertEquals((Object)TableSchema.ColumnType.DATE, (Object)TableSchema.ColumnType.parse((String)"Date"));
    }

    @Test
    public void testParseDateTime() {
        Assert.assertEquals((Object)TableSchema.ColumnType.DATETIME, (Object)TableSchema.ColumnType.parse((String)"DateTime"));
    }

    @Test
    public void testParseFloat32() {
        Assert.assertEquals((Object)TableSchema.ColumnType.FLOAT32, (Object)TableSchema.ColumnType.parse((String)"Float32"));
    }

    @Test
    public void testParseFloat64() {
        Assert.assertEquals((Object)TableSchema.ColumnType.FLOAT64, (Object)TableSchema.ColumnType.parse((String)"Float64"));
    }

    @Test
    public void testParseInt8() {
        Assert.assertEquals((Object)TableSchema.ColumnType.INT8, (Object)TableSchema.ColumnType.parse((String)"Int8"));
    }

    @Test
    public void testParseInt16() {
        Assert.assertEquals((Object)TableSchema.ColumnType.INT16, (Object)TableSchema.ColumnType.parse((String)"Int16"));
    }

    @Test
    public void testParseInt32() {
        Assert.assertEquals((Object)TableSchema.ColumnType.INT32, (Object)TableSchema.ColumnType.parse((String)"Int32"));
    }

    @Test
    public void testParseInt64() {
        Assert.assertEquals((Object)TableSchema.ColumnType.INT64, (Object)TableSchema.ColumnType.parse((String)"Int64"));
    }

    @Test
    public void testParseUInt8() {
        Assert.assertEquals((Object)TableSchema.ColumnType.UINT8, (Object)TableSchema.ColumnType.parse((String)"UInt8"));
    }

    @Test
    public void testParseUInt16() {
        Assert.assertEquals((Object)TableSchema.ColumnType.UINT16, (Object)TableSchema.ColumnType.parse((String)"UInt16"));
    }

    @Test
    public void testParseUInt32() {
        Assert.assertEquals((Object)TableSchema.ColumnType.UINT32, (Object)TableSchema.ColumnType.parse((String)"UInt32"));
    }

    @Test
    public void testParseUInt64() {
        Assert.assertEquals((Object)TableSchema.ColumnType.UINT64, (Object)TableSchema.ColumnType.parse((String)"UInt64"));
    }

    @Test
    public void testParseString() {
        Assert.assertEquals((Object)TableSchema.ColumnType.STRING, (Object)TableSchema.ColumnType.parse((String)"String"));
    }

    @Test
    public void testParseArray() {
        Assert.assertEquals((Object)TableSchema.ColumnType.array((TableSchema.ColumnType)TableSchema.ColumnType.STRING), (Object)TableSchema.ColumnType.parse((String)"Array(String)"));
    }

    @Test
    public void testParseEnum8() {
        ImmutableMap enumValues = ImmutableMap.of((Object)"a", (Object)-1, (Object)"b", (Object)0, (Object)"c", (Object)42);
        Assert.assertEquals((Object)TableSchema.ColumnType.enum8((Map)enumValues), (Object)TableSchema.ColumnType.parse((String)"Enum8('a' = -1, 'b' = 0, 'c' = 42)"));
    }

    @Test
    public void testParseEnum16() {
        ImmutableMap enumValues = ImmutableMap.of((Object)"a", (Object)-1, (Object)"b", (Object)0, (Object)"c", (Object)42);
        Assert.assertEquals((Object)TableSchema.ColumnType.enum16((Map)enumValues), (Object)TableSchema.ColumnType.parse((String)"Enum16('a' = -1, 'b' = 0, 'c' = 42)"));
    }

    @Test
    public void testParseNullableEnum16() {
        ImmutableMap enumValues = ImmutableMap.of((Object)"a", (Object)-1, (Object)"b", (Object)0, (Object)"c", (Object)42);
        Assert.assertEquals((Object)TableSchema.ColumnType.enum16((Map)enumValues).withNullable(true), (Object)TableSchema.ColumnType.parse((String)"Nullable(Enum16('a' = -1, 'b' = 0, 'c' = 42))"));
    }

    @Test
    public void testParseFixedString() {
        Assert.assertEquals((Object)TableSchema.ColumnType.fixedString((int)16), (Object)TableSchema.ColumnType.parse((String)"FixedString(16)"));
    }

    @Test
    public void testParseNullableFixedString() {
        Assert.assertEquals((Object)TableSchema.ColumnType.fixedString((int)16).withNullable(true), (Object)TableSchema.ColumnType.parse((String)"Nullable(FixedString(16))"));
    }

    @Test
    public void testParseNullableInt32() {
        Assert.assertEquals((Object)TableSchema.ColumnType.nullable((TableSchema.TypeName)TableSchema.TypeName.INT32), (Object)TableSchema.ColumnType.parse((String)"Nullable(Int32)"));
    }

    @Test
    public void testParseArrayOfNullable() {
        Assert.assertEquals((Object)TableSchema.ColumnType.array((TableSchema.ColumnType)TableSchema.ColumnType.nullable((TableSchema.TypeName)TableSchema.TypeName.INT32)), (Object)TableSchema.ColumnType.parse((String)"Array(Nullable(Int32))"));
    }

    @Test
    public void testParseArrayOfArrays() {
        Assert.assertEquals((Object)TableSchema.ColumnType.array((TableSchema.ColumnType)TableSchema.ColumnType.array((TableSchema.ColumnType)TableSchema.ColumnType.STRING)), (Object)TableSchema.ColumnType.parse((String)"Array(Array(String))"));
    }

    @Test
    public void testParseDefaultExpressionString() {
        Assert.assertEquals((Object)"abc", (Object)TableSchema.ColumnType.parseDefaultExpression((TableSchema.ColumnType)TableSchema.ColumnType.STRING, (String)"CAST('abc' AS String)"));
    }

    @Test
    public void testParseDefaultExpressionInt64() {
        Assert.assertEquals((Object)-1L, (Object)TableSchema.ColumnType.parseDefaultExpression((TableSchema.ColumnType)TableSchema.ColumnType.INT64, (String)"CAST(-1 AS Int64)"));
    }

    @Test
    public void testEquivalentSchema() {
        TableSchema tableSchema = TableSchema.of((TableSchema.Column[])new TableSchema.Column[]{TableSchema.Column.of((String)"f0", (TableSchema.ColumnType)TableSchema.ColumnType.INT64), TableSchema.Column.of((String)"f1", (TableSchema.ColumnType)TableSchema.ColumnType.nullable((TableSchema.TypeName)TableSchema.TypeName.INT64))});
        Schema expected = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"f0", (Schema.FieldType)Schema.FieldType.INT64), Schema.Field.nullable((String)"f1", (Schema.FieldType)Schema.FieldType.INT64)});
        Assert.assertEquals((Object)expected, (Object)TableSchema.getEquivalentSchema((TableSchema)tableSchema));
    }
}

