/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.clickhouse.impl.parser;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.apache.beam.sdk.io.clickhouse.TableSchema;
import org.apache.beam.sdk.io.clickhouse.impl.parser.ColumnTypeParserConstants;
import org.apache.beam.sdk.io.clickhouse.impl.parser.ColumnTypeParserTokenManager;
import org.apache.beam.sdk.io.clickhouse.impl.parser.ParseException;
import org.apache.beam.sdk.io.clickhouse.impl.parser.SimpleCharStream;
import org.apache.beam.sdk.io.clickhouse.impl.parser.Token;

public class ColumnTypeParser
implements ColumnTypeParserConstants {
    public ColumnTypeParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[8];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public TableSchema.ColumnType parse() throws ParseException {
        return this.columnType();
    }

    public String parseDefaultExpression() throws ParseException {
        return this.defaultExpression();
    }

    public final TableSchema.ColumnType columnType() throws ParseException {
        TableSchema.ColumnType ct;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                ct = this.primitive();
                break;
            }
            case 10: 
            case 11: {
                ct = this.enum_();
                break;
            }
            case 7: {
                ct = this.array();
                break;
            }
            case 24: {
                ct = this.nullable();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return ct;
    }

    public final String defaultExpression() throws ParseException {
        this.jj_consume_token(27);
        this.jj_consume_token(25);
        String value = this.expr();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                this.columnType();
                this.jj_consume_token(26);
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                this.jj_consume_token(5);
                this.jj_consume_token(26);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return value;
    }

    private final String string() throws ParseException {
        Token token = this.jj_consume_token(5);
        String str = token.toString();
        if (str.startsWith("'")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    private final String integer() throws ParseException {
        Token token = this.jj_consume_token(6);
        return token.toString();
    }

    private final String expr() throws ParseException {
        String str;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                str = this.string();
                break;
            }
            case 6: {
                str = this.integer();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return str;
    }

    private final TableSchema.TypeName typeName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                return TableSchema.TypeName.STRING;
            }
            case 8: {
                this.jj_consume_token(8);
                return TableSchema.TypeName.DATE;
            }
            case 9: {
                this.jj_consume_token(9);
                return TableSchema.TypeName.DATETIME;
            }
            case 13: {
                this.jj_consume_token(13);
                return TableSchema.TypeName.FLOAT32;
            }
            case 14: {
                this.jj_consume_token(14);
                return TableSchema.TypeName.FLOAT64;
            }
            case 16: {
                this.jj_consume_token(16);
                return TableSchema.TypeName.INT8;
            }
            case 17: {
                this.jj_consume_token(17);
                return TableSchema.TypeName.INT16;
            }
            case 18: {
                this.jj_consume_token(18);
                return TableSchema.TypeName.INT32;
            }
            case 19: {
                this.jj_consume_token(19);
                return TableSchema.TypeName.INT64;
            }
            case 20: {
                this.jj_consume_token(20);
                return TableSchema.TypeName.UINT8;
            }
            case 21: {
                this.jj_consume_token(21);
                return TableSchema.TypeName.UINT16;
            }
            case 22: {
                this.jj_consume_token(22);
                return TableSchema.TypeName.UINT32;
            }
            case 23: {
                this.jj_consume_token(23);
                return TableSchema.TypeName.UINT64;
            }
        }
        this.jj_la1[3] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final TableSchema.ColumnType primitive() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                TableSchema.TypeName type = this.typeName();
                return TableSchema.ColumnType.of((TableSchema.TypeName)type);
            }
            case 12: {
                this.jj_consume_token(12);
                this.jj_consume_token(25);
                String size = this.integer();
                this.jj_consume_token(26);
                return TableSchema.ColumnType.fixedString((int)Integer.valueOf(size));
            }
        }
        this.jj_la1[4] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final TableSchema.ColumnType nullable() throws ParseException {
        if (this.jj_2_1(3)) {
            this.jj_consume_token(24);
            this.jj_consume_token(25);
            TableSchema.ColumnType ct = this.primitive();
            this.jj_consume_token(26);
            return ct.withNullable(true);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: {
                this.jj_consume_token(24);
                this.jj_consume_token(25);
                TableSchema.ColumnType ct = this.enum_();
                this.jj_consume_token(26);
                return ct.withNullable(true);
            }
        }
        this.jj_la1[5] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final TableSchema.ColumnType array() throws ParseException {
        this.jj_consume_token(7);
        this.jj_consume_token(25);
        TableSchema.ColumnType element = this.columnType();
        this.jj_consume_token(26);
        return TableSchema.ColumnType.array((TableSchema.ColumnType)element);
    }

    private final Map.Entry<String, Integer> enumElement() throws ParseException {
        String key = this.string();
        this.jj_consume_token(30);
        String value = this.integer();
        return Maps.immutableEntry((Object)key, (Object)Integer.valueOf(value));
    }

    private final Map<String, Integer> enumElements() throws ParseException {
        ArrayList entries = Lists.newArrayList();
        Map.Entry<String, Integer> el = this.enumElement();
        entries.add(el);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(29);
            el = this.enumElement();
            entries.add(el);
        }
        return ImmutableMap.copyOf((Iterable)entries);
    }

    private final TableSchema.ColumnType enum_() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                this.jj_consume_token(25);
                Map<String, Integer> elements = this.enumElements();
                this.jj_consume_token(26);
                return TableSchema.ColumnType.enum8(elements);
            }
            case 11: {
                this.jj_consume_token(11);
                this.jj_consume_token(25);
                Map<String, Integer> elements = this.enumElements();
                this.jj_consume_token(26);
                return TableSchema.ColumnType.enum16(elements);
            }
        }
        this.jj_la1[7] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private final boolean jj_3R_5() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_6()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_7()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_8()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_9()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_10()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_11()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_12()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_13()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_14()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_15()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_16()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_17()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_18()) {
                                                            return true;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        if (this.jj_scan_token(25)) {
            return true;
        }
        return this.jj_3R_2();
    }

    private final boolean jj_3R_4() {
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_3() {
        return this.jj_3R_5();
    }

    private final boolean jj_3R_2() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_3()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_4()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_18() {
        return this.jj_scan_token(23);
    }

    private final boolean jj_3R_17() {
        return this.jj_scan_token(22);
    }

    private final boolean jj_3R_16() {
        return this.jj_scan_token(21);
    }

    private final boolean jj_3R_15() {
        return this.jj_scan_token(20);
    }

    private final boolean jj_3R_14() {
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_13() {
        return this.jj_scan_token(18);
    }

    private final boolean jj_3R_12() {
        return this.jj_scan_token(17);
    }

    private final boolean jj_3R_11() {
        return this.jj_scan_token(16);
    }

    private final boolean jj_3R_10() {
        return this.jj_scan_token(14);
    }

    private final boolean jj_3R_9() {
        return this.jj_scan_token(13);
    }

    private final boolean jj_3R_8() {
        return this.jj_scan_token(9);
    }

    private final boolean jj_3R_7() {
        return this.jj_scan_token(8);
    }

    private final boolean jj_3R_6() {
        return this.jj_scan_token(15);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{33554304, 0x30000000, 96, 16769792, 0xFFF300, 0x1000000, 0x20000000, 3072};
    }

    public ColumnTypeParser(InputStream stream) {
        this(stream, null);
    }

    public ColumnTypeParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new ColumnTypeParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ColumnTypeParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ColumnTypeParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ColumnTypeParser(ColumnTypeParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ColumnTypeParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[31];
        for (i = 0; i < 31; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 8; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 31; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 1; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        ColumnTypeParser.jj_la1_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

