/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.cassandra;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.beam.sdk.io.cassandra.SplitGenerator;
import org.junit.Assert;
import org.junit.Test;

public final class SplitGeneratorTest {
    @Test
    public void testGenerateSegments() {
        List tokens = Stream.of("0", "1", "56713727820156410577229101238628035242", "56713727820156410577229101238628035243", "113427455640312821154458202477256070484", "113427455640312821154458202477256070485").map(BigInteger::new).collect(Collectors.toList());
        SplitGenerator generator = new SplitGenerator("foo.bar.RandomPartitioner");
        List segments = generator.generateSplits(10L, tokens);
        Assert.assertEquals((long)12L, (long)segments.size());
        Assert.assertEquals((Object)"[(0,1], (1,14178431955039102644307275309657008811]]", (Object)((List)segments.get(0)).toString());
        Assert.assertEquals((Object)"[(14178431955039102644307275309657008811,28356863910078205288614550619314017621]]", (Object)((List)segments.get(1)).toString());
        Assert.assertEquals((Object)"[(70892159775195513221536376548285044053,85070591730234615865843651857942052863]]", (Object)((List)segments.get(5)).toString());
        tokens = Stream.of("5", "6", "56713727820156410577229101238628035242", "56713727820156410577229101238628035243", "113427455640312821154458202477256070484", "113427455640312821154458202477256070485").map(BigInteger::new).collect(Collectors.toList());
        segments = generator.generateSplits(10L, tokens);
        Assert.assertEquals((long)12L, (long)segments.size());
        Assert.assertEquals((Object)"[(5,6], (6,14178431955039102644307275309657008815]]", (Object)((List)segments.get(0)).toString());
        Assert.assertEquals((Object)"[(70892159775195513221536376548285044053,85070591730234615865843651857942052863]]", (Object)((List)segments.get(5)).toString());
        Assert.assertEquals((Object)"[(141784319550391026443072753096570088109,155962751505430129087380028406227096921]]", (Object)((List)segments.get(10)).toString());
    }

    @Test(expected=RuntimeException.class)
    public void testZeroSizeRange() {
        List<String> tokenStrings = Arrays.asList("0", "1", "56713727820156410577229101238628035242", "56713727820156410577229101238628035242", "113427455640312821154458202477256070484", "113427455640312821154458202477256070485");
        List tokens = tokenStrings.stream().map(BigInteger::new).collect(Collectors.toList());
        SplitGenerator generator = new SplitGenerator("foo.bar.RandomPartitioner");
        generator.generateSplits(10L, tokens);
    }

    @Test
    public void testRotatedRing() {
        List<String> tokenStrings = Arrays.asList("56713727820156410577229101238628035243", "113427455640312821154458202477256070484", "113427455640312821154458202477256070485", "5", "6", "56713727820156410577229101238628035242");
        List tokens = tokenStrings.stream().map(BigInteger::new).collect(Collectors.toList());
        SplitGenerator generator = new SplitGenerator("foo.bar.RandomPartitioner");
        List segments = generator.generateSplits(5L, tokens);
        Assert.assertEquals((long)6L, (long)segments.size());
        Assert.assertEquals((Object)"[(85070591730234615865843651857942052863,113427455640312821154458202477256070484], (113427455640312821154458202477256070484,113427455640312821154458202477256070485]]", (Object)((List)segments.get(1)).toString());
        Assert.assertEquals((Object)"[(113427455640312821154458202477256070485,141784319550391026443072753096570088109]]", (Object)((List)segments.get(2)).toString());
        Assert.assertEquals((Object)"[(141784319550391026443072753096570088109,5], (5,6]]", (Object)((List)segments.get(3)).toString());
    }

    @Test(expected=RuntimeException.class)
    public void testDisorderedRing() {
        List<String> tokenStrings = Arrays.asList("0", "113427455640312821154458202477256070485", "1", "56713727820156410577229101238628035242", "56713727820156410577229101238628035243", "113427455640312821154458202477256070484");
        List tokens = tokenStrings.stream().map(BigInteger::new).collect(Collectors.toList());
        SplitGenerator generator = new SplitGenerator("foo.bar.RandomPartitioner");
        generator.generateSplits(10L, tokens);
    }
}

