/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.cassandra;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PlainTextAuthProvider;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import com.google.auto.value.AutoValue;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.cassandra.AutoValue_CassandraIO_Read;
import org.apache.beam.sdk.io.cassandra.AutoValue_CassandraIO_ReadAll;
import org.apache.beam.sdk.io.cassandra.AutoValue_CassandraIO_Write;
import org.apache.beam.sdk.io.cassandra.DefaultObjectMapperFactory;
import org.apache.beam.sdk.io.cassandra.Mapper;
import org.apache.beam.sdk.io.cassandra.ReadFn;
import org.apache.beam.sdk.io.cassandra.RingRange;
import org.apache.beam.sdk.io.cassandra.SplitGenerator;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class CassandraIO {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(CassandraIO.class);
    private static final @UnknownKeyFor @NonNull @Initialized String MURMUR3PARTITIONER = "org.apache.cassandra.dht.Murmur3Partitioner";

    private CassandraIO() {
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Read<T> read() {
        return new AutoValue_CassandraIO_Read.Builder().build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ReadAll<T> readAll() {
        return new AutoValue_CassandraIO_ReadAll.Builder().build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Write<T> write() {
        return Write.builder(MutationType.WRITE).build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Write<T> delete() {
        return Write.builder(MutationType.DELETE).build();
    }

    static @UnknownKeyFor @NonNull @Initialized Cluster getCluster(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> hosts, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> port, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> username, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> password, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> localDc, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> consistencyLevel, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> connectTimeout, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> readTimeout) {
        Cluster.Builder builder = Cluster.builder().addContactPoints(((List)hosts.get()).toArray(new String[0])).withPort(((Integer)port.get()).intValue());
        if (username != null) {
            builder.withAuthProvider((AuthProvider)new PlainTextAuthProvider((String)username.get(), (String)password.get()));
        }
        DCAwareRoundRobinPolicy.Builder dcAwarePolicyBuilder = new DCAwareRoundRobinPolicy.Builder();
        if (localDc != null) {
            dcAwarePolicyBuilder.withLocalDc((String)localDc.get());
        }
        builder.withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)dcAwarePolicyBuilder.build()));
        if (consistencyLevel != null) {
            builder.withQueryOptions(new QueryOptions().setConsistencyLevel(ConsistencyLevel.valueOf((String)((String)consistencyLevel.get()))));
        }
        SocketOptions socketOptions = new SocketOptions();
        builder.withSocketOptions(socketOptions);
        if (connectTimeout != null) {
            socketOptions.setConnectTimeoutMillis(((Integer)connectTimeout.get()).intValue());
        }
        if (readTimeout != null) {
            socketOptions.setReadTimeoutMillis(((Integer)readTimeout.get()).intValue());
        }
        return builder.build();
    }

    @VisibleForTesting
    private static @UnknownKeyFor @NonNull @Initialized boolean isMurmur3Partitioner(@UnknownKeyFor @NonNull @Initialized Cluster cluster) {
        return MURMUR3PARTITIONER.equals(cluster.getMetadata().getPartitioner());
    }

    @AutoValue
    public static abstract class ReadAll<@UnknownKeyFor T>
    extends PTransform<PCollection<Read<T>>, PCollection<T>> {
        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized Coder<T> coder();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> builder();

        public @UnknownKeyFor @NonNull @Initialized ReadAll<T> withCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            Preconditions.checkArgument((coder != null ? 1 : 0) != 0, (Object)"coder can not be null");
            return this.builder().setCoder(coder).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Read<T>> input) {
            Preconditions.checkArgument((this.coder() != null ? 1 : 0) != 0, (Object)"withCoder() is required");
            return ((PCollection)((PCollection)input.apply("Reshuffle", (PTransform)Reshuffle.viaRandomKey())).apply("Read", (PTransform)ParDo.of(new ReadFn()))).setCoder(this.coder());
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized ReadAll<T> autoBuild();

            public @UnknownKeyFor @NonNull @Initialized ReadAll<T> build() {
                return this.autoBuild();
            }
        }
    }

    private static class Mutator<@UnknownKeyFor T> {
        private static final @UnknownKeyFor @NonNull @Initialized int CONCURRENT_ASYNC_QUERIES = 100;
        private final @UnknownKeyFor @NonNull @Initialized Cluster cluster;
        private final @UnknownKeyFor @NonNull @Initialized Session session;
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Session, @UnknownKeyFor @NonNull @Initialized Mapper> mapperFactoryFn;
        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Future<@UnknownKeyFor @Nullable @Initialized Void>> mutateFutures;
        private final @UnknownKeyFor @NonNull @Initialized BiFunction<@UnknownKeyFor @NonNull @Initialized Mapper<T>, T, @UnknownKeyFor @NonNull @Initialized Future<@UnknownKeyFor @Nullable @Initialized Void>> mutator;
        private final @UnknownKeyFor @NonNull @Initialized String operationName;

        Mutator(@UnknownKeyFor @NonNull @Initialized Write<T> spec, @UnknownKeyFor @NonNull @Initialized BiFunction<@UnknownKeyFor @NonNull @Initialized Mapper<T>, T, @UnknownKeyFor @NonNull @Initialized Future<@UnknownKeyFor @Nullable @Initialized Void>> mutator, @UnknownKeyFor @NonNull @Initialized String operationName) {
            this.cluster = CassandraIO.getCluster(spec.hosts(), spec.port(), spec.username(), spec.password(), spec.localDc(), spec.consistencyLevel(), spec.connectTimeout(), spec.readTimeout());
            this.session = this.cluster.connect((String)spec.keyspace().get());
            this.mapperFactoryFn = spec.mapperFactoryFn();
            this.mutateFutures = new ArrayList<Future<Void>>();
            this.mutator = mutator;
            this.operationName = operationName;
        }

        void mutate(T entity) throws @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
            Mapper mapper = (Mapper)this.mapperFactoryFn.apply((Object)this.session);
            this.mutateFutures.add(this.mutator.apply(mapper, (Mapper)entity));
            if (this.mutateFutures.size() == 100) {
                LOG.debug("Waiting for a batch of {} Cassandra {} to be executed...", (Object)100, (Object)this.operationName);
                this.waitForFuturesToFinish();
                this.mutateFutures = new ArrayList<Future<Void>>();
            }
        }

        void flush() throws @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
            if (this.mutateFutures.size() > 0) {
                this.waitForFuturesToFinish();
            }
        }

        void close() {
            if (this.session != null) {
                this.session.close();
            }
            if (this.cluster != null) {
                this.cluster.close();
            }
        }

        private void waitForFuturesToFinish() throws @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
            for (Future<Void> future : this.mutateFutures) {
                future.get();
            }
        }
    }

    private static class DeleteFn<@UnknownKeyFor T>
    extends DoFn<T, Void> {
        private final @UnknownKeyFor @NonNull @Initialized Write<T> spec;
        private transient @UnknownKeyFor @NonNull @Initialized Mutator<T> deleter;

        DeleteFn(@UnknownKeyFor @NonNull @Initialized Write<T> spec) {
            this.spec = spec;
        }

        @DoFn.Setup
        public void setup() {
            this.deleter = new Mutator<Object>(this.spec, Mapper::deleteAsync, "deletes");
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
            this.deleter.mutate(c.element());
        }

        @DoFn.FinishBundle
        public void finishBundle() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.deleter.flush();
        }

        @DoFn.Teardown
        public void teardown() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.deleter.close();
            this.deleter = null;
        }
    }

    private static class WriteFn<@UnknownKeyFor T>
    extends DoFn<T, Void> {
        private final @UnknownKeyFor @NonNull @Initialized Write<T> spec;
        private transient @UnknownKeyFor @NonNull @Initialized Mutator<T> writer;

        WriteFn(@UnknownKeyFor @NonNull @Initialized Write<T> spec) {
            this.spec = spec;
        }

        @DoFn.Setup
        public void setup() {
            this.writer = new Mutator<Object>(this.spec, Mapper::saveAsync, "writes");
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
            this.writer.mutate(c.element());
        }

        @DoFn.FinishBundle
        public void finishBundle() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.writer.flush();
        }

        @DoFn.Teardown
        public void teardown() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.writer.close();
            this.writer = null;
        }
    }

    @AutoValue
    @AutoValue.CopyAnnotations
    public static abstract class Write<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PDone> {
        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> hosts();

        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> port();

        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> keyspace();

        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized Class<T> entity();

        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> username();

        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> password();

        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> localDc();

        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> consistencyLevel();

        abstract @UnknownKeyFor @NonNull @Initialized MutationType mutationType();

        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> connectTimeout();

        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> readTimeout();

        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Session, @UnknownKeyFor @NonNull @Initialized Mapper> mapperFactoryFn();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> builder();

        static <T> @UnknownKeyFor @NonNull @Initialized Builder<T> builder(@UnknownKeyFor @NonNull @Initialized MutationType mutationType) {
            return new AutoValue_CassandraIO_Write.Builder().setMutationType(mutationType);
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withHosts(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> hosts) {
            Preconditions.checkArgument((hosts != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withHosts(hosts) called with null hosts"));
            Preconditions.checkArgument((!hosts.isEmpty() ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withHosts(hosts) called with empty hosts list"));
            return this.withHosts((ValueProvider<List<String>>)ValueProvider.StaticValueProvider.of(hosts));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withHosts(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> hosts) {
            return this.builder().setHosts(hosts).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withPort(@UnknownKeyFor @NonNull @Initialized int port) {
            Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (String)("CassandraIO." + this.getMutationTypeName() + "().withPort(port) called with invalid port number (%s)"), (int)port);
            return this.withPort((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)port));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withPort(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> port) {
            return this.builder().setPort(port).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withKeyspace(@UnknownKeyFor @NonNull @Initialized String keyspace) {
            Preconditions.checkArgument((keyspace != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withKeyspace(keyspace) called with null keyspace"));
            return this.withKeyspace((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)keyspace));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withKeyspace(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> keyspace) {
            return this.builder().setKeyspace(keyspace).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withEntity(@UnknownKeyFor @NonNull @Initialized Class<T> entity) {
            Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withEntity(entity) called with null entity"));
            return this.builder().setEntity(entity).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withUsername(@UnknownKeyFor @NonNull @Initialized String username) {
            Preconditions.checkArgument((username != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withUsername(username) called with null username"));
            return this.withUsername((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)username));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withUsername(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> username) {
            return this.builder().setUsername(username).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withPassword(@UnknownKeyFor @NonNull @Initialized String password) {
            Preconditions.checkArgument((password != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withPassword(password) called with null password"));
            return this.withPassword((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)password));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withPassword(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> password) {
            return this.builder().setPassword(password).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withLocalDc(@UnknownKeyFor @NonNull @Initialized String localDc) {
            Preconditions.checkArgument((localDc != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withLocalDc(localDc) called with null localDc"));
            return this.withLocalDc((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)localDc));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withLocalDc(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> localDc) {
            return this.builder().setLocalDc(localDc).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withConsistencyLevel(@UnknownKeyFor @NonNull @Initialized String consistencyLevel) {
            Preconditions.checkArgument((consistencyLevel != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withConsistencyLevel(consistencyLevel) called with null consistencyLevel"));
            return this.withConsistencyLevel((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)consistencyLevel));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withConsistencyLevel(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> consistencyLevel) {
            return this.builder().setConsistencyLevel(consistencyLevel).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withConnectTimeout(@UnknownKeyFor @NonNull @Initialized Integer timeout) {
            Preconditions.checkArgument((timeout != null && timeout > 0 ? 1 : 0) != 0, (String)("CassandraIO." + this.getMutationTypeName() + "().withConnectTimeout(timeout) called with invalid timeout number (%s)"), (Object)timeout);
            return this.withConnectTimeout((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)timeout));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withConnectTimeout(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> timeout) {
            return this.builder().setConnectTimeout(timeout).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withReadTimeout(@UnknownKeyFor @NonNull @Initialized Integer timeout) {
            Preconditions.checkArgument((timeout != null && timeout > 0 ? 1 : 0) != 0, (String)("CassandraIO." + this.getMutationTypeName() + "().withReadTimeout(timeout) called with invalid timeout number (%s)"), (Object)timeout);
            return this.withReadTimeout((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)timeout));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withReadTimeout(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> timeout) {
            return this.builder().setReadTimeout(timeout).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withMapperFactoryFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Session, @UnknownKeyFor @NonNull @Initialized Mapper> mapperFactoryFn) {
            Preconditions.checkArgument((mapperFactoryFn != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().mapperFactoryFn(mapperFactoryFn) called with null value"));
            return this.builder().setMapperFactoryFn(mapperFactoryFn).build();
        }

        public void validate(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
            Preconditions.checkState((this.hosts() != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "() requires a list of hosts to be set via withHosts(hosts)"));
            Preconditions.checkState((this.port() != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "() requires a valid port number to be set via withPort(port)"));
            Preconditions.checkState((this.keyspace() != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "() requires a keyspace to be set via withKeyspace(keyspace)"));
            Preconditions.checkState((this.entity() != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "() requires an entity to be set via withEntity(entity)"));
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            if (this.mutationType() == MutationType.DELETE) {
                input.apply((PTransform)ParDo.of(new DeleteFn(this)));
            } else {
                input.apply((PTransform)ParDo.of(new WriteFn(this)));
            }
            return PDone.in((Pipeline)input.getPipeline());
        }

        private @UnknownKeyFor @NonNull @Initialized String getMutationTypeName() {
            return this.mutationType() == null ? MutationType.WRITE.name().toLowerCase() : this.mutationType().name().toLowerCase();
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setHosts(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setPort(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setKeyspace(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setEntity(@UnknownKeyFor @NonNull @Initialized Class<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Class<T>> entity();

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setUsername(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setPassword(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setLocalDc(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setConsistencyLevel(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMutationType(@UnknownKeyFor @NonNull @Initialized MutationType var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setConnectTimeout(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setReadTimeout(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMapperFactoryFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Session, @UnknownKeyFor @NonNull @Initialized Mapper> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Session, @UnknownKeyFor @NonNull @Initialized Mapper>> mapperFactoryFn();

            abstract @UnknownKeyFor @NonNull @Initialized Write<T> autoBuild();

            public @UnknownKeyFor @NonNull @Initialized Write<T> build() {
                if (!this.mapperFactoryFn().isPresent() && this.entity().isPresent()) {
                    this.setMapperFactoryFn(new DefaultObjectMapperFactory<T>(this.entity().get()));
                }
                return this.autoBuild();
            }
        }
    }

    public static enum MutationType {
        WRITE,
        DELETE;

    }

    @AutoValue
    @AutoValue.CopyAnnotations
    public static abstract class Read<@UnknownKeyFor T>
    extends PTransform<PBegin, PCollection<T>> {
        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> hosts();

        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> query();

        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> port();

        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> keyspace();

        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> table();

        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized Class<T> entity();

        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized Coder<T> coder();

        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> username();

        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> password();

        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> localDc();

        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> consistencyLevel();

        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> minNumberOfSplits();

        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> connectTimeout();

        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> readTimeout();

        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Session, @UnknownKeyFor @NonNull @Initialized Mapper> mapperFactoryFn();

        @javax.annotation.Nullable
        abstract @UnknownKeyFor @Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized RingRange>> ringRanges();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> builder();

        public @UnknownKeyFor @NonNull @Initialized Read<T> withHosts(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> hosts) {
            Preconditions.checkArgument((hosts != null ? 1 : 0) != 0, (Object)"hosts can not be null");
            Preconditions.checkArgument((!hosts.isEmpty() ? 1 : 0) != 0, (Object)"hosts can not be empty");
            return this.withHosts((ValueProvider<List<String>>)ValueProvider.StaticValueProvider.of(hosts));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withHosts(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> hosts) {
            return this.builder().setHosts(hosts).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withPort(@UnknownKeyFor @NonNull @Initialized int port) {
            Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (String)"port must be > 0, but was: %s", (int)port);
            return this.withPort((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)port));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withPort(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> port) {
            return this.builder().setPort(port).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withKeyspace(@UnknownKeyFor @NonNull @Initialized String keyspace) {
            Preconditions.checkArgument((keyspace != null ? 1 : 0) != 0, (Object)"keyspace can not be null");
            return this.withKeyspace((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)keyspace));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withKeyspace(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> keyspace) {
            return this.builder().setKeyspace(keyspace).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withTable(@UnknownKeyFor @NonNull @Initialized String table) {
            Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"table can not be null");
            return this.withTable((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)table));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withTable(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> table) {
            return this.builder().setTable(table).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withQuery(@UnknownKeyFor @NonNull @Initialized String query) {
            Preconditions.checkArgument((query != null && query.length() > 0 ? 1 : 0) != 0, (Object)"query cannot be null");
            return this.withQuery((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)query));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withQuery(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> query) {
            return this.builder().setQuery(query).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withEntity(@UnknownKeyFor @NonNull @Initialized Class<T> entity) {
            Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"entity can not be null");
            return this.builder().setEntity(entity).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            Preconditions.checkArgument((coder != null ? 1 : 0) != 0, (Object)"coder can not be null");
            return this.builder().setCoder(coder).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withUsername(@UnknownKeyFor @NonNull @Initialized String username) {
            Preconditions.checkArgument((username != null ? 1 : 0) != 0, (Object)"username can not be null");
            return this.withUsername((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)username));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withUsername(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> username) {
            return this.builder().setUsername(username).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withPassword(@UnknownKeyFor @NonNull @Initialized String password) {
            Preconditions.checkArgument((password != null ? 1 : 0) != 0, (Object)"password can not be null");
            return this.withPassword((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)password));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withPassword(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> password) {
            return this.builder().setPassword(password).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withLocalDc(@UnknownKeyFor @NonNull @Initialized String localDc) {
            Preconditions.checkArgument((localDc != null ? 1 : 0) != 0, (Object)"localDc can not be null");
            return this.withLocalDc((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)localDc));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withLocalDc(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> localDc) {
            return this.builder().setLocalDc(localDc).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withConsistencyLevel(@UnknownKeyFor @NonNull @Initialized String consistencyLevel) {
            Preconditions.checkArgument((consistencyLevel != null ? 1 : 0) != 0, (Object)"consistencyLevel can not be null");
            return this.withConsistencyLevel((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)consistencyLevel));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withConsistencyLevel(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> consistencyLevel) {
            return this.builder().setConsistencyLevel(consistencyLevel).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withMinNumberOfSplits(@UnknownKeyFor @NonNull @Initialized Integer minNumberOfSplits) {
            Preconditions.checkArgument((minNumberOfSplits != null ? 1 : 0) != 0, (Object)"minNumberOfSplits can not be null");
            Preconditions.checkArgument((minNumberOfSplits > 0 ? 1 : 0) != 0, (Object)"minNumberOfSplits must be greater than 0");
            return this.withMinNumberOfSplits((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)minNumberOfSplits));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withMinNumberOfSplits(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> minNumberOfSplits) {
            return this.builder().setMinNumberOfSplits(minNumberOfSplits).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withConnectTimeout(@UnknownKeyFor @NonNull @Initialized Integer timeout) {
            Preconditions.checkArgument((timeout != null ? 1 : 0) != 0, (Object)"Connect timeout can not be null");
            Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0, (String)"Connect timeout must be > 0, but was: %s", (Object)timeout);
            return this.withConnectTimeout((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)timeout));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withConnectTimeout(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> timeout) {
            return this.builder().setConnectTimeout(timeout).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withReadTimeout(@UnknownKeyFor @NonNull @Initialized Integer timeout) {
            Preconditions.checkArgument((timeout != null ? 1 : 0) != 0, (Object)"Read timeout can not be null");
            Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0, (String)"Read timeout must be > 0, but was: %s", (Object)timeout);
            return this.withReadTimeout((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)timeout));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withReadTimeout(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> timeout) {
            return this.builder().setReadTimeout(timeout).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withMapperFactoryFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Session, @UnknownKeyFor @NonNull @Initialized Mapper> mapperFactory) {
            Preconditions.checkArgument((mapperFactory != null ? 1 : 0) != 0, (Object)"CassandraIO.withMapperFactory(withMapperFactory) called with null value");
            return this.builder().setMapperFactoryFn(mapperFactory).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withRingRanges(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized RingRange> ringRange) {
            return this.withRingRanges((ValueProvider<Set<RingRange>>)ValueProvider.StaticValueProvider.of(ringRange));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withRingRanges(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized RingRange>> ringRange) {
            return this.builder().setRingRanges(ringRange).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            Preconditions.checkArgument((this.hosts() != null && this.port() != null ? 1 : 0) != 0, (Object)"WithHosts() and withPort() are required");
            Preconditions.checkArgument((this.keyspace() != null ? 1 : 0) != 0, (Object)"withKeyspace() is required");
            Preconditions.checkArgument((this.table() != null ? 1 : 0) != 0, (Object)"withTable() is required");
            Preconditions.checkArgument((this.entity() != null ? 1 : 0) != 0, (Object)"withEntity() is required");
            Preconditions.checkArgument((this.coder() != null ? 1 : 0) != 0, (Object)"withCoder() is required");
            PCollection splits = ((PCollection)((PCollection)input.apply((PTransform)Create.of((Object)((Object)this), (Object[])new Read[0]))).apply("Create Splits", (PTransform)ParDo.of(new SplitFn()))).setCoder((Coder)SerializableCoder.of((TypeDescriptor)new TypeDescriptor<Read<T>>(){}));
            return (PCollection)splits.apply("ReadAll", CassandraIO.readAll().withCoder(this.coder()));
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setHosts(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setQuery(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setPort(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setKeyspace(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setTable(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setEntity(@UnknownKeyFor @NonNull @Initialized Class<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Class<T>> entity();

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setUsername(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setPassword(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setLocalDc(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setConsistencyLevel(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMinNumberOfSplits(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setConnectTimeout(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setReadTimeout(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMapperFactoryFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Session, @UnknownKeyFor @NonNull @Initialized Mapper> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Session, @UnknownKeyFor @NonNull @Initialized Mapper>> mapperFactoryFn();

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setRingRanges(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized RingRange>> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read<T> autoBuild();

            public @UnknownKeyFor @NonNull @Initialized Read<T> build() {
                if (!this.mapperFactoryFn().isPresent() && this.entity().isPresent()) {
                    this.setMapperFactoryFn(new DefaultObjectMapperFactory<T>(this.entity().get()));
                }
                return this.autoBuild();
            }
        }

        private static class SplitFn<@UnknownKeyFor T>
        extends DoFn<Read<T>, Read<T>> {
            private SplitFn() {
            }

            @DoFn.ProcessElement
            public void process(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Read<T> read, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Read<T>> outputReceiver) {
                Set<RingRange> ringRanges = SplitFn.getRingRanges(read);
                for (RingRange rr : ringRanges) {
                    outputReceiver.output(read.withRingRanges((Set<RingRange>)ImmutableSet.of((Object)rr)));
                }
            }

            private static <T> @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized RingRange> getRingRanges(@UnknownKeyFor @NonNull @Initialized Read<T> read) {
                try (Cluster cluster = CassandraIO.getCluster(read.hosts(), read.port(), read.username(), read.password(), read.localDc(), read.consistencyLevel(), read.connectTimeout(), read.readTimeout());){
                    if (CassandraIO.isMurmur3Partitioner(cluster)) {
                        LOG.info("Murmur3Partitioner detected, splitting");
                        Integer splitCount = read.minNumberOfSplits() != null && read.minNumberOfSplits().get() != null ? (Integer)read.minNumberOfSplits().get() : Integer.valueOf(cluster.getMetadata().getAllHosts().size());
                        List<BigInteger> tokens = cluster.getMetadata().getTokenRanges().stream().map(tokenRange -> new BigInteger(tokenRange.getEnd().getValue().toString())).collect(Collectors.toList());
                        SplitGenerator splitGenerator = new SplitGenerator(cluster.getMetadata().getPartitioner());
                        Set<RingRange> set = splitGenerator.generateSplits(splitCount.intValue(), tokens).stream().flatMap(Collection::stream).collect(Collectors.toSet());
                        return set;
                    }
                    LOG.warn("Only Murmur3Partitioner is supported for splitting, using an unique source for the read");
                    String partitioner = cluster.getMetadata().getPartitioner();
                    RingRange totalRingRange = RingRange.of(SplitGenerator.getRangeMin(partitioner), SplitGenerator.getRangeMax(partitioner));
                    Set<RingRange> set = Collections.singleton(totalRingRange);
                    return set;
                }
            }
        }
    }
}

