/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import org.apache.beam.sdk.io.common.IOTestPipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraTestDataSet {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraTestDataSet.class);
    public static final String KEYSPACE = "BEAM";
    public static final String TABLE_READ_NAME = "BEAM_READ_TEST";
    public static final String TABLE_WRITE_NAME = "BEAM_WRITE_TEST";

    public static void main(String[] args) {
        PipelineOptionsFactory.register(IOTestPipelineOptions.class);
        IOTestPipelineOptions options = (IOTestPipelineOptions)PipelineOptionsFactory.fromArgs((String[])args).as(IOTestPipelineOptions.class);
        CassandraTestDataSet.createDataTable(options);
    }

    public static void createDataTable(IOTestPipelineOptions options) {
        CassandraTestDataSet.createTable(options, TABLE_READ_NAME);
        CassandraTestDataSet.insertTestData(options, TABLE_READ_NAME);
        CassandraTestDataSet.createTable(options, TABLE_WRITE_NAME);
    }

    public static Cluster getCluster(IOTestPipelineOptions options) {
        return Cluster.builder().addContactPoint(options.getCassandraHost()).withPort(options.getCassandraPort().intValue()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createTable(IOTestPipelineOptions options, String tableName) {
        Cluster cluster = null;
        Session session = null;
        try {
            cluster = CassandraTestDataSet.getCluster(options);
            session = cluster.connect();
            LOG.info("Create {} keyspace if not exists", (Object)KEYSPACE);
            session.execute("CREATE KEYSPACE IF NOT EXISTS BEAM WITH REPLICATION = {'class':'SimpleStrategy', 'replication_factor':3};");
            session.execute("USE BEAM");
            LOG.info("Create {} table if not exists", (Object)tableName);
            session.execute("CREATE TABLE IF NOT EXISTS " + tableName + "(id int, name text, PRIMARY KEY(id))");
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (cluster != null) {
                cluster.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertTestData(IOTestPipelineOptions options, String tableName) {
        Cluster cluster = null;
        Session session = null;
        try {
            cluster = CassandraTestDataSet.getCluster(options);
            session = cluster.connect();
            LOG.info("Insert test dataset");
            String[] scientists = new String[]{"Lovelace", "Franklin", "Meitner", "Hopper", "Curie", "Faraday", "Newton", "Bohr", "Galilei", "Maxwell"};
            for (int i = 0; i < 1000; ++i) {
                int index = i % scientists.length;
                session.execute("INSERT INTO BEAM." + tableName + "(id, name) values(" + i + ",'" + scientists[index] + "');");
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (cluster != null) {
                cluster.close();
            }
        }
    }

    public static void cleanUpDataTable(IOTestPipelineOptions options) {
        Cluster cluster = null;
        Session session = null;
        try {
            cluster = CassandraTestDataSet.getCluster(options);
            session = cluster.connect();
            session.execute("TRUNCATE TABLE BEAM.BEAM_WRITE_TEST");
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (cluster != null) {
                cluster.close();
            }
        }
    }
}

