/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Metadata;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.io.cassandra.CassandraIO;
import org.apache.beam.sdk.io.cassandra.CassandraServiceImpl;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraServiceImplTest {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraServiceImplTest.class);
    private static final String MURMUR3_PARTITIONER = "org.apache.cassandra.dht.Murmur3Partitioner";

    private Cluster createClusterMock() {
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        Mockito.when((Object)metadata.getPartitioner()).thenReturn((Object)MURMUR3_PARTITIONER);
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Mockito.when((Object)cluster.getMetadata()).thenReturn((Object)metadata);
        return cluster;
    }

    @Test
    public void testValidPartitioner() throws Exception {
        Assert.assertTrue((boolean)CassandraServiceImpl.isMurmur3Partitioner((Cluster)this.createClusterMock()));
    }

    @Test
    public void testDistance() throws Exception {
        BigInteger distance = CassandraServiceImpl.distance((long)10L, (long)100L);
        Assert.assertEquals((Object)BigInteger.valueOf(90L), (Object)distance);
        distance = CassandraServiceImpl.distance((long)100L, (long)10L);
        Assert.assertEquals((Object)new BigInteger("18446744073709551525"), (Object)distance);
    }

    @Test
    public void testRingFraction() throws Exception {
        ArrayList<CassandraServiceImpl.TokenRange> tokenRanges = new ArrayList<CassandraServiceImpl.TokenRange>();
        tokenRanges.add(new CassandraServiceImpl.TokenRange(1L, 1L, Long.MIN_VALUE, 0L));
        Assert.assertEquals((double)0.5, (double)CassandraServiceImpl.getRingFraction(tokenRanges), (double)0.0);
        tokenRanges.add(new CassandraServiceImpl.TokenRange(1L, 1L, 0L, Long.MAX_VALUE));
        Assert.assertEquals((double)1.0, (double)CassandraServiceImpl.getRingFraction(tokenRanges), (double)0.0);
    }

    @Test
    public void testEstimatedSizeBytes() throws Exception {
        ArrayList<CassandraServiceImpl.TokenRange> tokenRanges = new ArrayList<CassandraServiceImpl.TokenRange>();
        tokenRanges.add(new CassandraServiceImpl.TokenRange(1L, 1000L, Long.MIN_VALUE, Long.MAX_VALUE));
        Assert.assertEquals((long)1000L, (long)CassandraServiceImpl.getEstimatedSizeBytes(tokenRanges));
        tokenRanges = new ArrayList();
        tokenRanges.add(new CassandraServiceImpl.TokenRange(1L, 1000L, Long.MIN_VALUE, 0L));
        Assert.assertEquals((long)2000L, (long)CassandraServiceImpl.getEstimatedSizeBytes(tokenRanges));
        tokenRanges = new ArrayList();
        tokenRanges.add(new CassandraServiceImpl.TokenRange(1L, 1000L, Long.MIN_VALUE, -3L));
        tokenRanges.add(new CassandraServiceImpl.TokenRange(1L, 1000L, -2L, 10000L));
        tokenRanges.add(new CassandraServiceImpl.TokenRange(2L, 3000L, 10001L, Long.MAX_VALUE));
        Assert.assertEquals((long)8000L, (long)CassandraServiceImpl.getEstimatedSizeBytes(tokenRanges));
    }

    @Test
    public void testThreeSplits() throws Exception {
        CassandraServiceImpl service = new CassandraServiceImpl();
        CassandraIO.Read spec = CassandraIO.read().withKeyspace("beam").withTable("test");
        List sources = service.split(spec, 50L, 150L);
        Assert.assertEquals((long)3L, (long)sources.size());
        Assert.assertTrue((boolean)((CassandraIO.CassandraSource)sources.get((int)0)).splitQuery.matches("SELECT \\* FROM beam.test WHERE token\\(\\$pk\\)<(.*)"));
        Assert.assertTrue((boolean)((CassandraIO.CassandraSource)sources.get((int)1)).splitQuery.matches("SELECT \\* FROM beam.test WHERE token\\(\\$pk\\)>=(.*) AND token\\(\\$pk\\)<(.*)"));
        Assert.assertTrue((boolean)((CassandraIO.CassandraSource)sources.get((int)2)).splitQuery.matches("SELECT \\* FROM beam.test WHERE token\\(\\$pk\\)>=(.*)"));
    }

    @Test
    public void testTwoSplits() throws Exception {
        CassandraServiceImpl service = new CassandraServiceImpl();
        CassandraIO.Read spec = CassandraIO.read().withKeyspace("beam").withTable("test");
        List sources = service.split(spec, 50L, 100L);
        Assert.assertEquals((long)2L, (long)sources.size());
        LOG.info("TOKEN: 4.6116860184273879E18");
        LOG.info(((CassandraIO.CassandraSource)sources.get((int)0)).splitQuery);
        LOG.info(((CassandraIO.CassandraSource)sources.get((int)1)).splitQuery);
        Assert.assertEquals((Object)"SELECT * FROM beam.test WHERE token($pk)<4.6116860184273879E18;", (Object)((CassandraIO.CassandraSource)sources.get((int)0)).splitQuery);
        Assert.assertEquals((Object)"SELECT * FROM beam.test WHERE token($pk)>=4.6116860184273879E18;", (Object)((CassandraIO.CassandraSource)sources.get((int)1)).splitQuery);
    }

    @Test
    public void testUniqueSplit() throws Exception {
        CassandraServiceImpl service = new CassandraServiceImpl();
        CassandraIO.Read spec = CassandraIO.read().withKeyspace("beam").withTable("test");
        List sources = service.split(spec, 100L, 100L);
        Assert.assertEquals((long)1L, (long)sources.size());
        Assert.assertEquals((Object)"SELECT * FROM beam.test;", (Object)((CassandraIO.CassandraSource)sources.get((int)0)).splitQuery);
    }
}

