/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.azure.blobstore;

import java.util.Arrays;
import java.util.Collection;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.azure.blobstore.AzfsResourceId;
import org.apache.beam.sdk.io.azure.options.BlobstoreOptions;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.fs.ResourceIdTester;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class AzfsResourceIdTest {

    @RunWith(value=JUnit4.class)
    public static class NonParameterizedTests {
        @Rule
        public ExpectedException thrown = ExpectedException.none();

        @Test
        public void testMultipleResolves() {
            Assert.assertEquals((Object)AzfsResourceId.fromUri((String)"azfs://account/container/tmp/aa/bb/cc/"), (Object)AzfsResourceId.fromUri((String)"azfs://account/container/tmp/").resolve("aa", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("bb", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("cc", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY));
        }

        @Test
        public void testResolveInvalidInputs() {
            this.thrown.expect(IllegalArgumentException.class);
            this.thrown.expectMessage("Cannot resolve a file with a directory path: [tmp/]");
            AzfsResourceId.fromUri((String)"azfs://account/my_container/").resolve("tmp/", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
        }

        @Test
        public void testResolveInvalidNotDirectory() {
            ResourceId tmpDir = AzfsResourceId.fromUri((String)"azfs://account/my_container/").resolve("tmp dir", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
            this.thrown.expect(IllegalStateException.class);
            this.thrown.expectMessage("Expected this resource to be a directory, but was [azfs://account/my_container/tmp dir]");
            tmpDir.resolve("aa", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
        }

        @Test
        public void testResolveWithFileBase() {
            AzfsResourceId resourceId = AzfsResourceId.fromUri((String)"azfs://account/container/path/to/file");
            this.thrown.expect(IllegalStateException.class);
            resourceId.resolve("child-path", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY);
        }

        @Test
        public void testResolveParentToFile() {
            AzfsResourceId resourceId = AzfsResourceId.fromUri((String)"azfs://account/container/path/to/dir/");
            this.thrown.expect(IllegalArgumentException.class);
            resourceId.resolve("..", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
        }

        @Test
        public void testEquals() {
            AzfsResourceId a = AzfsResourceId.fromComponents((String)"account", (String)"container", (String)"a/b/c");
            AzfsResourceId b = AzfsResourceId.fromComponents((String)"account", (String)"container", (String)"a/b/c");
            Assert.assertEquals((Object)a, (Object)b);
            b = AzfsResourceId.fromComponents((String)a.getAccount(), (String)a.getContainer(), (String)"a/b/c/");
            Assert.assertNotEquals((Object)a, (Object)b);
            b = AzfsResourceId.fromComponents((String)a.getAccount(), (String)a.getContainer(), (String)"x/y/z");
            Assert.assertNotEquals((Object)a, (Object)b);
            b = AzfsResourceId.fromComponents((String)a.getAccount(), (String)"other-container", (String)a.getBlob());
            Assert.assertNotEquals((Object)a, (Object)b);
            b = AzfsResourceId.fromComponents((String)"other-account", (String)a.getContainer(), (String)a.getBlob());
            Assert.assertNotEquals((Object)a, (Object)b);
            Assert.assertEquals((Object)AzfsResourceId.fromUri((String)"azfs://account/container"), (Object)AzfsResourceId.fromUri((String)"azfs://account/container/"));
        }

        @Test
        public void testFromComponents() {
            AzfsResourceId resourceId = AzfsResourceId.fromComponents((String)"account", (String)"container", (String)"blob");
            Assert.assertEquals((Object)"azfs", (Object)resourceId.getScheme());
            Assert.assertEquals((Object)"account", (Object)resourceId.getAccount());
            Assert.assertEquals((Object)"container", (Object)resourceId.getContainer());
            Assert.assertEquals((Object)"blob", (Object)resourceId.getBlob());
            Assert.assertEquals((Object)"virtualDir/blob", (Object)AzfsResourceId.fromComponents((String)"account", (String)"container", (String)"virtualDir/blob").getBlob());
            Assert.assertEquals(null, (Object)AzfsResourceId.fromComponents((String)"account", (String)"container").getBlob());
            Assert.assertEquals(null, (Object)AzfsResourceId.fromComponents((String)"account", (String)"container", (String)"").getBlob());
            Assert.assertEquals(null, (Object)AzfsResourceId.fromComponents((String)"account", (String)"container", null).getBlob());
        }

        @Test
        public void testFromUri() {
            AzfsResourceId resourceId = AzfsResourceId.fromUri((String)"azfs://account/container/blob");
            Assert.assertEquals((Object)"azfs", (Object)resourceId.getScheme());
            Assert.assertEquals((Object)"account", (Object)resourceId.getAccount());
            Assert.assertEquals((Object)"container", (Object)resourceId.getContainer());
            Assert.assertEquals((Object)"blob", (Object)resourceId.getBlob());
            Assert.assertEquals((Object)"virtualDir/blob", (Object)AzfsResourceId.fromUri((String)"azfs://account/container/virtualDir/blob").getBlob());
            Assert.assertEquals(null, (Object)AzfsResourceId.fromUri((String)"azfs://account/container").getBlob());
        }

        @Test
        public void testIsDirectory() {
            Assert.assertTrue((boolean)AzfsResourceId.fromUri((String)"azfs://account/container/virtualDir/").isDirectory());
            Assert.assertTrue((boolean)AzfsResourceId.fromUri((String)"azfs://account/container").isDirectory());
            Assert.assertFalse((boolean)AzfsResourceId.fromUri((String)"azfs://account/container/virtualDir/blob").isDirectory());
        }

        @Test
        public void testGetCurrentDirectory() {
            Assert.assertEquals((Object)AzfsResourceId.fromUri((String)"azfs://account/container/virtualDir/"), (Object)AzfsResourceId.fromUri((String)"azfs://account/container/virtualDir/").getCurrentDirectory());
            Assert.assertEquals((Object)AzfsResourceId.fromUri((String)"azfs://account/container/\u8f93\u51fa \u76ee\u5f55/"), (Object)AzfsResourceId.fromUri((String)"azfs://account/container/\u8f93\u51fa \u76ee\u5f55/\u6587\u4ef601.txt").getCurrentDirectory());
            Assert.assertEquals((Object)AzfsResourceId.fromUri((String)"azfs://account/container"), (Object)AzfsResourceId.fromUri((String)"azfs://account/container").getCurrentDirectory());
            Assert.assertEquals((Object)AzfsResourceId.fromUri((String)"azfs://account/container/"), (Object)AzfsResourceId.fromUri((String)"azfs://account/container/blob").getCurrentDirectory());
        }

        @Test
        public void testInvalidPathNoContainer() {
            this.thrown.expect(IllegalArgumentException.class);
            this.thrown.expectMessage("Invalid AZFS URI: [azfs://]");
            AzfsResourceId.fromUri((String)"azfs://");
        }

        @Test
        public void testInvalidPathNoContainerAndSlash() {
            this.thrown.expect(IllegalArgumentException.class);
            this.thrown.expectMessage("Invalid AZFS URI: [azfs:///]");
            AzfsResourceId.fromUri((String)"azfs:///");
        }

        @Test
        public void testGetScheme() {
            Assert.assertEquals((Object)"azfs", (Object)AzfsResourceId.fromUri((String)"azfs://account/container/virtualDir/").getScheme());
            Assert.assertEquals((Object)"azfs", (Object)AzfsResourceId.fromUri((String)"azfs://account/container").getScheme());
        }

        @Test
        public void testGetFilename() {
            Assert.assertNull((Object)AzfsResourceId.fromUri((String)"azfs://account/container").getFilename());
            Assert.assertEquals((Object)"blob", (Object)AzfsResourceId.fromUri((String)"azfs://account/container/blob").getFilename());
            Assert.assertEquals((Object)"blob", (Object)AzfsResourceId.fromUri((String)"azfs://account/container/blob/").getFilename());
            Assert.assertEquals((Object)"blob", (Object)AzfsResourceId.fromUri((String)"azfs://account/container/virtualDir/blob").getFilename());
            Assert.assertEquals((Object)"blob", (Object)AzfsResourceId.fromUri((String)"azfs://account/container/virtualDir/blob/").getFilename());
            Assert.assertEquals((Object)"blob.txt", (Object)AzfsResourceId.fromUri((String)"azfs://account/container/virtualDir/blob.txt/").getFilename());
        }

        @Test
        public void testContainerParsing() {
            AzfsResourceId path1 = AzfsResourceId.fromUri((String)"azfs://account/container");
            AzfsResourceId path2 = AzfsResourceId.fromUri((String)"azfs://account/container/");
            Assert.assertEquals((Object)path1, (Object)path2);
            Assert.assertEquals((Object)path1.toString(), (Object)path2.toString());
        }

        @Test
        public void testAzfsResourceIdToString() {
            String filename = "azfs://account/container/dir/file.txt";
            AzfsResourceId path = AzfsResourceId.fromUri((String)filename);
            Assert.assertEquals((Object)filename, (Object)path.toString());
            filename = "azfs://account/container/blob/";
            path = AzfsResourceId.fromUri((String)filename);
            Assert.assertEquals((Object)filename, (Object)path.toString());
            filename = "azfs://account/container/";
            path = AzfsResourceId.fromUri((String)filename);
            Assert.assertEquals((Object)filename, (Object)path.toString());
        }

        @Test
        public void testInvalidAzfsResourceId() {
            this.thrown.expect(IllegalArgumentException.class);
            AzfsResourceId.fromUri((String)"file://an/invalid/azfs/path");
        }

        @Test
        public void testInvalidContainer() {
            this.thrown.expect(IllegalArgumentException.class);
            AzfsResourceId.fromComponents((String)"account", (String)"invalid/", (String)"");
        }

        @Test
        public void testIsWildcard() {
            Assert.assertTrue((boolean)AzfsResourceId.fromUri((String)"azfs://account/container/dir/*.txt").isWildcard());
            Assert.assertTrue((boolean)AzfsResourceId.fromUri((String)"azfs://account/container/a?c/glob").isWildcard());
            Assert.assertTrue((boolean)AzfsResourceId.fromUri((String)"azfs://account/container/a[bcd]e/glob").isWildcard());
            Assert.assertFalse((boolean)AzfsResourceId.fromComponents((String)"account", (String)"container").isWildcard());
        }

        @Test
        public void testResourceIdTester() {
            BlobstoreOptions options = (BlobstoreOptions)PipelineOptionsFactory.create().as(BlobstoreOptions.class);
            FileSystems.setDefaultPipelineOptions((PipelineOptions)options);
            ResourceIdTester.runResourceIdBattery((ResourceId)AzfsResourceId.fromUri((String)"azfs://account/container/blob/"));
        }
    }

    @RunWith(value=Parameterized.class)
    public static class ResolveTest {
        @Parameterized.Parameter(value=0)
        public String baseUri;
        @Parameterized.Parameter(value=1)
        public String relativePath;
        @Parameterized.Parameter(value=2)
        public ResolveOptions.StandardResolveOptions resolveOptions;
        @Parameterized.Parameter(value=3)
        public String expectedResult;

        @Parameterized.Parameters
        public static Collection<Object[]> paths() {
            return Arrays.asList({"azfs://account/container/", "", ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY, "azfs://account/container/"}, {"azfs://account/container", "", ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY, "azfs://account/container/"}, {"azfs://account/container", "path/to/dir", ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY, "azfs://account/container/path/to/dir/"}, {"azfs://account/container", "path/to/object", ResolveOptions.StandardResolveOptions.RESOLVE_FILE, "azfs://account/container/path/to/object"}, {"azfs://account/container/path/to/dir/", "..", ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY, "azfs://account/container/path/to/"}, {"azfs://account/container/tmp/", "aa", ResolveOptions.StandardResolveOptions.RESOLVE_FILE, "azfs://account/container/tmp/aa"}, {"azfs://account/container/tmp/bb/", "azfs://account/container/tmp/aa", ResolveOptions.StandardResolveOptions.RESOLVE_FILE, "azfs://account/container/tmp/aa"}, {"azfs://account/my-container", "tmp", ResolveOptions.StandardResolveOptions.RESOLVE_FILE, "azfs://account/my-container/tmp"}, {"azfs://account/container/\u8f93\u51fa \u76ee\u5f55/", "\u8f93\u51fa \u6587\u4ef601.txt", ResolveOptions.StandardResolveOptions.RESOLVE_FILE, "azfs://account/container/\u8f93\u51fa \u76ee\u5f55/\u8f93\u51fa \u6587\u4ef601.txt"});
        }

        @Test
        public void testResolve() {
            AzfsResourceId resourceId = AzfsResourceId.fromUri((String)this.baseUri);
            ResourceId resolved = resourceId.resolve(this.relativePath, (ResolveOptions)this.resolveOptions);
            Assert.assertEquals((Object)this.expectedResult, (Object)resolved.toString());
        }
    }
}

