/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.azure.blobstore;

import com.azure.core.http.rest.PagedIterable;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.specialized.BlobInputStream;
import com.azure.storage.blob.specialized.BlobOutputStream;
import com.azure.storage.blob.specialized.BlockBlobClient;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.beam.sdk.io.azure.blobstore.AzfsResourceId;
import org.apache.beam.sdk.io.azure.blobstore.AzureBlobStoreFileSystem;
import org.apache.beam.sdk.io.azure.options.BlobstoreOptions;
import org.apache.beam.sdk.io.fs.CreateOptions;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class AzureBlobStoreFileSystemTest {
    private static @UnknownKeyFor @NonNull @Initialized AzureBlobStoreFileSystem azureBlobStoreFileSystem;
    @UnknownKeyFor @NonNull @Initialized BlobstoreOptions options = (BlobstoreOptions)PipelineOptionsFactory.as(BlobstoreOptions.class);
    @UnknownKeyFor @NonNull @Initialized BlobstoreOptions spyOptions = (BlobstoreOptions)Mockito.spy((Object)this.options);
    @UnknownKeyFor @NonNull @Initialized BlobServiceClient mockedServiceClient = (BlobServiceClient)Mockito.mock(BlobServiceClient.class);
    @UnknownKeyFor @NonNull @Initialized BlobContainerClient mockedContainerClient = (BlobContainerClient)Mockito.mock(BlobContainerClient.class);
    @UnknownKeyFor @NonNull @Initialized BlobClient mockedBlobClient = (BlobClient)Mockito.mock(BlobClient.class);
    @UnknownKeyFor @NonNull @Initialized BlockBlobClient mockedBlockBlob = (BlockBlobClient)Mockito.mock(BlockBlobClient.class);
    @UnknownKeyFor @NonNull @Initialized BlobProperties mockedProperties = (BlobProperties)Mockito.mock(BlobProperties.class);
    @UnknownKeyFor @NonNull @Initialized PagedIterable<@UnknownKeyFor @NonNull @Initialized BlobItem> mockedPagedIterable = (PagedIterable)Mockito.mock(PagedIterable.class);
    @UnknownKeyFor @NonNull @Initialized BlobOutputStream mockedOutputStream = (BlobOutputStream)Mockito.mock(BlobOutputStream.class);
    @UnknownKeyFor @NonNull @Initialized BlobItem mockedBlobItem = (BlobItem)Mockito.mock(BlobItem.class);
    @UnknownKeyFor @NonNull @Initialized BlobInputStream mockedInputStream = (BlobInputStream)Mockito.mock(BlobInputStream.class);

    @Before
    public void beforeClass() {
        azureBlobStoreFileSystem = new AzureBlobStoreFileSystem(this.spyOptions);
        azureBlobStoreFileSystem.setClient(this.mockedServiceClient);
        boolean[] containerCreated = new boolean[]{false};
        Mockito.when((Object)this.mockedServiceClient.createBlobContainer(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            containerCreated[0] = true;
            return this.mockedContainerClient;
        });
        Mockito.when((Object)this.mockedContainerClient.exists()).thenAnswer(invocation -> containerCreated[0]);
        boolean[] blobCreated = new boolean[]{false};
        ((BlobClient)Mockito.doAnswer(invocation -> {
            blobCreated[0] = true;
            return null;
        }).when((Object)this.mockedBlobClient)).uploadFromFile(ArgumentMatchers.anyString());
        Mockito.when((Object)this.mockedBlobClient.exists()).thenAnswer(invocation -> blobCreated[0]);
        Mockito.when((Object)azureBlobStoreFileSystem.getClient().getBlobContainerClient(ArgumentMatchers.anyString())).thenReturn((Object)this.mockedContainerClient);
        Mockito.when((Object)this.mockedContainerClient.getBlobClient(ArgumentMatchers.anyString())).thenReturn((Object)this.mockedBlobClient);
        Mockito.when((Object)this.mockedBlobClient.getBlockBlobClient()).thenReturn((Object)this.mockedBlockBlob);
        Mockito.when((Object)this.mockedBlobClient.getProperties()).thenReturn((Object)this.mockedProperties);
        Mockito.when((Object)this.mockedProperties.getBlobSize()).thenReturn((Object)1L);
        Mockito.when((Object)this.mockedProperties.getLastModified()).thenReturn((Object)OffsetDateTime.now());
        Mockito.when((Object)this.mockedContainerClient.listBlobs((ListBlobsOptions)ArgumentMatchers.any(ListBlobsOptions.class), (Duration)ArgumentMatchers.any(Duration.class))).thenReturn(this.mockedPagedIterable);
        Mockito.when((Object)this.mockedContainerClient.listBlobsByHierarchy((String)ArgumentMatchers.any(String.class))).thenReturn(this.mockedPagedIterable);
        Mockito.when((Object)this.mockedBlockBlob.getBlobOutputStream()).thenAnswer(i -> {
            blobCreated[0] = true;
            return this.mockedOutputStream;
        });
        Mockito.when((Object)this.mockedBlobItem.getName()).thenReturn((Object)"name");
        Mockito.when((Object)this.spyOptions.getSasToken()).thenReturn((Object)"sas-token");
        Mockito.when((Object)this.mockedBlobClient.openInputStream()).thenReturn((Object)this.mockedInputStream);
    }

    @Test
    public void testGetScheme() {
        Assert.assertEquals((Object)"azfs", (Object)azureBlobStoreFileSystem.getScheme());
    }

    @Test
    public void testCopy() throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList<AzfsResourceId> src = new ArrayList<AzfsResourceId>(Arrays.asList(AzfsResourceId.fromComponents((String)"account", (String)"container", (String)"from")));
        ArrayList<AzfsResourceId> dest = new ArrayList<AzfsResourceId>(Arrays.asList(AzfsResourceId.fromComponents((String)"account", (String)"container", (String)"to")));
        Mockito.when((Object)this.mockedBlobClient.exists()).thenReturn((Object)true);
        azureBlobStoreFileSystem.copy(src, dest);
        ((BlobClient)Mockito.verify((Object)this.mockedBlobClient, (VerificationMode)Mockito.times((int)1))).copyFromUrl((String)ArgumentMatchers.any(String.class));
    }

    @Test
    public void testWriteAndRead() throws @UnknownKeyFor @NonNull @Initialized IOException {
        azureBlobStoreFileSystem.getClient().createBlobContainer("testcontainer");
        byte[] writtenArray = new byte[]{0};
        ByteBuffer bb = ByteBuffer.allocate(writtenArray.length);
        bb.put(writtenArray);
        AzfsResourceId path = AzfsResourceId.fromUri((String)"azfs://account/testcontainer/foo/bar.txt");
        WritableByteChannel writableByteChannel = azureBlobStoreFileSystem.create(path, (CreateOptions)((CreateOptions.StandardCreateOptions.Builder)CreateOptions.StandardCreateOptions.builder().setMimeType("application/text")).build());
        writableByteChannel.write(bb);
        writableByteChannel.close();
        ByteBuffer bb2 = ByteBuffer.allocate(writtenArray.length);
        ReadableByteChannel open = azureBlobStoreFileSystem.open(path);
        open.read(bb2);
        byte[] readArray = bb2.array();
        Assert.assertArrayEquals((byte[])readArray, (byte[])writtenArray);
        open.close();
    }

    @Test
    @Ignore
    public void testGlobExpansion() throws @UnknownKeyFor @NonNull @Initialized IOException {
        String container = "test-container" + UUID.randomUUID();
        BlobContainerClient blobContainerClient = azureBlobStoreFileSystem.getClient().createBlobContainer(container);
        ArrayList<String> blobNames = new ArrayList<String>();
        blobNames.add("testdirectory/file1name");
        blobNames.add("testdirectory/file2name");
        blobNames.add("testdirectory/file3name");
        blobNames.add("testdirectory/otherfile");
        blobNames.add("testotherdirectory/file4name");
        for (String blob : blobNames) {
            blobContainerClient.getBlobClient(blob).uploadFromFile("src/test/resources/in.txt");
        }
        AzfsResourceId pattern = AzfsResourceId.fromUri((String)("azfs://account/" + container + "/testdirectory/file*"));
        ImmutableList expectedFiles = ImmutableList.of((Object)("azfs://account/" + container + "/testdirectory/file1name"), (Object)("azfs://account/" + container + "/testdirectory/file2name"), (Object)("azfs://account/" + container + "/testdirectory/file3name"));
        Assert.assertThat((Object)expectedFiles, (Matcher)Matchers.contains((Object[])this.toFilenames(azureBlobStoreFileSystem.expand(pattern)).toArray()));
        pattern = AzfsResourceId.fromUri((String)("azfs://account/" + container + "/testdirectory/file[1-3]*"));
        expectedFiles = ImmutableList.of((Object)("azfs://account/" + container + "/testdirectory/file1name"), (Object)("azfs://account/" + container + "/testdirectory/file2name"), (Object)("azfs://account/" + container + "/testdirectory/file3name"));
        Assert.assertThat((Object)expectedFiles, (Matcher)Matchers.contains((Object[])this.toFilenames(azureBlobStoreFileSystem.expand(pattern)).toArray()));
        pattern = AzfsResourceId.fromUri((String)("azfs://account/" + container + "/testdirectory/file?name"));
        expectedFiles = ImmutableList.of((Object)("azfs://account/" + container + "/testdirectory/file1name"), (Object)("azfs://account/" + container + "/testdirectory/file2name"), (Object)("azfs://account/" + container + "/testdirectory/file3name"));
        Assert.assertThat((Object)expectedFiles, (Matcher)Matchers.contains((Object[])this.toFilenames(azureBlobStoreFileSystem.expand(pattern)).toArray()));
        pattern = AzfsResourceId.fromUri((String)("azfs://account/" + container + "/test*ectory/fi*name"));
        expectedFiles = ImmutableList.of((Object)("azfs://account/" + container + "/testdirectory/file1name"), (Object)("azfs://account/" + container + "/testdirectory/file2name"), (Object)("azfs://account/" + container + "/testdirectory/file3name"), (Object)("azfs://account/" + container + "/testotherdirectory/file4name"));
        Assert.assertThat((Object)expectedFiles, (Matcher)Matchers.contains((Object[])this.toFilenames(azureBlobStoreFileSystem.expand(pattern)).toArray()));
        blobContainerClient.delete();
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> toFilenames(@UnknownKeyFor @NonNull @Initialized MatchResult matchResult) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return FluentIterable.from((Iterable)matchResult.metadata()).transform(metadata -> metadata.resourceId().toString()).toList();
    }

    @Test
    @Ignore
    public void testMatch() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String container = "test-container" + UUID.randomUUID();
        BlobContainerClient blobContainerClient = azureBlobStoreFileSystem.getClient().createBlobContainer(container);
        ArrayList<String> blobNames = new ArrayList<String>();
        blobNames.add("testdirectory/file1name");
        blobNames.add("testdirectory/file2name");
        blobNames.add("testdirectory/file3name");
        blobNames.add("testdirectory/file4name");
        blobNames.add("testdirectory/otherfile");
        blobNames.add("testotherdirectory/anotherfile");
        for (String blob : blobNames) {
            blobContainerClient.getBlobClient(blob).uploadFromFile("src/test/resources/in.txt");
        }
        ImmutableList specs = ImmutableList.of((Object)("azfs://account/" + container + "/testdirectory/file[1-3]*"), (Object)("azfs://account/" + container + "/testdirectory/non-exist-file"), (Object)("azfs://account/" + container + "/testdirectory/otherfile"));
        List matchResults = azureBlobStoreFileSystem.match((List)specs);
        Assert.assertEquals((long)3L, (long)matchResults.size());
        Assert.assertEquals((Object)MatchResult.Status.OK, (Object)((MatchResult)matchResults.get(0)).status());
        Assert.assertThat((Object)ImmutableList.of((Object)("azfs://account/" + container + "/testdirectory/file1name"), (Object)("azfs://account/" + container + "/testdirectory/file2name"), (Object)("azfs://account/" + container + "/testdirectory/file3name")), (Matcher)Matchers.contains((Object[])this.toFilenames((MatchResult)matchResults.get(0)).toArray()));
        Assert.assertEquals((Object)MatchResult.Status.NOT_FOUND, (Object)((MatchResult)matchResults.get(1)).status());
        Assert.assertEquals((Object)MatchResult.Status.OK, (Object)((MatchResult)matchResults.get(2)).status());
        Assert.assertThat((Object)ImmutableList.of((Object)("azfs://account/" + container + "/testdirectory/otherfile")), (Matcher)Matchers.contains((Object[])this.toFilenames((MatchResult)matchResults.get(2)).toArray()));
        blobContainerClient.delete();
    }

    @Test
    public void testMatchNonGlobs() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String container = "test-container" + UUID.randomUUID();
        BlobContainerClient blobContainerClient = azureBlobStoreFileSystem.getClient().createBlobContainer(container);
        ArrayList<String> blobNames = new ArrayList<String>();
        blobNames.add("testdirectory/file1name");
        blobNames.add("testdirectory/dir2name/");
        blobNames.add("testdirectory/file4name");
        for (String blob : blobNames) {
            blobContainerClient.getBlobClient(blob).uploadFromFile("src/test/resources/in.txt");
        }
        ImmutableList specs = ImmutableList.of((Object)("azfs://account/" + container + "/testdirectory/file1name"), (Object)("azfs://account/" + container + "/testdirectory/dir2name/"), (Object)("azfs://account/" + container + "/testdirectory/file4name"));
        List matchResults = azureBlobStoreFileSystem.match((List)specs);
        Assert.assertEquals((long)3L, (long)matchResults.size());
        Assert.assertThat((Object)ImmutableList.of((Object)("azfs://account/" + container + "/testdirectory/file1name")), (Matcher)Matchers.contains((Object[])this.toFilenames((MatchResult)matchResults.get(0)).toArray()));
        Assert.assertThat((Object)ImmutableList.of((Object)("azfs://account/" + container + "/testdirectory/dir2name/")), (Matcher)Matchers.contains((Object[])this.toFilenames((MatchResult)matchResults.get(1)).toArray()));
        Assert.assertThat((Object)ImmutableList.of((Object)("azfs://account/" + container + "/testdirectory/file4name")), (Matcher)Matchers.contains((Object[])this.toFilenames((MatchResult)matchResults.get(2)).toArray()));
        blobContainerClient.delete();
    }
}

