/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.azure.cosmos;

import com.azure.core.credential.TokenCredential;
import com.azure.cosmos.CosmosClientBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.beam.sdk.io.azure.options.AzureOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface CosmosOptions
extends AzureOptions {
    @JsonIgnore
    @Description(value="The Azure Cosmos client builder. If no client has been set explicitly, the default is to use the instance factory.")
    @Default.InstanceFactory(value=CosmosClientBuilderFactory.class)
    public @UnknownKeyFor @NonNull @Initialized CosmosClientBuilder getCosmosClientBuilder();

    public void setCosmosClientBuilder(@UnknownKeyFor @NonNull @Initialized CosmosClientBuilder var1);

    @Description(value="Sets the cosmos service endpoint")
    public @Nullable @UnknownKeyFor @Initialized String getCosmosServiceEndpoint();

    public void setCosmosServiceEndpoint(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Sets the cosmos service endpoint")
    public @Nullable @UnknownKeyFor @Initialized String getCosmosKey();

    public void setCosmosKey(@UnknownKeyFor @NonNull @Initialized String var1);

    public static class CosmosClientBuilderFactory
    implements DefaultValueFactory<CosmosClientBuilder> {
        public @UnknownKeyFor @NonNull @Initialized CosmosClientBuilder create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            String key;
            String endpoint;
            CosmosOptions cosmosOptions = (CosmosOptions)options.as(CosmosOptions.class);
            CosmosClientBuilder builder = new CosmosClientBuilder();
            TokenCredential credential = cosmosOptions.getAzureCredentialsProvider();
            if (credential != null) {
                builder = builder.credential(credential);
            }
            if ((endpoint = cosmosOptions.getCosmosServiceEndpoint()) != null && !endpoint.isEmpty()) {
                builder = builder.endpoint(endpoint);
            }
            if ((key = cosmosOptions.getCosmosKey()) != null && !key.isEmpty()) {
                builder = builder.key(key);
            }
            return builder;
        }
    }
}

