/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.azure.cosmos;

import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.routing.PartitionKeyInternalHelper;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.models.FeedRange;
import java.io.Serializable;
import java.math.BigInteger;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class NormalizedRange
implements Serializable {
    public static final @UnknownKeyFor @NonNull @Initialized NormalizedRange FULL_RANGE = new NormalizedRange(PartitionKeyInternalHelper.MinimumInclusiveEffectivePartitionKey, PartitionKeyInternalHelper.MaximumExclusiveEffectivePartitionKey);
    private final @UnknownKeyFor @NonNull @Initialized String minInclusive;
    private final @UnknownKeyFor @NonNull @Initialized String maxExclusive;

    public static @UnknownKeyFor @NonNull @Initialized NormalizedRange fromFeedRange(@UnknownKeyFor @NonNull @Initialized FeedRange feedRange) {
        if (feedRange instanceof FeedRangeEpkImpl) {
            FeedRangeEpkImpl ekp = (FeedRangeEpkImpl)feedRange;
            Range range = ekp.getRange();
            String min = (String)((Object)range.getMin());
            String max = (String)((Object)range.getMax());
            if (!range.isMinInclusive()) {
                min = new BigInteger(min, 16).add(BigInteger.ONE).toString(16);
            }
            if (range.isMaxInclusive()) {
                max = new BigInteger(max, 16).subtract(BigInteger.ONE).toString(16);
            }
            return new NormalizedRange(min, max);
        }
        throw new IllegalArgumentException("Only FeedRangeEpkImpl are supported. got: " + feedRange);
    }

    public NormalizedRange(@UnknownKeyFor @NonNull @Initialized String minInclusive, @UnknownKeyFor @NonNull @Initialized String maxExclusive) {
        this.minInclusive = minInclusive;
        this.maxExclusive = maxExclusive;
    }

    public @UnknownKeyFor @NonNull @Initialized FeedRange toFeedRange() {
        return new FeedRangeEpkImpl(new Range((Comparable)((Object)this.minInclusive), (Comparable)((Object)this.maxExclusive), true, false));
    }
}

