/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.azure.cosmos;

import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosClientBuilder;
import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.CosmosDatabase;
import com.azure.cosmos.examples.common.Families;
import com.azure.cosmos.examples.common.Family;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.PartitionKey;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.azure.cosmos.CosmosIO;
import org.apache.beam.sdk.io.azure.cosmos.CosmosOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.testcontainers.containers.CosmosDBEmulatorContainer;
import org.testcontainers.utility.DockerImageName;

public class CosmosIOTest {
    private static final String DOCKER_IMAGE_NAME = "mcr.microsoft.com/cosmosdb/linux/azure-cosmos-emulator:latest";
    private static final String DATABASE = "AzureSampleFamilyDB";
    private static final String CONTAINER = "FamilyContainer";
    private static final String PARTITION_KEY_PATH = "/lastName";
    private static PipelineOptions pipelineOptions = PipelineOptionsFactory.create();
    private static CosmosDBEmulatorContainer container;
    private static CosmosClient client;
    @Rule
    public TestPipeline pipeline = TestPipeline.fromOptions((PipelineOptions)pipelineOptions);

    @BeforeClass
    public static void beforeClass() throws Exception {
        container = new CosmosDBEmulatorContainer(DockerImageName.parse((String)DOCKER_IMAGE_NAME));
        container.withImagePullPolicy(imageName -> true);
        container.start();
        TemporaryFolder tempFolder = new TemporaryFolder();
        tempFolder.create();
        Path keyStoreFile = tempFolder.newFile("azure-cosmos-emulator.keystore").toPath();
        KeyStore keyStore = container.buildNewKeyStore();
        keyStore.store(Files.newOutputStream(keyStoreFile, new OpenOption[0]), container.getEmulatorKey().toCharArray());
        System.setProperty("javax.net.ssl.trustStore", keyStoreFile.toString());
        System.setProperty("javax.net.ssl.trustStorePassword", container.getEmulatorKey());
        System.setProperty("javax.net.ssl.trustStoreType", "PKCS12");
        CosmosOptions cosmosOptions = (CosmosOptions)pipelineOptions.as(CosmosOptions.class);
        cosmosOptions.setCosmosServiceEndpoint(container.getEmulatorEndpoint());
        cosmosOptions.setCosmosKey(container.getEmulatorKey());
        client = new CosmosClientBuilder().gatewayMode().endpointDiscoveryEnabled(false).endpoint(container.getEmulatorEndpoint()).key(container.getEmulatorKey()).buildClient();
        client.createDatabase(DATABASE);
        CosmosDatabase db = client.getDatabase(DATABASE);
        db.createContainer(CONTAINER, PARTITION_KEY_PATH);
        CosmosContainer container = db.getContainer(CONTAINER);
        ArrayList<Family> families = new ArrayList<Family>();
        families.add(Families.getAndersenFamilyItem());
        families.add(Families.getJohnsonFamilyItem());
        families.add(Families.getSmithFamilyItem());
        families.add(Families.getWakefieldFamilyItem());
        CosmosItemRequestOptions cosmosItemRequestOptions = new CosmosItemRequestOptions();
        for (Family f : families) {
            container.createItem((Object)f, new PartitionKey((Object)f.getLastName()), cosmosItemRequestOptions);
        }
    }

    @AfterClass
    public static void afterClass() {
        container.stop();
        if (client != null) {
            client.close();
        }
    }

    @Test
    public void testEstimatedSizeBytes() throws Exception {
        CosmosIO.Read read = CosmosIO.read(Family.class).withContainer(CONTAINER).withDatabase(DATABASE).withCoder((Coder)SerializableCoder.of(Family.class));
        CosmosIO.BoundedCosmosBDSource initialSource = new CosmosIO.BoundedCosmosBDSource(read);
        long estimatedSize = initialSource.getEstimatedSizeBytes(pipelineOptions);
        Assert.assertEquals((String)"Wrong estimated size", (long)3072L, (long)estimatedSize);
    }

    @Test
    public void testSplit() throws Exception {
        CosmosIO.Read read = CosmosIO.read(Family.class).withContainer(CONTAINER).withDatabase(DATABASE).withCoder((Coder)SerializableCoder.of(Family.class));
        CosmosIO.BoundedCosmosBDSource initialSource = new CosmosIO.BoundedCosmosBDSource(read);
        List splits = initialSource.split(1024L, pipelineOptions);
        Assert.assertEquals((String)"Wrong split", (long)3L, (long)splits.size());
    }

    @Test
    public void testRead() {
        PCollection output = (PCollection)this.pipeline.apply((PTransform)CosmosIO.read(Family.class).withContainer(CONTAINER).withDatabase(DATABASE).withCoder((Coder)SerializableCoder.of(Family.class)));
        PAssert.thatSingleton((PCollection)((PCollection)output.apply("Count", Count.globally()))).isEqualTo((Object)4L);
        this.pipeline.run();
    }

    @Test
    public void testReadWithQuery() {
        PCollection output = (PCollection)this.pipeline.apply((PTransform)CosmosIO.read(Family.class).withContainer(CONTAINER).withDatabase(DATABASE).withCoder((Coder)SerializableCoder.of(Family.class)).withQuery("SELECT * FROM Family WHERE Family.lastName IN ('Andersen', 'Wakefield', 'Johnson')"));
        PAssert.thatSingleton((PCollection)((PCollection)output.apply("Count", Count.globally()))).isEqualTo((Object)3L);
        this.pipeline.run();
    }
}

