
package org.apache.beam.sdk.io.amqp;

import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.joda.time.Duration;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_AmqpIO_Read extends AmqpIO.Read {

  private final List<String> addresses;
  private final long maxNumRecords;
  private final Duration maxReadTime;

  private AutoValue_AmqpIO_Read(
      @Nullable List<String> addresses,
      long maxNumRecords,
      @Nullable Duration maxReadTime) {
    this.addresses = addresses;
    this.maxNumRecords = maxNumRecords;
    this.maxReadTime = maxReadTime;
  }

  @Nullable
  @Override
  List<String> addresses() {
    return addresses;
  }

  @Override
  long maxNumRecords() {
    return maxNumRecords;
  }

  @Nullable
  @Override
  Duration maxReadTime() {
    return maxReadTime;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AmqpIO.Read) {
      AmqpIO.Read that = (AmqpIO.Read) o;
      return ((this.addresses == null) ? (that.addresses() == null) : this.addresses.equals(that.addresses()))
           && (this.maxNumRecords == that.maxNumRecords())
           && ((this.maxReadTime == null) ? (that.maxReadTime() == null) : this.maxReadTime.equals(that.maxReadTime()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (addresses == null) ? 0 : this.addresses.hashCode();
    h *= 1000003;
    h ^= (int) ((this.maxNumRecords >>> 32) ^ this.maxNumRecords);
    h *= 1000003;
    h ^= (maxReadTime == null) ? 0 : this.maxReadTime.hashCode();
    return h;
  }

  @Override
  AmqpIO.Read.Builder builder() {
    return new Builder(this);
  }

  static final class Builder extends AmqpIO.Read.Builder {
    private List<String> addresses;
    private Long maxNumRecords;
    private Duration maxReadTime;
    Builder() {
    }
    private Builder(AmqpIO.Read source) {
      this.addresses = source.addresses();
      this.maxNumRecords = source.maxNumRecords();
      this.maxReadTime = source.maxReadTime();
    }
    @Override
    AmqpIO.Read.Builder setAddresses(@Nullable List<String> addresses) {
      this.addresses = addresses;
      return this;
    }
    @Override
    AmqpIO.Read.Builder setMaxNumRecords(long maxNumRecords) {
      this.maxNumRecords = maxNumRecords;
      return this;
    }
    @Override
    AmqpIO.Read.Builder setMaxReadTime(@Nullable Duration maxReadTime) {
      this.maxReadTime = maxReadTime;
      return this;
    }
    @Override
    AmqpIO.Read build() {
      String missing = "";
      if (this.maxNumRecords == null) {
        missing += " maxNumRecords";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AmqpIO_Read(
          this.addresses,
          this.maxNumRecords,
          this.maxReadTime);
    }
  }

}
