/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.amqp;

import java.util.Collections;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.io.amqp.AmqpMessageCoder;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdks.java.io.amqp.repackaged.com.google.common.base.Joiner;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AmqpMessageCoderTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void encodeDecode() throws Exception {
        Message message = Message.Factory.create();
        message.setBody((Section)new AmqpValue((Object)"body"));
        message.setAddress("address");
        message.setSubject("test");
        AmqpMessageCoder coder = AmqpMessageCoder.of();
        Message clone = (Message)CoderUtils.clone((Coder)coder, (Object)message);
        Assert.assertEquals((Object)"AmqpValue{body}", (Object)clone.getBody().toString());
        Assert.assertEquals((Object)"address", (Object)clone.getAddress());
        Assert.assertEquals((Object)"test", (Object)clone.getSubject());
    }

    @Test
    public void encodeDecodeTooMuchLargerMessage() throws Exception {
        this.thrown.expect(CoderException.class);
        Message message = Message.Factory.create();
        message.setAddress("address");
        message.setSubject("subject");
        String body = Joiner.on((String)"").join(Collections.nCopies(0x4000000, " "));
        message.setBody((Section)new AmqpValue((Object)body));
        AmqpMessageCoder coder = AmqpMessageCoder.of();
        byte[] encoded = CoderUtils.encodeToByteArray((Coder)coder, (Object)message);
    }

    @Test
    public void encodeDecodeLargeMessage() throws Exception {
        Message message = Message.Factory.create();
        message.setAddress("address");
        message.setSubject("subject");
        String body = Joiner.on((String)"").join(Collections.nCopies(0x2000000, " "));
        message.setBody((Section)new AmqpValue((Object)body));
        AmqpMessageCoder coder = AmqpMessageCoder.of();
        Message clone = (Message)CoderUtils.clone((Coder)coder, (Object)message);
        clone.getBody().toString().equals(message.getBody().toString());
    }
}

