/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sqs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws2.options.AwsOptions;
import org.apache.beam.sdk.io.aws2.sqs.SqsCheckpointMark;
import org.apache.beam.sdk.io.aws2.sqs.SqsMessage;
import org.apache.beam.sdk.io.aws2.sqs.SqsUnboundedReader;
import org.apache.beam.sdk.options.PipelineOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class SqsUnboundedSource
extends UnboundedSource<SqsMessage, SqsCheckpointMark> {
    private final  @UnknownKeyFor @NonNull @Initialized SqsIO.Read read;

    public SqsUnboundedSource( @UnknownKeyFor @NonNull @Initialized SqsIO.Read read) {
        this.read = read;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SqsUnboundedSource> split(@UnknownKeyFor @NonNull @Initialized int desiredNumSplits, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        ArrayList<SqsUnboundedSource> sources = new ArrayList<SqsUnboundedSource>();
        for (int i = 0; i < Math.max(1, desiredNumSplits); ++i) {
            sources.add(new SqsUnboundedSource(this.read));
        }
        return sources;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader<@UnknownKeyFor @NonNull @Initialized SqsMessage> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @Nullable @UnknownKeyFor @Initialized SqsCheckpointMark checkpointMark) {
        try {
            return new SqsUnboundedReader(this, checkpointMark, (AwsOptions)options.as(AwsOptions.class));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to subscribe to " + this.read.queueUrl() + ": ", e);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized SqsCheckpointMark> getCheckpointMarkCoder() {
        return SerializableCoder.of(SqsCheckpointMark.class);
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized SqsMessage> getOutputCoder() {
        return SerializableCoder.of(SqsMessage.class);
    }

    public  @UnknownKeyFor @NonNull @Initialized SqsIO.Read getRead() {
        return this.read;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean requiresDeduping() {
        return true;
    }
}

