/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.schemas;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.aws2.schemas.AwsBuilderFactory;
import org.apache.beam.sdk.io.aws2.schemas.AwsSchemaUtils;
import org.apache.beam.sdk.io.aws2.schemas.AwsTypes;
import org.apache.beam.sdk.schemas.CachingFactory;
import org.apache.beam.sdk.schemas.Factory;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.GetterBasedSchemaProviderV2;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.RowWithGetters;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.utils.builder.SdkBuilder;

public class AwsSchemaProvider
extends GetterBasedSchemaProviderV2 {
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Class, @UnknownKeyFor @NonNull @Initialized AwsBuilderFactory> FACTORIES = Maps.newConcurrentMap();

    public <T> @Nullable @UnknownKeyFor @Initialized Schema schemaFor(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> type) {
        if (!SdkPojo.class.isAssignableFrom(type.getRawType())) {
            return null;
        }
        return AwsTypes.schemaFor(AwsSchemaProvider.sdkFields(type.getRawType()));
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter> fieldValueGetters(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetTypeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        AwsTypes.ConverterFactory fromAws = AwsTypes.ConverterFactory.fromAws();
        Map<String, SdkField<?>> sdkFields = AwsSchemaProvider.sdkFieldsByName(targetTypeDescriptor.getRawType());
        ArrayList<FieldValueGetter> getters = new ArrayList<FieldValueGetter>(schema.getFieldCount());
        for (String field : schema.getFieldNames()) {
            SdkField sdkField = (SdkField)Preconditions.checkStateNotNull(sdkFields.get(field), (Object)"Unknown field");
            getters.add(AwsSchemaUtils.getter(field, fromAws.create(arg_0 -> ((SdkField)sdkField).getValueOrDefault(arg_0), sdkField)));
        }
        return getters;
    }

    public <T> @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> fromRowFunction(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> type) {
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((boolean)SdkPojo.class.isAssignableFrom(type.getRawType()), (String)"Unsupported type %s", type);
        return FromRowFactory.create(type);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> fieldValueTypeInformations(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetTypeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        throw new UnsupportedOperationException("FieldValueTypeInformation not available");
    }

    public @UnknownKeyFor @NonNull @Initialized SchemaUserTypeCreator schemaTypeCreator(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetTypeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        throw new UnsupportedOperationException("SchemaUserTypeCreator not available");
    }

    private static <T extends SdkPojo> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AwsBuilderFactory<T, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> builderFactory(@UnknownKeyFor @NonNull @Initialized Class<T> cls) {
        return FACTORIES.computeIfAbsent(cls, c -> AwsSchemaUtils.builderFactory(cls));
    }

    private static <T extends SdkPojo> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SdkField<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sdkFields(@UnknownKeyFor @NonNull @Initialized Class<T> cls) {
        return AwsSchemaProvider.builderFactory(cls).sdkFields();
    }

    private static <T extends SdkPojo> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SdkBuilder<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, T> sdkBuilder(@UnknownKeyFor @NonNull @Initialized Class<T> cls) {
        return AwsSchemaProvider.builderFactory(cls).get();
    }

    private static <T extends SdkPojo> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized SdkField<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sdkFieldsByName(@UnknownKeyFor @NonNull @Initialized Class<T> cls) {
        return AwsSchemaProvider.sdkFields(cls).stream().collect(Collectors.toMap(AwsTypes::normalizedNameOf, Function.identity()));
    }

    private static class FromRowFactory
    implements Factory<SerializableFunction<Row, ?>> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> cachingFactory = new CachingFactory((Factory)this);
        private final @UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AwsSchemaUtils.SdkBuilderSetter>> settersFactory = new CachingFactory((Factory)new SettersFactory());

        private FromRowFactory() {
        }

        static <T> @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> create(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @Nullable @Initialized ? super T> typeDescriptor) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((boolean)SdkPojo.class.isAssignableFrom(typeDescriptor.getRawType()), (String)"Unsupported clazz %s", typeDescriptor);
            return (SerializableFunction)new FromRowFactory().cachingFactory.create(typeDescriptor, null);
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> create(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema ignored) {
            return new FromRowWithBuilder(typeDescriptor.getRawType(), this.settersFactory);
        }

        private void checkForUnknownFields(@UnknownKeyFor @NonNull @Initialized Schema schema, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized SdkField<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fields) {
            Sets.SetView unknowns = Sets.difference((Set)Sets.newHashSet((Iterable)schema.getFieldNames()), fields.keySet());
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((boolean)unknowns.isEmpty(), (String)"Row schema contains unknown fields: %s", (Object)unknowns);
        }

        private class SettersFactory
        implements Factory<List<AwsSchemaUtils.SdkBuilderSetter>> {
            private final @UnknownKeyFor @NonNull @Initialized AwsTypes.ConverterFactory toAws;

            private SettersFactory() {
                this.toAws = AwsTypes.ConverterFactory.toAws(FromRowFactory.this.cachingFactory);
            }

            public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AwsSchemaUtils.SdkBuilderSetter> create(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
                Map fields = AwsSchemaProvider.sdkFieldsByName(typeDescriptor.getRawType());
                FromRowFactory.this.checkForUnknownFields(schema, fields);
                ArrayList<AwsSchemaUtils.SdkBuilderSetter> setters = new ArrayList<AwsSchemaUtils.SdkBuilderSetter>(schema.getFieldCount());
                for (Map.Entry entry : fields.entrySet()) {
                    SdkField sdkField = (SdkField)entry.getValue();
                    BiConsumer<SdkBuilder<?, ?>, Object> setter = this.toAws.needsConversion(sdkField) ? AwsTypes.ConverterFactory.createSetter((arg_0, arg_1) -> ((SdkField)sdkField).set(arg_0, arg_1), this.toAws.create(sdkField)) : (arg_0, arg_1) -> ((SdkField)sdkField).set(arg_0, arg_1);
                    setters.add(AwsSchemaUtils.setter((String)entry.getKey(), setter));
                }
                return setters;
            }
        }
    }

    private static class FromRowWithBuilder<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized SdkPojo>
    implements SerializableFunction<Row, T> {
        private final @UnknownKeyFor @NonNull @Initialized Class<T> cls;
        private final @UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AwsSchemaUtils.SdkBuilderSetter>> factory;

        FromRowWithBuilder(@UnknownKeyFor @NonNull @Initialized Class<T> cls, @UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AwsSchemaUtils.SdkBuilderSetter>> factory) {
            this.cls = cls;
            this.factory = factory;
        }

        public T apply(@UnknownKeyFor @NonNull @Initialized Row row) {
            Object target;
            if (row instanceof RowWithGetters && (target = ((RowWithGetters)row).getGetterTarget()).getClass().equals(this.cls)) {
                return (T)((SdkPojo)target);
            }
            SdkBuilder builder = AwsSchemaProvider.sdkBuilder(this.cls);
            List setters = (List)this.factory.create(TypeDescriptor.of(this.cls), row.getSchema());
            for (AwsSchemaUtils.SdkBuilderSetter set : setters) {
                if (!row.getSchema().hasField(set.name())) continue;
                set.set(builder, row.getValue(set.name()));
            }
            return (T)((SdkPojo)builder.build());
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FromRowWithBuilder that = (FromRowWithBuilder)o;
            return this.cls.equals(that.cls);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.cls);
        }
    }
}

