/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.s3;

import com.google.auto.value.AutoValue;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.beam.sdk.io.FileSystem;
import org.apache.beam.sdk.io.FileSystemUtils;
import org.apache.beam.sdk.io.aws2.options.S3Options;
import org.apache.beam.sdk.io.aws2.s3.AutoValue_S3FileSystem_ExpandedGlob;
import org.apache.beam.sdk.io.aws2.s3.AutoValue_S3FileSystem_PathWithEncoding;
import org.apache.beam.sdk.io.aws2.s3.S3FileSystemConfiguration;
import org.apache.beam.sdk.io.aws2.s3.S3ReadableSeekableByteChannel;
import org.apache.beam.sdk.io.aws2.s3.S3ResourceId;
import org.apache.beam.sdk.io.aws2.s3.S3WritableByteChannel;
import org.apache.beam.sdk.io.fs.CreateOptions;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.metrics.Lineage;
import org.apache.beam.sdk.util.MoreFutures;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Suppliers;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Multimap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.MoreExecutors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CopyObjectResponse;
import software.amazon.awssdk.services.s3.model.CopyPartResult;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.UploadPartCopyRequest;

class S3FileSystem
extends FileSystem<S3ResourceId> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(S3FileSystem.class);
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized long MAX_COPY_OBJECT_SIZE_BYTES = 0x140000000L;
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_DELETE_OBJECTS_PER_REQUEST = 1000;
    private static final @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String> NON_READ_SEEK_EFFICIENT_ENCODINGS = ImmutableSet.of((Object)"gzip");
    private @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized S3Client> s3Client;
    private final @UnknownKeyFor @NonNull @Initialized S3FileSystemConfiguration config;
    private final @UnknownKeyFor @NonNull @Initialized ListeningExecutorService executorService;

    S3FileSystem(@UnknownKeyFor @NonNull @Initialized S3Options options) {
        this(S3FileSystemConfiguration.fromS3Options(options));
    }

    S3FileSystem(@UnknownKeyFor @NonNull @Initialized S3FileSystemConfiguration config) {
        this.config = (S3FileSystemConfiguration)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.s3Client = Suppliers.memoize(() -> ((S3ClientBuilder)config.getS3ClientBuilder()).build());
        Preconditions.checkNotNull((Object)config.getS3StorageClass(), (Object)"storageClass");
        Preconditions.checkArgument((config.getS3ThreadPoolSize() > 0 ? 1 : 0) != 0, (Object)"threadPoolSize");
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(config.getS3ThreadPoolSize(), new ThreadFactoryBuilder().setDaemon(true).build()));
    }

    protected @UnknownKeyFor @NonNull @Initialized String getScheme() {
        return this.config.getScheme();
    }

    @VisibleForTesting
    void setS3Client(@UnknownKeyFor @NonNull @Initialized S3Client s3) {
        this.s3Client = Suppliers.ofInstance((Object)s3);
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized S3Client getS3Client() {
        return (S3Client)this.s3Client.get();
    }

    protected @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MatchResult> match(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> specs) throws @UnknownKeyFor @NonNull @Initialized IOException {
        List<S3ResourceId> paths = specs.stream().map(S3ResourceId::fromUri).collect(Collectors.toList());
        ArrayList<S3ResourceId> globs = new ArrayList<S3ResourceId>();
        ArrayList<S3ResourceId> nonGlobs = new ArrayList<S3ResourceId>();
        ArrayList isGlobBooleans = new ArrayList();
        paths.forEach(path -> {
            if (path.isWildcard()) {
                globs.add((S3ResourceId)path);
                isGlobBooleans.add(true);
            } else {
                nonGlobs.add((S3ResourceId)path);
                isGlobBooleans.add(false);
            }
        });
        Iterator<MatchResult> globMatches = this.matchGlobPaths(globs).iterator();
        Iterator<MatchResult> nonGlobMatches = this.matchNonGlobPaths(nonGlobs).iterator();
        ImmutableList.Builder matchResults = ImmutableList.builder();
        isGlobBooleans.forEach(isGlob -> {
            if (isGlob.booleanValue()) {
                Preconditions.checkState((boolean)globMatches.hasNext(), (Object)"Internal error encountered in S3Filesystem: expected more elements in globMatches.");
                matchResults.add((Object)((MatchResult)globMatches.next()));
            } else {
                Preconditions.checkState((boolean)nonGlobMatches.hasNext(), (Object)"Internal error encountered in S3Filesystem: expected more elements in nonGlobMatches.");
                matchResults.add((Object)((MatchResult)nonGlobMatches.next()));
            }
        });
        Preconditions.checkState((!globMatches.hasNext() ? 1 : 0) != 0, (Object)"Internal error encountered in S3Filesystem: expected no more elements in globMatches.");
        Preconditions.checkState((!nonGlobMatches.hasNext() ? 1 : 0) != 0, (Object)"Internal error encountered in S3Filesystem: expected no more elements in nonGlobMatches.");
        return matchResults.build();
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MatchResult> matchGlobPaths(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized S3ResourceId> globPaths) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Stream expandTasks = globPaths.stream().map(path -> () -> this.expandGlob((S3ResourceId)path));
        Map<S3ResourceId, ExpandedGlob> expandedGlobByGlobPath = this.callTasks(expandTasks).stream().collect(Collectors.toMap(ExpandedGlob::getGlobPath, expandedGlob -> expandedGlob));
        Stream contentTypeTasks = expandedGlobByGlobPath.values().stream().map(ExpandedGlob::getExpandedPaths).filter(Objects::nonNull).flatMap(Collection::stream).map(path -> () -> this.getPathContentEncoding((S3ResourceId)path));
        Map<S3ResourceId, PathWithEncoding> exceptionByPath = this.callTasks(contentTypeTasks).stream().collect(Collectors.toMap(PathWithEncoding::getPath, pathWithEncoding -> pathWithEncoding));
        ArrayList results = new ArrayList(globPaths.size());
        globPaths.forEach(globPath -> {
            ExpandedGlob expandedGlob = (ExpandedGlob)expandedGlobByGlobPath.get(globPath);
            if (expandedGlob.getException() != null) {
                results.add(MatchResult.create((MatchResult.Status)MatchResult.Status.ERROR, (IOException)expandedGlob.getException()));
            } else {
                ArrayList<MatchResult.Metadata> metadatas = new ArrayList<MatchResult.Metadata>();
                IOException exception = null;
                for (S3ResourceId expandedPath : expandedGlob.getExpandedPaths()) {
                    PathWithEncoding pathWithEncoding = (PathWithEncoding)exceptionByPath.get(expandedPath);
                    if (pathWithEncoding.getException() != null) {
                        exception = pathWithEncoding.getException();
                        break;
                    }
                    metadatas.add(S3FileSystem.createBeamMetadata(pathWithEncoding.getPath(), pathWithEncoding.getContentEncoding(), null));
                }
                if (exception != null) {
                    if (exception instanceof FileNotFoundException) {
                        results.add(MatchResult.create((MatchResult.Status)MatchResult.Status.NOT_FOUND, exception));
                    } else {
                        results.add(MatchResult.create((MatchResult.Status)MatchResult.Status.ERROR, exception));
                    }
                } else {
                    results.add(MatchResult.create((MatchResult.Status)MatchResult.Status.OK, metadatas));
                }
            }
        });
        return ImmutableList.copyOf(results);
    }

    private @UnknownKeyFor @NonNull @Initialized ExpandedGlob expandGlob(@UnknownKeyFor @NonNull @Initialized S3ResourceId glob) {
        Preconditions.checkArgument((boolean)glob.isWildcard(), (Object)"isWildcard");
        String keyPrefix = glob.getKeyNonWildcardPrefix();
        Pattern wildcardRegexp = Pattern.compile(FileSystemUtils.wildcardToRegexp((String)glob.getKey()));
        LOG.debug("expanding bucket {}, prefix {}, against pattern {}", new Object[]{glob.getBucket(), keyPrefix, wildcardRegexp});
        ImmutableList.Builder expandedPaths = ImmutableList.builder();
        String continuationToken = null;
        do {
            ListObjectsV2Response response;
            ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(glob.getBucket()).prefix(keyPrefix).continuationToken(continuationToken).build();
            try {
                response = ((S3Client)this.s3Client.get()).listObjectsV2(request);
            }
            catch (SdkServiceException e) {
                return ExpandedGlob.create(glob, new IOException(e));
            }
            continuationToken = response.nextContinuationToken();
            List contents = response.contents();
            contents.stream().filter(s3Object -> wildcardRegexp.matcher(s3Object.key()).matches()).forEach(s3Object -> {
                S3ResourceId expandedPath = S3ResourceId.fromComponents(glob.getScheme(), glob.getBucket(), s3Object.key()).withSize(s3Object.size()).withLastModified(Date.from(s3Object.lastModified()));
                LOG.debug("Expanded S3 object path {}", (Object)expandedPath);
                expandedPaths.add((Object)expandedPath);
            });
        } while (continuationToken != null);
        return ExpandedGlob.create(glob, (List<S3ResourceId>)expandedPaths.build());
    }

    private @UnknownKeyFor @NonNull @Initialized PathWithEncoding getPathContentEncoding(@UnknownKeyFor @NonNull @Initialized S3ResourceId path) {
        HeadObjectResponse s3ObjectHead;
        try {
            s3ObjectHead = this.getObjectHead(path);
        }
        catch (SdkServiceException e) {
            if (e instanceof S3Exception && e.statusCode() == 404) {
                return PathWithEncoding.create(path, new FileNotFoundException());
            }
            return PathWithEncoding.create(path, new IOException(e));
        }
        return PathWithEncoding.create(path, Strings.nullToEmpty((String)s3ObjectHead.contentEncoding()));
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MatchResult> matchNonGlobPaths(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized S3ResourceId> paths) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.callTasks(paths.stream().map(path -> () -> this.matchNonGlobPath((S3ResourceId)path)));
    }

    private @UnknownKeyFor @NonNull @Initialized HeadObjectResponse getObjectHead(@UnknownKeyFor @NonNull @Initialized S3ResourceId s3ResourceId) throws @UnknownKeyFor @NonNull @Initialized SdkServiceException {
        HeadObjectRequest request = (HeadObjectRequest)HeadObjectRequest.builder().bucket(s3ResourceId.getBucket()).key(s3ResourceId.getKey()).sseCustomerKey(this.config.getSSECustomerKey().getKey()).sseCustomerAlgorithm(this.config.getSSECustomerKey().getAlgorithm()).build();
        return ((S3Client)this.s3Client.get()).headObject(request);
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized MatchResult matchNonGlobPath(@UnknownKeyFor @NonNull @Initialized S3ResourceId path) {
        HeadObjectResponse s3ObjectHead;
        try {
            s3ObjectHead = this.getObjectHead(path);
        }
        catch (SdkServiceException e) {
            if (e instanceof S3Exception && e.statusCode() == 404) {
                return MatchResult.create((MatchResult.Status)MatchResult.Status.NOT_FOUND, (IOException)new FileNotFoundException());
            }
            return MatchResult.create((MatchResult.Status)MatchResult.Status.ERROR, (IOException)new IOException(e));
        }
        return MatchResult.create((MatchResult.Status)MatchResult.Status.OK, (List)ImmutableList.of((Object)S3FileSystem.createBeamMetadata(path.withSize(s3ObjectHead.contentLength()).withLastModified(Date.from(s3ObjectHead.lastModified())), Strings.nullToEmpty((String)s3ObjectHead.contentEncoding()), s3ObjectHead.eTag())));
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata createBeamMetadata(@UnknownKeyFor @NonNull @Initialized S3ResourceId path, @UnknownKeyFor @NonNull @Initialized String contentEncoding, @UnknownKeyFor @NonNull @Initialized String eTag) {
        Preconditions.checkArgument((boolean)path.getSize().isPresent(), (Object)"The resource id should have a size.");
        Preconditions.checkNotNull((Object)contentEncoding, (Object)"contentEncoding");
        boolean isReadSeekEfficient = !NON_READ_SEEK_EFFICIENT_ENCODINGS.contains((Object)contentEncoding);
        MatchResult.Metadata.Builder ret = MatchResult.Metadata.builder().setIsReadSeekEfficient(isReadSeekEfficient).setResourceId((ResourceId)path).setSizeBytes(((Long)path.getSize().get()).longValue()).setLastModifiedMillis(((Long)path.getLastModified().transform(Date::getTime).or((Object)0L)).longValue());
        if (eTag != null) {
            ret.setChecksum(eTag);
        }
        return ret.build();
    }

    protected @UnknownKeyFor @NonNull @Initialized WritableByteChannel create(@UnknownKeyFor @NonNull @Initialized S3ResourceId resourceId, @UnknownKeyFor @NonNull @Initialized CreateOptions createOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return new S3WritableByteChannel((S3Client)this.s3Client.get(), resourceId, createOptions.mimeType(), this.config);
    }

    protected @UnknownKeyFor @NonNull @Initialized ReadableByteChannel open(@UnknownKeyFor @NonNull @Initialized S3ResourceId resourceId) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return new S3ReadableSeekableByteChannel((S3Client)this.s3Client.get(), resourceId, this.config);
    }

    protected void copy(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized S3ResourceId> sourcePaths, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized S3ResourceId> destinationPaths) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkArgument((sourcePaths.size() == destinationPaths.size() ? 1 : 0) != 0, (Object)"sizes of sourcePaths and destinationPaths do not match");
        Stream.Builder<Callable<Void>> tasks = Stream.builder();
        Iterator<S3ResourceId> sourcePathsIterator = sourcePaths.iterator();
        Iterator<S3ResourceId> destinationPathsIterator = destinationPaths.iterator();
        while (sourcePathsIterator.hasNext()) {
            S3ResourceId sourcePath = sourcePathsIterator.next();
            S3ResourceId destinationPath = destinationPathsIterator.next();
            tasks.add(() -> {
                this.copy(sourcePath, destinationPath);
                return null;
            });
        }
        this.callTasks(tasks.build());
    }

    @VisibleForTesting
    void copy(@UnknownKeyFor @NonNull @Initialized S3ResourceId sourcePath, @UnknownKeyFor @NonNull @Initialized S3ResourceId destinationPath) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            HeadObjectResponse sourceObjectHead = this.getObjectHead(sourcePath);
            if (sourceObjectHead.contentLength() < 0x140000000L) {
                this.atomicCopy(sourcePath, destinationPath, sourceObjectHead);
            } else {
                this.multipartCopy(sourcePath, destinationPath, sourceObjectHead);
            }
        }
        catch (SdkServiceException e) {
            throw new IOException(e);
        }
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized CopyObjectResponse atomicCopy(@UnknownKeyFor @NonNull @Initialized S3ResourceId sourcePath, @UnknownKeyFor @NonNull @Initialized S3ResourceId destinationPath, @UnknownKeyFor @NonNull @Initialized HeadObjectResponse objectHead) throws @UnknownKeyFor @NonNull @Initialized SdkServiceException {
        CopyObjectRequest copyObjectRequest = (CopyObjectRequest)CopyObjectRequest.builder().sourceBucket(sourcePath.getBucket()).sourceKey(sourcePath.getKey()).destinationBucket(destinationPath.getBucket()).destinationKey(destinationPath.getKey()).metadata(objectHead.metadata()).storageClass(this.config.getS3StorageClass()).serverSideEncryption(this.config.getSSEAlgorithm()).ssekmsKeyId(this.config.getSSEKMSKeyId()).sseCustomerKey(this.config.getSSECustomerKey().getKey()).sseCustomerAlgorithm(this.config.getSSECustomerKey().getAlgorithm()).copySourceSSECustomerKey(this.config.getSSECustomerKey().getKey()).copySourceSSECustomerAlgorithm(this.config.getSSECustomerKey().getAlgorithm()).sseCustomerKeyMD5(this.config.getSSECustomerKey().getMD5()).copySourceSSECustomerKeyMD5(this.config.getSSECustomerKey().getMD5()).build();
        return ((S3Client)this.s3Client.get()).copyObject(copyObjectRequest);
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized CompleteMultipartUploadResponse multipartCopy(@UnknownKeyFor @NonNull @Initialized S3ResourceId sourcePath, @UnknownKeyFor @NonNull @Initialized S3ResourceId destinationPath, @UnknownKeyFor @NonNull @Initialized HeadObjectResponse sourceObjectHead) throws @UnknownKeyFor @NonNull @Initialized SdkServiceException {
        CreateMultipartUploadRequest initiateUploadRequest = (CreateMultipartUploadRequest)CreateMultipartUploadRequest.builder().bucket(destinationPath.getBucket()).key(destinationPath.getKey()).storageClass(this.config.getS3StorageClass()).metadata(sourceObjectHead.metadata()).serverSideEncryption(this.config.getSSEAlgorithm()).ssekmsKeyId(this.config.getSSEKMSKeyId()).sseCustomerKey(this.config.getSSECustomerKey().getKey()).sseCustomerAlgorithm(this.config.getSSECustomerKey().getAlgorithm()).sseCustomerKeyMD5(this.config.getSSECustomerKey().getMD5()).build();
        CreateMultipartUploadResponse createMultipartUploadResponse = ((S3Client)this.s3Client.get()).createMultipartUpload(initiateUploadRequest);
        String uploadId = createMultipartUploadResponse.uploadId();
        ArrayList<CompletedPart> completedParts = new ArrayList<CompletedPart>();
        long objectSize = sourceObjectHead.contentLength();
        if (objectSize == 0L) {
            UploadPartCopyRequest uploadPartCopyRequest = (UploadPartCopyRequest)UploadPartCopyRequest.builder().destinationBucket(destinationPath.getBucket()).destinationKey(destinationPath.getKey()).sourceBucket(sourcePath.getBucket()).sourceKey(sourcePath.getKey()).uploadId(uploadId).partNumber(Integer.valueOf(1)).sseCustomerKey(this.config.getSSECustomerKey().getKey()).sseCustomerAlgorithm(this.config.getSSECustomerKey().getAlgorithm()).sseCustomerKeyMD5(this.config.getSSECustomerKey().getMD5()).copySourceSSECustomerKey(this.config.getSSECustomerKey().getKey()).copySourceSSECustomerAlgorithm(this.config.getSSECustomerKey().getAlgorithm()).copySourceSSECustomerKeyMD5(this.config.getSSECustomerKey().getMD5()).build();
            CopyPartResult copyPartResult = ((S3Client)this.s3Client.get()).uploadPartCopy(uploadPartCopyRequest).copyPartResult();
            CompletedPart completedPart = (CompletedPart)CompletedPart.builder().partNumber(Integer.valueOf(1)).eTag(copyPartResult.eTag()).build();
            completedParts.add(completedPart);
        } else {
            long bytePosition = 0L;
            int partNumber = 1;
            while (bytePosition < objectSize) {
                UploadPartCopyRequest uploadPartCopyRequest = (UploadPartCopyRequest)UploadPartCopyRequest.builder().destinationBucket(destinationPath.getBucket()).destinationKey(destinationPath.getKey()).sourceBucket(sourcePath.getBucket()).sourceKey(sourcePath.getKey()).uploadId(uploadId).partNumber(Integer.valueOf(partNumber)).copySourceRange(String.format("bytes=%s-%s", bytePosition, Math.min(objectSize - 1L, bytePosition + 0x140000000L - 1L))).sseCustomerKey(this.config.getSSECustomerKey().getKey()).sseCustomerAlgorithm(this.config.getSSECustomerKey().getAlgorithm()).sseCustomerKeyMD5(this.config.getSSECustomerKey().getMD5()).copySourceSSECustomerKey(this.config.getSSECustomerKey().getKey()).copySourceSSECustomerAlgorithm(this.config.getSSECustomerKey().getAlgorithm()).copySourceSSECustomerKeyMD5(this.config.getSSECustomerKey().getMD5()).build();
                CopyPartResult copyPartResult = ((S3Client)this.s3Client.get()).uploadPartCopy(uploadPartCopyRequest).copyPartResult();
                CompletedPart completedPart = (CompletedPart)CompletedPart.builder().partNumber(Integer.valueOf(partNumber)).eTag(copyPartResult.eTag()).build();
                completedParts.add(completedPart);
                bytePosition += 0x140000000L;
                ++partNumber;
            }
        }
        CompletedMultipartUpload completedMultipartUpload = (CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(completedParts).build();
        CompleteMultipartUploadRequest completeUploadRequest = (CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().bucket(destinationPath.getBucket()).key(destinationPath.getKey()).uploadId(uploadId).multipartUpload(completedMultipartUpload).build();
        return ((S3Client)this.s3Client.get()).completeMultipartUpload(completeUploadRequest);
    }

    protected void rename(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized S3ResourceId> sourceResourceIds, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized S3ResourceId> destinationResourceIds, MoveOptions ... moveOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (moveOptions.length > 0) {
            throw new UnsupportedOperationException("Support for move options is not yet implemented.");
        }
        this.copy(sourceResourceIds, destinationResourceIds);
        this.delete(sourceResourceIds);
    }

    protected void delete(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized S3ResourceId> resourceIds) throws @UnknownKeyFor @NonNull @Initialized IOException {
        List<S3ResourceId> nonDirectoryPaths = resourceIds.stream().filter(s3ResourceId -> !s3ResourceId.isDirectory()).collect(Collectors.toList());
        ArrayListMultimap keysByBucket = ArrayListMultimap.create();
        nonDirectoryPaths.forEach(arg_0 -> S3FileSystem.lambda$delete$15((Multimap)keysByBucket, arg_0));
        Stream.Builder tasks = Stream.builder();
        keysByBucket.keySet().forEach(arg_0 -> this.lambda$delete$18((Multimap)keysByBucket, tasks, arg_0));
        this.callTasks(tasks.build());
    }

    private void delete(@UnknownKeyFor @NonNull @Initialized String bucket, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> keys) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkArgument((keys.size() <= 1000 ? 1 : 0) != 0, (String)"only %s keys can be deleted per request, but got %s", (int)1000, (int)keys.size());
        List deleteKeyVersions = keys.stream().map(key -> (ObjectIdentifier)ObjectIdentifier.builder().key(key).build()).collect(Collectors.toList());
        Delete delete = (Delete)Delete.builder().objects(deleteKeyVersions).quiet(Boolean.valueOf(true)).build();
        DeleteObjectsRequest deleteObjectsRequest = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(bucket).delete(delete).build();
        try {
            ((S3Client)this.s3Client.get()).deleteObjects(deleteObjectsRequest);
        }
        catch (SdkServiceException e) {
            throw new IOException(e);
        }
    }

    protected @UnknownKeyFor @NonNull @Initialized S3ResourceId matchNewResource(@UnknownKeyFor @NonNull @Initialized String singleResourceSpec, @UnknownKeyFor @NonNull @Initialized boolean isDirectory) {
        if (isDirectory) {
            if (!singleResourceSpec.endsWith("/")) {
                singleResourceSpec = singleResourceSpec + "/";
            }
        } else {
            Preconditions.checkArgument((!singleResourceSpec.endsWith("/") ? 1 : 0) != 0, (String)"Expected a file path, but [%s] ends with '/'. This is unsupported in S3FileSystem.", (Object)singleResourceSpec);
        }
        return S3ResourceId.fromUri(singleResourceSpec);
    }

    protected void reportLineage(@UnknownKeyFor @NonNull @Initialized S3ResourceId resourceId, @UnknownKeyFor @NonNull @Initialized Lineage lineage) {
        this.reportLineage(resourceId, lineage, FileSystem.LineageLevel.FILE);
    }

    protected void reportLineage(@UnknownKeyFor @NonNull @Initialized S3ResourceId resourceId, @UnknownKeyFor @NonNull @Initialized Lineage lineage, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized FileSystem.LineageLevel level) {
        ImmutableList.Builder segments = ImmutableList.builder().add((Object)resourceId.getBucket());
        if (level != FileSystem.LineageLevel.TOP_LEVEL && !resourceId.getKey().isEmpty()) {
            segments.add((Object)resourceId.getKey());
        }
        lineage.add("s3", (Iterable)segments.build());
    }

    private <T> @UnknownKeyFor @NonNull @Initialized List<T> callTasks(@UnknownKeyFor @NonNull @Initialized Stream<@UnknownKeyFor @NonNull @Initialized Callable<T>> tasks) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            return (List)MoreFutures.get((CompletionStage)MoreFutures.allAsList((Collection)tasks.map(task -> MoreFutures.supplyAsync(task::call, (ExecutorService)this.executorService)).collect(Collectors.toList())));
        }
        catch (ExecutionException e) {
            if (e.getCause() != null) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException(e.getCause());
            }
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("executor service was interrupted");
        }
    }

    private /* synthetic */ void lambda$delete$18(Multimap keysByBucket, Stream.Builder tasks, String bucket) {
        Iterables.partition((Iterable)keysByBucket.get((Object)bucket), (int)1000).forEach(keysPartition -> tasks.add(() -> {
            this.delete(bucket, (Collection<String>)keysPartition);
            return null;
        }));
    }

    private static /* synthetic */ void lambda$delete$15(Multimap keysByBucket, S3ResourceId path) {
        keysByBucket.put((Object)path.getBucket(), (Object)path.getKey());
    }

    @AutoValue
    static abstract class PathWithEncoding {
        PathWithEncoding() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized S3ResourceId getPath();

        abstract @Nullable @UnknownKeyFor @Initialized String getContentEncoding();

        abstract @Nullable @UnknownKeyFor @Initialized IOException getException();

        static @UnknownKeyFor @NonNull @Initialized PathWithEncoding create(@UnknownKeyFor @NonNull @Initialized S3ResourceId path, @UnknownKeyFor @NonNull @Initialized String contentEncoding) {
            Preconditions.checkNotNull((Object)path, (Object)"path");
            Preconditions.checkNotNull((Object)contentEncoding, (Object)"contentEncoding");
            return new AutoValue_S3FileSystem_PathWithEncoding(path, contentEncoding, null);
        }

        static @UnknownKeyFor @NonNull @Initialized PathWithEncoding create(@UnknownKeyFor @NonNull @Initialized S3ResourceId path, @UnknownKeyFor @NonNull @Initialized IOException exception) {
            Preconditions.checkNotNull((Object)path, (Object)"path");
            Preconditions.checkNotNull((Object)exception, (Object)"exception");
            return new AutoValue_S3FileSystem_PathWithEncoding(path, null, exception);
        }
    }

    @AutoValue
    static abstract class ExpandedGlob {
        ExpandedGlob() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized S3ResourceId getGlobPath();

        abstract @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized S3ResourceId> getExpandedPaths();

        abstract @Nullable @UnknownKeyFor @Initialized IOException getException();

        static @UnknownKeyFor @NonNull @Initialized ExpandedGlob create(@UnknownKeyFor @NonNull @Initialized S3ResourceId globPath, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized S3ResourceId> expandedPaths) {
            Preconditions.checkNotNull((Object)globPath, (Object)"globPath");
            Preconditions.checkNotNull(expandedPaths, (Object)"expandedPaths");
            return new AutoValue_S3FileSystem_ExpandedGlob(globPath, expandedPaths, null);
        }

        static @UnknownKeyFor @NonNull @Initialized ExpandedGlob create(@UnknownKeyFor @NonNull @Initialized S3ResourceId globPath, @UnknownKeyFor @NonNull @Initialized IOException exception) {
            Preconditions.checkNotNull((Object)globPath, (Object)"globPath");
            Preconditions.checkNotNull((Object)exception, (Object)"exception");
            return new AutoValue_S3FileSystem_ExpandedGlob(globPath, null, exception);
        }
    }
}

