/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.options;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.ContainerCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.auth.credentials.SystemPropertyCredentialsProvider;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.profiles.ProfileFileSystemSetting;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleWithWebIdentityCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;

@AutoService(value={Module.class})
public class AwsModule
extends SimpleModule {
    private static final @UnknownKeyFor @NonNull @Initialized String ACCESS_KEY_ID = "accessKeyId";
    private static final @UnknownKeyFor @NonNull @Initialized String SECRET_ACCESS_KEY = "secretAccessKey";
    private static final @UnknownKeyFor @NonNull @Initialized String SESSION_TOKEN = "sessionToken";
    private static final @UnknownKeyFor @NonNull @Initialized String PROFILE_NAME = "profileName";

    public AwsModule() {
        super("AwsModule");
    }

    public void setupModule(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Module.SetupContext cxt) {
        cxt.setMixInAnnotations(AwsCredentialsProvider.class, AwsCredentialsProviderMixin.class);
        cxt.setMixInAnnotations(ProxyConfiguration.class, ProxyConfigurationMixin.class);
        cxt.setMixInAnnotations(ProxyConfiguration.Builder.class, ProxyConfigurationMixin.Builder.class);
        cxt.setMixInAnnotations(Region.class, RegionMixin.class);
        this.addValueInstantiator(ProxyConfiguration.Builder.class, ProxyConfiguration::builder);
        super.setupModule(cxt);
    }

    private <T> void addValueInstantiator(@UnknownKeyFor @NonNull @Initialized Class<T> clazz, final @UnknownKeyFor @NonNull @Initialized Instantiator<T> instantiator) {
        this.addValueInstantiator(clazz, (ValueInstantiator)new ValueInstantiator.Base(clazz){

            public @UnknownKeyFor @NonNull @Initialized Object createUsingDefault(@UnknownKeyFor @NonNull @Initialized DeserializationContext cxt) {
                return instantiator.create();
            }

            public @UnknownKeyFor @NonNull @Initialized boolean canCreateUsingDefault() {
                return true;
            }
        });
    }

    private static interface Instantiator<@UnknownKeyFor T> {
        public @NonNull T create();
    }

    @JsonDeserialize(builder=ProxyConfiguration.Builder.class)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(value={"host", "port", "scheme"})
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private static class ProxyConfigurationMixin {
        private ProxyConfigurationMixin() {
        }

        @JsonPOJOBuilder(withPrefix="")
        static class Builder {
            Builder() {
            }
        }
    }

    private static class AWSCredentialsProviderSerializer
    extends JsonSerializer<AwsCredentialsProvider> {
        private static final @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized Object> SINGLETON_CREDENTIAL_PROVIDERS = ImmutableSet.of(DefaultCredentialsProvider.class, EnvironmentVariableCredentialsProvider.class, SystemPropertyCredentialsProvider.class, ContainerCredentialsProvider.class);

        private AWSCredentialsProviderSerializer() {
        }

        public void serialize(@UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider credentialsProvider, @UnknownKeyFor @NonNull @Initialized JsonGenerator jsonGenerator, @UnknownKeyFor @NonNull @Initialized SerializerProvider serializer) throws @UnknownKeyFor @NonNull @Initialized IOException {
            serializer.defaultSerializeValue((Object)credentialsProvider, jsonGenerator);
        }

        public void serializeWithType(@UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider credentialsProvider, @UnknownKeyFor @NonNull @Initialized JsonGenerator jsonGenerator, @UnknownKeyFor @NonNull @Initialized SerializerProvider serializer, @UnknownKeyFor @NonNull @Initialized TypeSerializer typeSerializer) throws @UnknownKeyFor @NonNull @Initialized IOException {
            typeSerializer.writeTypePrefixForObject((Object)credentialsProvider, jsonGenerator);
            Class<?> providerClass = credentialsProvider.getClass();
            if (providerClass.equals(StaticCredentialsProvider.class)) {
                AwsCredentials credentials = credentialsProvider.resolveCredentials();
                if (credentials.getClass().equals(AwsSessionCredentials.class)) {
                    AwsSessionCredentials sessionCredentials = (AwsSessionCredentials)credentials;
                    jsonGenerator.writeStringField(AwsModule.ACCESS_KEY_ID, sessionCredentials.accessKeyId());
                    jsonGenerator.writeStringField(AwsModule.SECRET_ACCESS_KEY, sessionCredentials.secretAccessKey());
                    jsonGenerator.writeStringField(AwsModule.SESSION_TOKEN, sessionCredentials.sessionToken());
                } else {
                    jsonGenerator.writeStringField(AwsModule.ACCESS_KEY_ID, credentials.accessKeyId());
                    jsonGenerator.writeStringField(AwsModule.SECRET_ACCESS_KEY, credentials.secretAccessKey());
                }
            } else if (providerClass.equals(ProfileCredentialsProvider.class)) {
                String profileName = (String)this.readField(credentialsProvider, AwsModule.PROFILE_NAME);
                String envProfileName = ProfileFileSystemSetting.AWS_PROFILE.getStringValueOrThrow();
                if (profileName != null && !profileName.equals(envProfileName)) {
                    jsonGenerator.writeStringField(AwsModule.PROFILE_NAME, profileName);
                }
            } else if (providerClass.equals(StsAssumeRoleCredentialsProvider.class)) {
                Supplier reqSupplier = (Supplier)this.readField(credentialsProvider, "assumeRoleRequestSupplier");
                serializer.findValueSerializer(AssumeRoleRequest.serializableBuilderClass()).unwrappingSerializer(NameTransformer.NOP).serialize((Object)((AssumeRoleRequest)reqSupplier.get()).toBuilder(), jsonGenerator, serializer);
            } else if (providerClass.equals(StsAssumeRoleWithWebIdentityCredentialsProvider.class)) {
                Supplier reqSupplier = (Supplier)this.readField(credentialsProvider, "assumeRoleWithWebIdentityRequest");
                serializer.findValueSerializer(AssumeRoleWithWebIdentityRequest.serializableBuilderClass()).unwrappingSerializer(NameTransformer.NOP).serialize((Object)((AssumeRoleWithWebIdentityRequest)reqSupplier.get()).toBuilder(), jsonGenerator, serializer);
            } else if (!SINGLETON_CREDENTIAL_PROVIDERS.contains(providerClass)) {
                throw new IllegalArgumentException("Unsupported AWS credentials provider type " + providerClass);
            }
            typeSerializer.writeTypeSuffixForObject((Object)credentialsProvider, jsonGenerator);
        }

        private @UnknownKeyFor @NonNull @Initialized Object readField(@UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider provider, @UnknownKeyFor @NonNull @Initialized String fieldName) throws @UnknownKeyFor @NonNull @Initialized IOException {
            try {
                return FieldUtils.readField((Object)provider, (String)fieldName, (boolean)true);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new IOException(String.format("Failed to access private field '%s' of AWS credential provider type '%s' with reflection", fieldName, provider.getClass().getSimpleName()), e);
            }
        }
    }

    private static class AwsCredentialsProviderDeserializer
    extends JsonDeserializer<AwsCredentialsProvider> {
        private AwsCredentialsProviderDeserializer() {
        }

        public @UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider deserialize(@UnknownKeyFor @NonNull @Initialized JsonParser jsonParser, @UnknownKeyFor @NonNull @Initialized DeserializationContext context) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return (AwsCredentialsProvider)context.readValue(jsonParser, AwsCredentialsProvider.class);
        }

        public @UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider deserializeWithType(@UnknownKeyFor @NonNull @Initialized JsonParser jsonParser, @UnknownKeyFor @NonNull @Initialized DeserializationContext context, @UnknownKeyFor @NonNull @Initialized TypeDeserializer typeDeserializer) throws @UnknownKeyFor @NonNull @Initialized IOException {
            ObjectNode json = (ObjectNode)Preconditions.checkNotNull((Object)((ObjectNode)jsonParser.readValueAs((TypeReference)new TypeReference<ObjectNode>(){})), (Object)"Serialized AWS credentials provider is null");
            String typeNameKey = typeDeserializer.getPropertyName();
            String typeName = this.getNotNull((JsonNode)json, typeNameKey, "unknown");
            json.remove(typeNameKey);
            if (this.hasName(StaticCredentialsProvider.class, typeName)) {
                boolean isSession = json.has(AwsModule.SESSION_TOKEN);
                if (isSession) {
                    return StaticCredentialsProvider.create((AwsCredentials)AwsSessionCredentials.create((String)this.getNotNull((JsonNode)json, AwsModule.ACCESS_KEY_ID, typeName), (String)this.getNotNull((JsonNode)json, AwsModule.SECRET_ACCESS_KEY, typeName), (String)this.getNotNull((JsonNode)json, AwsModule.SESSION_TOKEN, typeName)));
                }
                return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.getNotNull((JsonNode)json, AwsModule.ACCESS_KEY_ID, typeName), (String)this.getNotNull((JsonNode)json, AwsModule.SECRET_ACCESS_KEY, typeName)));
            }
            if (this.hasName(DefaultCredentialsProvider.class, typeName)) {
                return DefaultCredentialsProvider.create();
            }
            if (this.hasName(EnvironmentVariableCredentialsProvider.class, typeName)) {
                return EnvironmentVariableCredentialsProvider.create();
            }
            if (this.hasName(SystemPropertyCredentialsProvider.class, typeName)) {
                return SystemPropertyCredentialsProvider.create();
            }
            if (this.hasName(ProfileCredentialsProvider.class, typeName)) {
                return json.has(AwsModule.PROFILE_NAME) ? ProfileCredentialsProvider.create((String)this.getNotNull((JsonNode)json, AwsModule.PROFILE_NAME, typeName)) : ProfileCredentialsProvider.create();
            }
            if (this.hasName(ContainerCredentialsProvider.class, typeName)) {
                return ContainerCredentialsProvider.builder().build();
            }
            if (typeName.equals(StsAssumeRoleCredentialsProvider.class.getSimpleName())) {
                Class clazz = AssumeRoleRequest.serializableBuilderClass();
                return ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().refreshRequest((AssumeRoleRequest)((AssumeRoleRequest.Builder)jsonParser.getCodec().treeToValue((TreeNode)json, clazz)).build()).stsClient(StsClient.create())).build();
            }
            if (typeName.equals(StsAssumeRoleWithWebIdentityCredentialsProvider.class.getSimpleName())) {
                Class clazz = AssumeRoleWithWebIdentityRequest.serializableBuilderClass();
                return ((StsAssumeRoleWithWebIdentityCredentialsProvider.Builder)StsAssumeRoleWithWebIdentityCredentialsProvider.builder().refreshRequest((AssumeRoleWithWebIdentityRequest)((AssumeRoleWithWebIdentityRequest.Builder)jsonParser.getCodec().treeToValue((TreeNode)json, clazz)).build()).stsClient((StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().region(Region.AWS_GLOBAL)).credentialsProvider((AwsCredentialsProvider)AnonymousCredentialsProvider.create())).build())).build();
            }
            throw new IOException(String.format("AWS credential provider type '%s' is not supported", typeName));
        }

        private @UnknownKeyFor @NonNull @Initialized String getNotNull(@UnknownKeyFor @NonNull @Initialized JsonNode json, @UnknownKeyFor @NonNull @Initialized String key, @UnknownKeyFor @NonNull @Initialized String typeName) {
            JsonNode node = json.get(key);
            Preconditions.checkNotNull((Object)node, (String)"AWS credentials provider type '%s' is missing '%s'", (Object)typeName, (Object)key);
            return node.textValue();
        }

        private @UnknownKeyFor @NonNull @Initialized boolean hasName(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider> clazz, @UnknownKeyFor @NonNull @Initialized String typeName) {
            return clazz.getSimpleName().equals(typeName);
        }
    }

    @JsonDeserialize(using=AwsCredentialsProviderDeserializer.class)
    @JsonSerialize(using=AWSCredentialsProviderSerializer.class)
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
    private static class AwsCredentialsProviderMixin {
        private AwsCredentialsProviderMixin() {
        }
    }

    @JsonDeserialize(using=Deserializer.class)
    @JsonSerialize(using=Serializer.class)
    private static class RegionMixin {
        private RegionMixin() {
        }

        private static class Serializer
        extends JsonSerializer<Region> {
            private Serializer() {
            }

            public void serialize(@UnknownKeyFor @NonNull @Initialized Region value, @UnknownKeyFor @NonNull @Initialized JsonGenerator gen, @UnknownKeyFor @NonNull @Initialized SerializerProvider serializers) throws @UnknownKeyFor @NonNull @Initialized IOException {
                gen.writeString(value.id());
            }
        }

        private static class Deserializer
        extends JsonDeserializer<Region> {
            private Deserializer() {
            }

            public @UnknownKeyFor @NonNull @Initialized Region deserialize(@UnknownKeyFor @NonNull @Initialized JsonParser p, @UnknownKeyFor @NonNull @Initialized DeserializationContext cxt) throws @UnknownKeyFor @NonNull @Initialized IOException {
                return Region.of((String)((String)p.readValueAs(String.class)));
            }
        }
    }
}

