/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws2.common.AsyncBatchWriteHandler;
import org.apache.beam.sdk.io.aws2.common.ClientBuilderFactory;
import org.apache.beam.sdk.io.aws2.common.ClientConfiguration;
import org.apache.beam.sdk.io.aws2.common.ObjectPool;
import org.apache.beam.sdk.io.aws2.kinesis.AutoValue_KinesisIO_Read;
import org.apache.beam.sdk.io.aws2.kinesis.AutoValue_KinesisIO_RecordAggregation;
import org.apache.beam.sdk.io.aws2.kinesis.AutoValue_KinesisIO_Write;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisPartitioner;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisSource;
import org.apache.beam.sdk.io.aws2.kinesis.RateLimitPolicyFactory;
import org.apache.beam.sdk.io.aws2.kinesis.RecordsAggregator;
import org.apache.beam.sdk.io.aws2.kinesis.StartingPoint;
import org.apache.beam.sdk.io.aws2.kinesis.WatermarkPolicyFactory;
import org.apache.beam.sdk.io.aws2.options.AwsOptions;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Max;
import org.apache.beam.sdk.transforms.Min;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.util.MovingFunction;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSortedSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.DateTimeUtils;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.model.ListShardsRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequestEntry;
import software.amazon.awssdk.services.kinesis.model.PutRecordsResultEntry;
import software.amazon.awssdk.services.kinesis.model.Shard;
import software.amazon.awssdk.services.kinesis.model.ShardFilterType;
import software.amazon.kinesis.common.InitialPositionInStream;

public final class KinesisIO {
    public static @UnknownKeyFor @NonNull @Initialized Read read() {
        return new AutoValue_KinesisIO_Read.Builder().setClientConfiguration(ClientConfiguration.builder().build()).setMaxNumRecords(Long.MAX_VALUE).setUpToDateThreshold(Duration.ZERO).setWatermarkPolicyFactory(WatermarkPolicyFactory.withArrivalTimePolicy()).setRateLimitPolicyFactory(RateLimitPolicyFactory.withDefaultRateLimiter()).build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Write<T> write() {
        return new AutoValue_KinesisIO_Write.Builder().streamName("").serializer(Write.DUMMY_SERIALIZER).partitioner(Write.DUMMY_PARTITIONER).clientConfiguration(ClientConfiguration.builder().build()).batchMaxRecords(500).batchMaxBytes(0x480000).concurrentRequests(3).recordAggregation(RecordAggregation.builder().build()).build();
    }

    @AutoValue
    public static abstract class Write<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, Result> {
        static final @UnknownKeyFor @NonNull @Initialized int MAX_RECORDS_PER_REQUEST = 500;
        static final @UnknownKeyFor @NonNull @Initialized int MAX_BYTES_PER_RECORD = 0x100000;
        static final @UnknownKeyFor @NonNull @Initialized int MAX_BYTES_PER_REQUEST = 0x500000;
        private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_CONCURRENCY = 3;
        private static final @UnknownKeyFor @NonNull @Initialized KinesisPartitioner<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Object> DUMMY_PARTITIONER = obj -> "";
        private static final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> DUMMY_SERIALIZER = (SerializableFunction & Serializable)obj -> ArrayUtils.EMPTY_BYTE_ARRAY;

        @Pure
        abstract @UnknownKeyFor @NonNull @Initialized String streamName();

        @Pure
        abstract @UnknownKeyFor @NonNull @Initialized int batchMaxRecords();

        @Pure
        abstract @UnknownKeyFor @NonNull @Initialized int batchMaxBytes();

        @Pure
        abstract @UnknownKeyFor @NonNull @Initialized int concurrentRequests();

        @Pure
        abstract @UnknownKeyFor @NonNull @Initialized KinesisPartitioner<T> partitioner();

        @Pure
        abstract @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> serializer();

        @Pure
        abstract @UnknownKeyFor @NonNull @Initialized ClientConfiguration clientConfiguration();

        @Pure
        abstract @Nullable @UnknownKeyFor @Initialized RecordAggregation recordAggregation();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> builder();

        public @UnknownKeyFor @NonNull @Initialized Write<T> withStreamName(@UnknownKeyFor @NonNull @Initialized String streamName) {
            Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)streamName) ? 1 : 0) != 0, (Object)"streamName cannot be empty");
            return this.builder().streamName(streamName).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withBatchMaxRecords(@UnknownKeyFor @NonNull @Initialized int records) {
            Preconditions.checkArgument((records > 0 && records <= 500 ? 1 : 0) != 0, (String)"batchMaxRecords must be in [1,%s]", (int)500);
            return this.builder().batchMaxRecords(records).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withBatchMaxBytes(@UnknownKeyFor @NonNull @Initialized int bytes) {
            Preconditions.checkArgument((bytes > 0 && bytes <= 0x500000 ? 1 : 0) != 0, (String)"batchMaxBytes must be in [1,%s]", (int)0x500000);
            return this.builder().batchMaxBytes(bytes).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withConcurrentRequests(@UnknownKeyFor @NonNull @Initialized int concurrentRequests) {
            Preconditions.checkArgument((concurrentRequests > 0 ? 1 : 0) != 0, (Object)"concurrentRequests must be > 0");
            return this.builder().concurrentRequests(concurrentRequests).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withRecordAggregation(@UnknownKeyFor @NonNull @Initialized RecordAggregation aggregation) {
            return this.builder().recordAggregation(aggregation).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withRecordAggregation(@UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized RecordAggregation.Builder> aggregation) {
            RecordAggregation.Builder builder = RecordAggregation.builder();
            aggregation.accept(builder);
            return this.withRecordAggregation(builder.build());
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withRecordAggregationDisabled() {
            return this.builder().recordAggregation(null).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withPartitioner(@UnknownKeyFor @NonNull @Initialized KinesisPartitioner<T> partitioner) {
            Preconditions.checkArgument((this.partitioner() != null ? 1 : 0) != 0, (Object)"partitioner cannot be null");
            return this.builder().partitioner(partitioner).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withSerializer(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> serializer) {
            Preconditions.checkArgument((this.serializer() != null ? 1 : 0) != 0, (Object)"serializer cannot be null");
            return this.builder().serializer(serializer).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withClientConfiguration(@UnknownKeyFor @NonNull @Initialized ClientConfiguration config) {
            Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"clientConfiguration cannot be null");
            return this.builder().clientConfiguration(config).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Result expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)this.streamName()) ? 1 : 0) != 0, (Object)"streamName is required");
            Preconditions.checkArgument((this.partitioner() != DUMMY_PARTITIONER ? 1 : 0) != 0, (Object)"partitioner is required");
            Preconditions.checkArgument((this.serializer() != DUMMY_SERIALIZER ? 1 : 0) != 0, (Object)"serializer is required");
            AwsOptions awsOptions = (AwsOptions)input.getPipeline().getOptions().as(AwsOptions.class);
            ClientBuilderFactory.validate(awsOptions, this.clientConfiguration());
            input.apply((PTransform)ParDo.of((DoFn)new DoFn<T, Void>(){
                private transient @Nullable @UnknownKeyFor @Initialized Writer<T> writer;

                @DoFn.Setup
                public void setup(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
                    this.writer = this.recordAggregation() != null ? new AggregatedWriter(options, this, this.recordAggregation()) : new Writer(options, this);
                }

                @DoFn.StartBundle
                public void startBundle() {
                    this.writer().startBundle();
                }

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element T record) throws @UnknownKeyFor @NonNull @Initialized Throwable {
                    this.writer().write(record);
                }

                @DoFn.FinishBundle
                public void finishBundle() throws @UnknownKeyFor @NonNull @Initialized Throwable {
                    this.writer().finishBundle();
                }

                @DoFn.Teardown
                public void teardown() throws @UnknownKeyFor @NonNull @Initialized Exception {
                    if (this.writer != null) {
                        this.writer.close();
                        this.writer = null;
                    }
                }

                private @UnknownKeyFor @NonNull @Initialized Writer<T> writer() {
                    if (this.writer == null) {
                        throw new IllegalStateException("RecordWriter is null");
                    }
                    return this.writer;
                }
            }));
            return new Result(input.getPipeline());
        }

        private static class Stats
        implements AsyncBatchWriteHandler.Stats {
            private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(Stats.class);
            private static final @UnknownKeyFor @NonNull @Initialized Duration LOG_STATS_PERIOD = Duration.standardSeconds((long)10L);
            private static final // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized Combine.BinaryCombineLongFn MIN = Min.ofLongs();
            private static final // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized Combine.BinaryCombineLongFn MAX = Max.ofLongs();
            private static final // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized Combine.BinaryCombineLongFn SUM = Sum.ofLongs();
            private static final @UnknownKeyFor @NonNull @Initialized Duration MOVING_WINDOW = Duration.standardMinutes((long)3L);
            private static final @UnknownKeyFor @NonNull @Initialized Duration UPDATE_PERIOD = Duration.standardSeconds((long)30L);
            private static final @UnknownKeyFor @NonNull @Initialized String METRICS_PREFIX = "kinesis_io/write_";
            private static final @UnknownKeyFor @NonNull @Initialized Counter USER_RECORDS_COUNT = Metrics.counter(Write.class, (String)"kinesis_io/write_user_records_count");
            private static final @UnknownKeyFor @NonNull @Initialized Counter CLIENT_RECORDS_COUNT = Metrics.counter(Write.class, (String)"kinesis_io/write_client_records_count");
            private static final @UnknownKeyFor @NonNull @Initialized Distribution WRITE_LATENCY_MS = Metrics.distribution(Write.class, (String)"kinesis_io/write_latency_ms");
            private final @UnknownKeyFor @NonNull @Initialized MovingFunction numUserRecords = Stats.newFun(SUM);
            private final @UnknownKeyFor @NonNull @Initialized MovingFunction numClientRecords = Stats.newFun(SUM);
            private final @UnknownKeyFor @NonNull @Initialized MovingFunction minClientRecordBytes = Stats.newFun(MIN);
            private final @UnknownKeyFor @NonNull @Initialized MovingFunction maxClientRecordBytes = Stats.newFun(MAX);
            private final @UnknownKeyFor @NonNull @Initialized MovingFunction sumClientRecordBytes = Stats.newFun(SUM);
            private final @UnknownKeyFor @NonNull @Initialized MovingFunction numPutPartialRetries = Stats.newFun(SUM);
            private final @UnknownKeyFor @NonNull @Initialized MovingFunction numPutRequests = Stats.newFun(SUM);
            private final @UnknownKeyFor @NonNull @Initialized MovingFunction minPutRequestLatency = Stats.newFun(MIN);
            private final @UnknownKeyFor @NonNull @Initialized MovingFunction maxPutRequestLatency = Stats.newFun(MAX);
            private final @UnknownKeyFor @NonNull @Initialized MovingFunction sumPutRequestLatency = Stats.newFun(SUM);
            private @UnknownKeyFor @NonNull @Initialized long nextLogTime = DateTimeUtils.currentTimeMillis() + LOG_STATS_PERIOD.getMillis();

            private Stats() {
            }

            private static @UnknownKeyFor @NonNull @Initialized MovingFunction newFun(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized Combine.BinaryCombineLongFn fn) {
                return new MovingFunction(MOVING_WINDOW.getMillis(), UPDATE_PERIOD.getMillis(), 1, 1, fn);
            }

            void addUserRecord() {
                USER_RECORDS_COUNT.inc();
                this.numUserRecords.add(DateTimeUtils.currentTimeMillis(), 1L);
            }

            void addClientRecord(@UnknownKeyFor @NonNull @Initialized int recordBytes) {
                long timeMillis = DateTimeUtils.currentTimeMillis();
                CLIENT_RECORDS_COUNT.inc();
                this.numClientRecords.add(timeMillis, 1L);
                this.minClientRecordBytes.add(timeMillis, (long)recordBytes);
                this.maxClientRecordBytes.add(timeMillis, (long)recordBytes);
                this.sumClientRecordBytes.add(timeMillis, (long)recordBytes);
            }

            @Override
            public void addBatchWriteRequest(@UnknownKeyFor @NonNull @Initialized long latencyMillis, @UnknownKeyFor @NonNull @Initialized boolean isPartialRetry) {
                long timeMillis = DateTimeUtils.currentTimeMillis();
                this.numPutRequests.add(timeMillis, 1L);
                if (isPartialRetry) {
                    this.numPutPartialRetries.add(timeMillis, 1L);
                }
                this.minPutRequestLatency.add(timeMillis, latencyMillis);
                this.maxPutRequestLatency.add(timeMillis, latencyMillis);
                this.sumPutRequestLatency.add(timeMillis, latencyMillis);
            }

            private void logPeriodically() {
                long now = DateTimeUtils.currentTimeMillis();
                WRITE_LATENCY_MS.update(this.sumPutRequestLatency.get(now), this.numPutRequests.get(now), this.minPutRequestLatency.get(now), this.maxPutRequestLatency.get(now));
                if (now > this.nextLogTime && LOG.isInfoEnabled()) {
                    this.nextLogTime = now + LOG_STATS_PERIOD.getMillis();
                    long clientRecords = this.numClientRecords.get(now);
                    long putRequests = this.numPutRequests.get(now);
                    long putPartialRetries = this.numPutPartialRetries.get(now);
                    LOG.info("Kinesis put records stats [ batches={}, requests={}, partialRetryRatio={}\n  userRecords={}, clientRecords={}, avgClientRecordSize={} bytes, minClientRecordSize={} bytes, maxClientRecordSize={} bytes\n  avgRequestLatency={} ms, minRequestLatency={} ms, maxRequestLatency={}]", new Object[]{putRequests - putPartialRetries, putRequests, putRequests > 0L ? 1.0 * (double)putPartialRetries / (double)putRequests : 0.0, this.numUserRecords.get(now), clientRecords, clientRecords > 0L ? this.sumClientRecordBytes.get(now) / clientRecords : 0L, this.minClientRecordBytes.get(now), this.maxClientRecordBytes.get(now), putRequests > 0L ? this.sumPutRequestLatency.get(now) / putRequests : 0L, this.minPutRequestLatency.get(now), this.maxPutRequestLatency.get(now)});
                }
            }
        }

        @VisibleForTesting
        @ThreadSafe
        static interface ShardRanges {
            public static final @UnknownKeyFor @NonNull @Initialized ShardRanges EMPTY = new ShardRanges(){};

            public static @UnknownKeyFor @NonNull @Initialized ShardRanges of(@UnknownKeyFor @NonNull @Initialized String stream) {
                return new ShardRangesImpl(stream);
            }

            default public @Nullable @UnknownKeyFor @Initialized BigInteger shardAwareHashKey(@UnknownKeyFor @NonNull @Initialized BigInteger hashedPartitionKey) {
                return null;
            }

            default public void refreshPeriodically(@UnknownKeyFor @NonNull @Initialized KinesisAsyncClient kinesis, @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Instant> nextRefreshFn) {
            }

            public static class ShardRangesImpl
            implements ShardRanges {
                private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ShardRanges.class);
                private final @UnknownKeyFor @NonNull @Initialized String streamName;
                private final @UnknownKeyFor @NonNull @Initialized AtomicBoolean running = new AtomicBoolean(false);
                private @UnknownKeyFor @NonNull @Initialized NavigableSet<@UnknownKeyFor @NonNull @Initialized BigInteger> shardBounds = ImmutableSortedSet.of();
                private @UnknownKeyFor @NonNull @Initialized Instant nextRefresh = Instant.EPOCH;

                private ShardRangesImpl(@UnknownKeyFor @NonNull @Initialized String streamName) {
                    this.streamName = streamName;
                }

                @Override
                public @Nullable @UnknownKeyFor @Initialized BigInteger shardAwareHashKey(@UnknownKeyFor @NonNull @Initialized BigInteger hashedPartitionKey) {
                    BigInteger lowerBound = this.shardBounds.floor(hashedPartitionKey);
                    if (!this.shardBounds.isEmpty() && lowerBound == null) {
                        LOG.warn("No shard found for {} [shards={}]", (Object)hashedPartitionKey, (Object)this.shardBounds.size());
                    }
                    return lowerBound;
                }

                @Override
                public void refreshPeriodically(@UnknownKeyFor @NonNull @Initialized KinesisAsyncClient client, @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Instant> nextRefreshFn) {
                    if (this.nextRefresh.isBeforeNow() && this.running.compareAndSet(false, true)) {
                        this.refresh(client, nextRefreshFn, new TreeSet<BigInteger>(), null);
                    }
                }

                private void refresh(@UnknownKeyFor @NonNull @Initialized KinesisAsyncClient client, @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Instant> nextRefreshFn, @UnknownKeyFor @NonNull @Initialized TreeSet<@UnknownKeyFor @NonNull @Initialized BigInteger> bounds, @Nullable @UnknownKeyFor @Initialized String nextToken) {
                    ListShardsRequest.Builder reqBuilder = ListShardsRequest.builder().shardFilter(f -> f.type(ShardFilterType.AT_LATEST));
                    if (nextToken != null) {
                        reqBuilder.nextToken(nextToken);
                    } else {
                        reqBuilder.streamName(this.streamName);
                    }
                    client.listShards((ListShardsRequest)reqBuilder.build()).whenComplete((resp, exc) -> {
                        if (exc != null) {
                            LOG.warn("Failed to refresh shards.", exc);
                            this.nextRefresh = (Instant)nextRefreshFn.get();
                            this.running.set(false);
                            return;
                        }
                        resp.shards().forEach(shard -> bounds.add(this.lowerHashKey((Shard)shard)));
                        if (resp.nextToken() != null) {
                            this.refresh(client, nextRefreshFn, bounds, resp.nextToken());
                            return;
                        }
                        LOG.debug("Done refreshing {} shards.", (Object)bounds.size());
                        this.nextRefresh = (Instant)nextRefreshFn.get();
                        this.running.set(false);
                        this.shardBounds = bounds;
                    });
                }

                private @UnknownKeyFor @NonNull @Initialized BigInteger lowerHashKey(@UnknownKeyFor @NonNull @Initialized Shard shard) {
                    return new BigInteger(shard.hashKeyRange().startingHashKey());
                }
            }
        }

        @VisibleForTesting
        @NotThreadSafe
        static class PartitionKeyHasher {
            private final @UnknownKeyFor @NonNull @Initialized MessageDigest md5Digest = PartitionKeyHasher.md5Digest();

            PartitionKeyHasher() {
            }

            @UnknownKeyFor @NonNull @Initialized BigInteger hashKey(@UnknownKeyFor @NonNull @Initialized String partitionKey) {
                byte[] hashedBytes = this.md5Digest.digest(partitionKey.getBytes(StandardCharsets.UTF_8));
                this.md5Digest.reset();
                return new BigInteger(1, hashedBytes);
            }

            private static @UnknownKeyFor @NonNull @Initialized MessageDigest md5Digest() {
                try {
                    return MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        static class AggregatedWriter<@UnknownKeyFor T>
        extends Writer<T> {
            private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(AggregatedWriter.class);
            private static final @UnknownKeyFor @NonNull @Initialized ObjectPool<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ShardRanges> SHARD_RANGES_BY_STREAM = new ObjectPool<String, ShardRanges>(ShardRanges::of);
            private final @UnknownKeyFor @NonNull @Initialized RecordAggregation aggSpec;
            private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized BigInteger, @UnknownKeyFor @NonNull @Initialized RecordsAggregator> aggregators;
            private final @UnknownKeyFor @NonNull @Initialized PartitionKeyHasher pkHasher;
            private final @UnknownKeyFor @NonNull @Initialized ShardRanges shardRanges;

            AggregatedWriter(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized Write<T> spec, @UnknownKeyFor @NonNull @Initialized RecordAggregation aggSpec) {
                super(options, spec);
                this.aggSpec = aggSpec;
                this.aggregators = new LinkedHashMap<BigInteger, RecordsAggregator>();
                this.pkHasher = new PartitionKeyHasher();
                if (aggSpec.shardRefreshInterval().isLongerThan((ReadableDuration)Duration.ZERO) && !(spec.partitioner() instanceof KinesisPartitioner.ExplicitPartitioner)) {
                    this.shardRanges = SHARD_RANGES_BY_STREAM.retain(spec.streamName());
                    this.shardRanges.refreshPeriodically(this.kinesis, aggSpec::nextShardRefresh);
                } else {
                    this.shardRanges = ShardRanges.EMPTY;
                }
            }

            @Override
            public void startBundle() {
                super.startBundle();
                this.aggregators.clear();
            }

            @Override
            protected void write(@UnknownKeyFor @NonNull @Initialized String partitionKey, @Nullable @UnknownKeyFor @Initialized String explicitHashKey, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] data) throws @UnknownKeyFor @NonNull @Initialized Throwable {
                BigInteger aggKey;
                this.shardRanges.refreshPeriodically(this.kinesis, this.aggSpec::nextShardRefresh);
                if (explicitHashKey != null) {
                    aggKey = new BigInteger(explicitHashKey);
                } else {
                    BigInteger hashedPartitionKey = this.pkHasher.hashKey(partitionKey);
                    aggKey = this.shardRanges.shardAwareHashKey(hashedPartitionKey);
                    if (aggKey != null) {
                        explicitHashKey = aggKey.toString();
                    } else {
                        aggKey = hashedPartitionKey;
                    }
                }
                RecordsAggregator agg = this.aggregators.computeIfAbsent(aggKey, k -> this.newRecordsAggregator());
                if (!agg.addRecord(partitionKey, explicitHashKey, data)) {
                    this.addRequestEntry(agg.getAndReset(this.aggSpec.nextBufferTimeout()));
                    this.aggregators.remove(aggKey);
                    if (agg.addRecord(partitionKey, explicitHashKey, data)) {
                        this.aggregators.put(aggKey, agg);
                    } else {
                        super.write(partitionKey, explicitHashKey, data);
                    }
                } else if (!agg.hasCapacity()) {
                    this.addRequestEntry(agg.get());
                    this.aggregators.remove(aggKey);
                }
                if (this.handler.requestsInProgress() < this.spec.concurrentRequests() || Math.random() < 0.05) {
                    this.checkAggregationTimeouts();
                }
            }

            private @UnknownKeyFor @NonNull @Initialized RecordsAggregator newRecordsAggregator() {
                return new RecordsAggregator(Math.min(this.aggSpec.maxBytes(), this.spec.batchMaxBytes()), this.aggSpec.nextBufferTimeout());
            }

            private void checkAggregationTimeouts() throws @UnknownKeyFor @NonNull @Initialized Throwable {
                Map.Entry<BigInteger, RecordsAggregator> e;
                RecordsAggregator agg;
                Instant now = Instant.now();
                ArrayList<BigInteger> removals = new ArrayList<BigInteger>();
                Iterator<Map.Entry<BigInteger, RecordsAggregator>> iterator = this.aggregators.entrySet().iterator();
                while (iterator.hasNext() && !(agg = (e = iterator.next()).getValue()).timeout().isAfter((ReadableInstant)now)) {
                    long delayMillis = now.getMillis() - agg.timeout().getMillis();
                    LOG.debug("Adding aggregated entry after timeout [delay = {} ms]", (Object)delayMillis);
                    this.addRequestEntry(agg.get());
                    removals.add(e.getKey());
                }
                if (!removals.isEmpty()) {
                    this.aggregators.keySet().removeAll(removals);
                    this.asyncFlushEntries();
                }
            }

            @Override
            public void finishBundle() throws @UnknownKeyFor @NonNull @Initialized Throwable {
                for (RecordsAggregator aggregator : this.aggregators.values()) {
                    this.addRequestEntry(aggregator.get());
                }
                super.finishBundle();
            }

            @Override
            public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
                super.close();
                SHARD_RANGES_BY_STREAM.release(this.shardRanges);
            }
        }

        private static class Writer<@UnknownKeyFor T>
        implements AutoCloseable {
            private static final @UnknownKeyFor @NonNull @Initialized int PARTITION_KEY_MAX_LENGTH = 256;
            private static final @UnknownKeyFor @NonNull @Initialized int PARTITION_KEY_MIN_LENGTH = 1;
            private static final @UnknownKeyFor @NonNull @Initialized int PARTIAL_RETRIES = 10;
            private static final @UnknownKeyFor @NonNull @Initialized ObjectPool.ClientPool<@UnknownKeyFor @NonNull @Initialized KinesisAsyncClient> CLIENTS = ObjectPool.pooledClientFactory(KinesisAsyncClient.builder());
            protected final @UnknownKeyFor @NonNull @Initialized Write<T> spec;
            protected final @UnknownKeyFor @NonNull @Initialized Stats stats;
            protected final @UnknownKeyFor @NonNull @Initialized AsyncBatchWriteHandler<@UnknownKeyFor @NonNull @Initialized PutRecordsRequestEntry, @UnknownKeyFor @NonNull @Initialized PutRecordsResultEntry> handler;
            protected final @UnknownKeyFor @NonNull @Initialized KinesisAsyncClient kinesis;
            private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PutRecordsRequestEntry> requestEntries;
            private @UnknownKeyFor @NonNull @Initialized int requestBytes = 0;

            Writer(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized Write<T> spec) {
                ClientConfiguration clientConfig = spec.clientConfiguration();
                this.spec = spec;
                this.stats = new Stats();
                this.kinesis = CLIENTS.retain((AwsOptions)options.as(AwsOptions.class), clientConfig);
                this.requestEntries = new ArrayList<PutRecordsRequestEntry>();
                this.handler = AsyncBatchWriteHandler.byPosition(spec.concurrentRequests(), 10, clientConfig.retry(), this.stats, (stream, records) -> Writer.putRecords(this.kinesis, stream, records), r -> r.errorCode());
            }

            private static @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PutRecordsResultEntry>> putRecords(@UnknownKeyFor @NonNull @Initialized KinesisAsyncClient kinesis, @UnknownKeyFor @NonNull @Initialized String stream, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PutRecordsRequestEntry> records) {
                PutRecordsRequest req = (PutRecordsRequest)PutRecordsRequest.builder().streamName(stream).records(records).build();
                return kinesis.putRecords(req).thenApply(resp -> resp.records());
            }

            public void startBundle() {
                this.handler.reset();
                this.requestEntries.clear();
                this.requestBytes = 0;
            }

            public final void write(T record) throws @UnknownKeyFor @NonNull @Initialized Throwable {
                this.handler.checkForAsyncFailure();
                this.stats.addUserRecord();
                byte[] data = (byte[])this.spec.serializer().apply(record);
                String partitionKey = this.spec.partitioner().getPartitionKey(record);
                String hashKey = this.spec.partitioner().getExplicitHashKey(record);
                this.validatePartitionKey(partitionKey);
                if (hashKey != null) {
                    this.validateExplicitHashKey(hashKey);
                }
                this.write(partitionKey, hashKey, data);
                this.stats.logPeriodically();
            }

            protected void write(@UnknownKeyFor @NonNull @Initialized String partitionKey, @Nullable @UnknownKeyFor @Initialized String explicitHashKey, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] data) throws @UnknownKeyFor @NonNull @Initialized Throwable {
                PutRecordsRequestEntry.Builder entry = PutRecordsRequestEntry.builder().data(SdkBytes.fromByteArrayUnsafe((byte[])data)).partitionKey(partitionKey);
                if (explicitHashKey != null) {
                    entry.explicitHashKey(explicitHashKey);
                }
                this.addRequestEntry((PutRecordsRequestEntry)entry.build());
                if (!this.hasCapacityForEntry(0)) {
                    this.asyncFlushEntries();
                }
            }

            private @UnknownKeyFor @NonNull @Initialized int entrySizeBytes(@UnknownKeyFor @NonNull @Initialized PutRecordsRequestEntry e) {
                int bytes = e.partitionKey().getBytes(StandardCharsets.UTF_8).length + e.data().asByteArrayUnsafe().length;
                if (e.explicitHashKey() != null) {
                    bytes += e.explicitHashKey().getBytes(StandardCharsets.UTF_8).length;
                }
                return bytes;
            }

            protected @UnknownKeyFor @NonNull @Initialized boolean hasCapacityForEntry(@UnknownKeyFor @NonNull @Initialized int entryBytes) {
                return this.requestEntries.size() < this.spec.batchMaxRecords() && this.requestBytes + entryBytes <= this.spec.batchMaxBytes();
            }

            protected @UnknownKeyFor @NonNull @Initialized int getRequestEntriesCount() {
                return this.requestEntries.size();
            }

            protected final void addRequestEntry(@UnknownKeyFor @NonNull @Initialized PutRecordsRequestEntry entry) throws @UnknownKeyFor @NonNull @Initialized Throwable {
                int entryBytes = this.entrySizeBytes(entry);
                if (!this.hasCapacityForEntry(entryBytes)) {
                    this.asyncFlushEntries();
                }
                this.stats.addClientRecord(entryBytes);
                this.requestEntries.add(entry);
                this.requestBytes += entryBytes;
            }

            protected final void asyncFlushEntries() throws @UnknownKeyFor @NonNull @Initialized Throwable {
                if (!this.handler.hasErrored() && !this.requestEntries.isEmpty()) {
                    List<PutRecordsRequestEntry> recordsToWrite = this.requestEntries;
                    this.requestEntries = new ArrayList<PutRecordsRequestEntry>();
                    this.requestBytes = 0;
                    this.handler.batchWrite(this.spec.streamName(), recordsToWrite);
                }
            }

            public void finishBundle() throws @UnknownKeyFor @NonNull @Initialized Throwable {
                this.asyncFlushEntries();
                this.handler.waitForCompletion();
                this.stats.logPeriodically();
            }

            @Override
            public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
                CLIENTS.release(this.kinesis);
            }

            private void validatePartitionKey(@UnknownKeyFor @NonNull @Initialized String partitionKey) {
                int size = partitionKey != null ? partitionKey.length() : 0;
                Preconditions.checkState((1 <= size && size <= 256 ? 1 : 0) != 0, (String)"Invalid partition key of length {}", (int)size);
            }

            private void validateExplicitHashKey(@UnknownKeyFor @NonNull @Initialized String hashKey) {
                BigInteger key = new BigInteger(hashKey);
                Preconditions.checkState((key.compareTo(KinesisPartitioner.MIN_HASH_KEY) >= 0 && key.compareTo(KinesisPartitioner.MAX_HASH_KEY) <= 0 ? 1 : 0) != 0, (Object)"Explicit hash key must be 128-bit number.");
            }
        }

        public static class Result
        implements POutput {
            private final @UnknownKeyFor @NonNull @Initialized Pipeline pipeline;

            private Result(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
                this.pipeline = pipeline;
            }

            public @UnknownKeyFor @NonNull @Initialized Pipeline getPipeline() {
                return this.pipeline;
            }

            public /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> expand() {
                return ImmutableMap.of();
            }

            public void finishSpecifyingOutput(@UnknownKeyFor @NonNull @Initialized String transformName, @UnknownKeyFor @NonNull @Initialized PInput input, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
            }
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> streamName(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> batchMaxRecords(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> batchMaxBytes(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> concurrentRequests(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> partitioner(@UnknownKeyFor @NonNull @Initialized KinesisPartitioner<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> serializer(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> clientConfiguration(@UnknownKeyFor @NonNull @Initialized ClientConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> recordAggregation(@Nullable @UnknownKeyFor @Initialized RecordAggregation var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write<T> build();
        }
    }

    @AutoValue
    public static abstract class RecordAggregation
    implements Serializable {
        abstract @UnknownKeyFor @NonNull @Initialized int maxBytes();

        abstract @UnknownKeyFor @NonNull @Initialized Duration maxBufferedTime();

        abstract @UnknownKeyFor @NonNull @Initialized double maxBufferedTimeJitter();

        abstract @UnknownKeyFor @NonNull @Initialized Duration shardRefreshInterval();

        abstract @UnknownKeyFor @NonNull @Initialized double shardRefreshIntervalJitter();

        @UnknownKeyFor @NonNull @Initialized Instant nextBufferTimeout() {
            return this.nextInstant(this.maxBufferedTime(), this.maxBufferedTimeJitter());
        }

        @UnknownKeyFor @NonNull @Initialized Instant nextShardRefresh() {
            return this.nextInstant(this.shardRefreshInterval(), this.shardRefreshIntervalJitter());
        }

        private @UnknownKeyFor @NonNull @Initialized Instant nextInstant(@UnknownKeyFor @NonNull @Initialized Duration duration, @UnknownKeyFor @NonNull @Initialized double jitter) {
            double millis = (1.0 - jitter + jitter * Math.random()) * (double)duration.getMillis();
            return Instant.ofEpochMilli((long)(DateTimeUtils.currentTimeMillis() + (long)millis));
        }

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_KinesisIO_RecordAggregation.Builder().maxBytes(0x100000).maxBufferedTimeJitter(0.7).maxBufferedTime(Duration.millis((long)500L)).shardRefreshIntervalJitter(0.5).shardRefreshInterval(Duration.standardMinutes((long)2L));
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder maxBytes(@UnknownKeyFor @NonNull @Initialized int var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder maxBufferedTime(@UnknownKeyFor @NonNull @Initialized Duration var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder shardRefreshInterval(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder maxBufferedTimeJitter(@UnknownKeyFor @NonNull @Initialized double var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder shardRefreshIntervalJitter(@UnknownKeyFor @NonNull @Initialized double var1);

            abstract @UnknownKeyFor @NonNull @Initialized RecordAggregation autoBuild();

            public @UnknownKeyFor @NonNull @Initialized RecordAggregation build() {
                RecordAggregation agg = this.autoBuild();
                Preconditions.checkArgument((agg.maxBufferedTimeJitter() >= 0.0 && agg.maxBufferedTimeJitter() <= 1.0 ? 1 : 0) != 0);
                Preconditions.checkArgument((agg.maxBytes() > 0 && agg.maxBytes() <= 0x100000 ? 1 : 0) != 0, (String)"maxBytes must be positive and <= %s", (int)0x100000);
                return agg;
            }
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<KinesisRecord>> {
        private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 1L;

        abstract @Nullable @UnknownKeyFor @Initialized String getStreamName();

        abstract @Nullable @UnknownKeyFor @Initialized String getConsumerArn();

        abstract @Nullable @UnknownKeyFor @Initialized StartingPoint getInitialPosition();

        abstract @UnknownKeyFor @NonNull @Initialized ClientConfiguration getClientConfiguration();

        abstract @UnknownKeyFor @NonNull @Initialized long getMaxNumRecords();

        abstract @Nullable @UnknownKeyFor @Initialized Duration getMaxReadTime();

        abstract @UnknownKeyFor @NonNull @Initialized Duration getUpToDateThreshold();

        abstract @Nullable @UnknownKeyFor @Initialized Integer getRequestRecordsLimit();

        abstract @UnknownKeyFor @NonNull @Initialized WatermarkPolicyFactory getWatermarkPolicyFactory();

        abstract @UnknownKeyFor @NonNull @Initialized RateLimitPolicyFactory getRateLimitPolicyFactory();

        abstract @Nullable @UnknownKeyFor @Initialized Integer getMaxCapacityPerShard();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Read withStreamName(@UnknownKeyFor @NonNull @Initialized String streamName) {
            return this.toBuilder().setStreamName(streamName).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withConsumerArn(@UnknownKeyFor @NonNull @Initialized String consumerArn) {
            return this.toBuilder().setConsumerArn(consumerArn).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withInitialPositionInStream(@UnknownKeyFor @NonNull @Initialized InitialPositionInStream initialPosition) {
            return this.toBuilder().setInitialPosition(new StartingPoint(initialPosition)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withInitialTimestampInStream(@UnknownKeyFor @NonNull @Initialized Instant initialTimestamp) {
            return this.toBuilder().setInitialPosition(new StartingPoint(initialTimestamp)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withClientConfiguration(@UnknownKeyFor @NonNull @Initialized ClientConfiguration config) {
            Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"ClientConfiguration cannot be null");
            return this.toBuilder().setClientConfiguration(config).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withMaxNumRecords(@UnknownKeyFor @NonNull @Initialized long maxNumRecords) {
            Preconditions.checkArgument((maxNumRecords > 0L ? 1 : 0) != 0, (String)"maxNumRecords must be positive, but was: %s", (long)maxNumRecords);
            return this.toBuilder().setMaxNumRecords(maxNumRecords).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withMaxReadTime(@UnknownKeyFor @NonNull @Initialized Duration maxReadTime) {
            Preconditions.checkArgument((maxReadTime != null ? 1 : 0) != 0, (Object)"maxReadTime can not be null");
            return this.toBuilder().setMaxReadTime(maxReadTime).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withUpToDateThreshold(@UnknownKeyFor @NonNull @Initialized Duration upToDateThreshold) {
            Preconditions.checkArgument((upToDateThreshold != null ? 1 : 0) != 0, (Object)"upToDateThreshold can not be null");
            return this.toBuilder().setUpToDateThreshold(upToDateThreshold).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withRequestRecordsLimit(@UnknownKeyFor @NonNull @Initialized int limit) {
            Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (String)"limit must be positive, but was: %s", (int)limit);
            Preconditions.checkArgument((limit <= 10000 ? 1 : 0) != 0, (String)"limit must be up to 10,000, but was: %s", (int)limit);
            return this.toBuilder().setRequestRecordsLimit(limit).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withArrivalTimeWatermarkPolicy() {
            return this.toBuilder().setWatermarkPolicyFactory(WatermarkPolicyFactory.withArrivalTimePolicy()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withArrivalTimeWatermarkPolicy(@UnknownKeyFor @NonNull @Initialized Duration watermarkIdleDurationThreshold) {
            return this.toBuilder().setWatermarkPolicyFactory(WatermarkPolicyFactory.withArrivalTimePolicy(watermarkIdleDurationThreshold)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withProcessingTimeWatermarkPolicy() {
            return this.toBuilder().setWatermarkPolicyFactory(WatermarkPolicyFactory.withProcessingTimePolicy()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withCustomWatermarkPolicy(@UnknownKeyFor @NonNull @Initialized WatermarkPolicyFactory watermarkPolicyFactory) {
            Preconditions.checkArgument((watermarkPolicyFactory != null ? 1 : 0) != 0, (Object)"watermarkPolicyFactory cannot be null");
            return this.toBuilder().setWatermarkPolicyFactory(watermarkPolicyFactory).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withFixedDelayRateLimitPolicy() {
            return this.toBuilder().setRateLimitPolicyFactory(RateLimitPolicyFactory.withFixedDelay()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withFixedDelayRateLimitPolicy(@UnknownKeyFor @NonNull @Initialized Duration delay) {
            Preconditions.checkArgument((delay != null ? 1 : 0) != 0, (Object)"delay cannot be null");
            return this.toBuilder().setRateLimitPolicyFactory(RateLimitPolicyFactory.withFixedDelay(delay)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withDynamicDelayRateLimitPolicy(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Duration> delay) {
            Preconditions.checkArgument((delay != null ? 1 : 0) != 0, (Object)"delay cannot be null");
            return this.toBuilder().setRateLimitPolicyFactory(RateLimitPolicyFactory.withDelay(delay)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withCustomRateLimitPolicy(@UnknownKeyFor @NonNull @Initialized RateLimitPolicyFactory rateLimitPolicyFactory) {
            Preconditions.checkArgument((rateLimitPolicyFactory != null ? 1 : 0) != 0, (Object)"rateLimitPolicyFactory cannot be null");
            return this.toBuilder().setRateLimitPolicyFactory(rateLimitPolicyFactory).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withMaxCapacityPerShard(@UnknownKeyFor @NonNull @Initialized Integer maxCapacity) {
            Preconditions.checkArgument((maxCapacity > 0 ? 1 : 0) != 0, (String)"maxCapacity must be positive, but was: %s", (Object)maxCapacity);
            return this.toBuilder().setMaxCapacityPerShard(maxCapacity).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KinesisRecord> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            Read.Unbounded unbounded;
            Preconditions.checkArgument((this.getWatermarkPolicyFactory() != null ? 1 : 0) != 0, (Object)"WatermarkPolicyFactory is required");
            Preconditions.checkArgument((this.getRateLimitPolicyFactory() != null ? 1 : 0) != 0, (Object)"RateLimitPolicyFactory is required");
            AwsOptions awsOptions = (AwsOptions)input.getPipeline().getOptions().as(AwsOptions.class);
            ClientBuilderFactory.validate(awsOptions, this.getClientConfiguration());
            Read.Unbounded transform = unbounded = org.apache.beam.sdk.io.Read.from((UnboundedSource)new KinesisSource(this));
            if (this.getMaxNumRecords() < Long.MAX_VALUE || this.getMaxReadTime() != null) {
                transform = unbounded.withMaxReadTime(this.getMaxReadTime()).withMaxNumRecords(this.getMaxNumRecords());
            }
            return (PCollection)input.apply((PTransform)transform);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setStreamName(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setConsumerArn(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setInitialPosition(@UnknownKeyFor @NonNull @Initialized StartingPoint var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setClientConfiguration(@UnknownKeyFor @NonNull @Initialized ClientConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxNumRecords(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxReadTime(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setUpToDateThreshold(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setRequestRecordsLimit(@UnknownKeyFor @NonNull @Initialized Integer var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setWatermarkPolicyFactory(@UnknownKeyFor @NonNull @Initialized WatermarkPolicyFactory var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setRateLimitPolicyFactory(@UnknownKeyFor @NonNull @Initialized RateLimitPolicyFactory var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxCapacityPerShard(@UnknownKeyFor @NonNull @Initialized Integer var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read build();
        }
    }
}

