/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisRecord;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import software.amazon.kinesis.retrieval.KinesisClientRecord;

class GetKinesisRecordsResult {
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KinesisRecord> records;
    private final @UnknownKeyFor @NonNull @Initialized String nextShardIterator;
    private final @UnknownKeyFor @NonNull @Initialized long millisBehindLatest;

    public GetKinesisRecordsResult(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KinesisClientRecord> records, @UnknownKeyFor @NonNull @Initialized String nextShardIterator, @UnknownKeyFor @NonNull @Initialized long millisBehindLatest, @UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized String shardId) {
        this.records = records.stream().map(input -> {
            assert (input != null);
            return new KinesisRecord((KinesisClientRecord)input, streamName, shardId);
        }).collect(Collectors.toList());
        this.nextShardIterator = nextShardIterator;
        this.millisBehindLatest = millisBehindLatest;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KinesisRecord> getRecords() {
        return this.records;
    }

    public @UnknownKeyFor @NonNull @Initialized String getNextShardIterator() {
        return this.nextShardIterator;
    }

    public @UnknownKeyFor @NonNull @Initialized long getMillisBehindLatest() {
        return this.millisBehindLatest;
    }
}

