/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import org.apache.beam.sdk.io.aws2.common.ClientConfiguration;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisIO;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisPartitioner;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

final class AutoValue_KinesisIO_Write<T>
extends KinesisIO.Write<T> {
    private final String streamName;
    private final int batchMaxRecords;
    private final int batchMaxBytes;
    private final int concurrentRequests;
    private final KinesisPartitioner<T> partitioner;
    private final SerializableFunction<T, byte[]> serializer;
    private final ClientConfiguration clientConfiguration;
    private final @Nullable KinesisIO.RecordAggregation recordAggregation;

    private AutoValue_KinesisIO_Write(String streamName, int batchMaxRecords, int batchMaxBytes, int concurrentRequests, KinesisPartitioner<T> partitioner, SerializableFunction<T, byte[]> serializer, ClientConfiguration clientConfiguration, @Nullable KinesisIO.RecordAggregation recordAggregation) {
        this.streamName = streamName;
        this.batchMaxRecords = batchMaxRecords;
        this.batchMaxBytes = batchMaxBytes;
        this.concurrentRequests = concurrentRequests;
        this.partitioner = partitioner;
        this.serializer = serializer;
        this.clientConfiguration = clientConfiguration;
        this.recordAggregation = recordAggregation;
    }

    @Override
    @Pure
    String streamName() {
        return this.streamName;
    }

    @Override
    @Pure
    int batchMaxRecords() {
        return this.batchMaxRecords;
    }

    @Override
    @Pure
    int batchMaxBytes() {
        return this.batchMaxBytes;
    }

    @Override
    @Pure
    int concurrentRequests() {
        return this.concurrentRequests;
    }

    @Override
    @Pure
    KinesisPartitioner<T> partitioner() {
        return this.partitioner;
    }

    @Override
    @Pure
    SerializableFunction<T, byte[]> serializer() {
        return this.serializer;
    }

    @Override
    @Pure
    ClientConfiguration clientConfiguration() {
        return this.clientConfiguration;
    }

    @Override
    @Pure
    @Nullable KinesisIO.RecordAggregation recordAggregation() {
        return this.recordAggregation;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KinesisIO.Write) {
            KinesisIO.Write that = (KinesisIO.Write)((Object)o);
            return this.streamName.equals(that.streamName()) && this.batchMaxRecords == that.batchMaxRecords() && this.batchMaxBytes == that.batchMaxBytes() && this.concurrentRequests == that.concurrentRequests() && this.partitioner.equals(that.partitioner()) && this.serializer.equals(that.serializer()) && this.clientConfiguration.equals(that.clientConfiguration()) && (this.recordAggregation == null ? that.recordAggregation() == null : this.recordAggregation.equals(that.recordAggregation()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.streamName.hashCode();
        h$ *= 1000003;
        h$ ^= this.batchMaxRecords;
        h$ *= 1000003;
        h$ ^= this.batchMaxBytes;
        h$ *= 1000003;
        h$ ^= this.concurrentRequests;
        h$ *= 1000003;
        h$ ^= this.partitioner.hashCode();
        h$ *= 1000003;
        h$ ^= this.serializer.hashCode();
        h$ *= 1000003;
        h$ ^= this.clientConfiguration.hashCode();
        h$ *= 1000003;
        return h$ ^= this.recordAggregation == null ? 0 : this.recordAggregation.hashCode();
    }

    @Override
    KinesisIO.Write.Builder<T> builder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends KinesisIO.Write.Builder<T> {
        private String streamName;
        private Integer batchMaxRecords;
        private Integer batchMaxBytes;
        private Integer concurrentRequests;
        private KinesisPartitioner<T> partitioner;
        private SerializableFunction<T, byte[]> serializer;
        private ClientConfiguration clientConfiguration;
        private @Nullable KinesisIO.RecordAggregation recordAggregation;

        Builder() {
        }

        private Builder(KinesisIO.Write<T> source) {
            this.streamName = source.streamName();
            this.batchMaxRecords = source.batchMaxRecords();
            this.batchMaxBytes = source.batchMaxBytes();
            this.concurrentRequests = source.concurrentRequests();
            this.partitioner = source.partitioner();
            this.serializer = source.serializer();
            this.clientConfiguration = source.clientConfiguration();
            this.recordAggregation = source.recordAggregation();
        }

        @Override
        KinesisIO.Write.Builder<T> streamName(String streamName) {
            if (streamName == null) {
                throw new NullPointerException("Null streamName");
            }
            this.streamName = streamName;
            return this;
        }

        @Override
        KinesisIO.Write.Builder<T> batchMaxRecords(int batchMaxRecords) {
            this.batchMaxRecords = batchMaxRecords;
            return this;
        }

        @Override
        KinesisIO.Write.Builder<T> batchMaxBytes(int batchMaxBytes) {
            this.batchMaxBytes = batchMaxBytes;
            return this;
        }

        @Override
        KinesisIO.Write.Builder<T> concurrentRequests(int concurrentRequests) {
            this.concurrentRequests = concurrentRequests;
            return this;
        }

        @Override
        KinesisIO.Write.Builder<T> partitioner(KinesisPartitioner<T> partitioner) {
            if (partitioner == null) {
                throw new NullPointerException("Null partitioner");
            }
            this.partitioner = partitioner;
            return this;
        }

        @Override
        KinesisIO.Write.Builder<T> serializer(SerializableFunction<T, byte[]> serializer) {
            if (serializer == null) {
                throw new NullPointerException("Null serializer");
            }
            this.serializer = serializer;
            return this;
        }

        @Override
        KinesisIO.Write.Builder<T> clientConfiguration(ClientConfiguration clientConfiguration) {
            if (clientConfiguration == null) {
                throw new NullPointerException("Null clientConfiguration");
            }
            this.clientConfiguration = clientConfiguration;
            return this;
        }

        @Override
        KinesisIO.Write.Builder<T> recordAggregation(@Nullable KinesisIO.RecordAggregation recordAggregation) {
            this.recordAggregation = recordAggregation;
            return this;
        }

        @Override
        KinesisIO.Write<T> build() {
            if (this.streamName == null || this.batchMaxRecords == null || this.batchMaxBytes == null || this.concurrentRequests == null || this.partitioner == null || this.serializer == null || this.clientConfiguration == null) {
                StringBuilder missing = new StringBuilder();
                if (this.streamName == null) {
                    missing.append(" streamName");
                }
                if (this.batchMaxRecords == null) {
                    missing.append(" batchMaxRecords");
                }
                if (this.batchMaxBytes == null) {
                    missing.append(" batchMaxBytes");
                }
                if (this.concurrentRequests == null) {
                    missing.append(" concurrentRequests");
                }
                if (this.partitioner == null) {
                    missing.append(" partitioner");
                }
                if (this.serializer == null) {
                    missing.append(" serializer");
                }
                if (this.clientConfiguration == null) {
                    missing.append(" clientConfiguration");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_KinesisIO_Write(this.streamName, this.batchMaxRecords, this.batchMaxBytes, this.concurrentRequests, this.partitioner, this.serializer, this.clientConfiguration, this.recordAggregation);
        }
    }
}

