/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.dynamodb;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.aws2.common.ClientConfiguration;
import org.apache.beam.sdk.io.aws2.dynamodb.DynamoDBIO;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;

final class AutoValue_DynamoDBIO_Read<T>
extends DynamoDBIO.Read<T> {
    private final ClientConfiguration clientConfiguration;
    private final @Nullable SerializableFunction<Void, ScanRequest> scanRequestFn;
    private final @Nullable Integer segmentId;
    private final @Nullable SerializableFunction<ScanResponse, T> scanResponseMapperFn;
    private final @Nullable Coder<T> coder;

    private AutoValue_DynamoDBIO_Read(ClientConfiguration clientConfiguration, @Nullable SerializableFunction<Void, ScanRequest> scanRequestFn, @Nullable Integer segmentId, @Nullable SerializableFunction<ScanResponse, T> scanResponseMapperFn, @Nullable Coder<T> coder) {
        this.clientConfiguration = clientConfiguration;
        this.scanRequestFn = scanRequestFn;
        this.segmentId = segmentId;
        this.scanResponseMapperFn = scanResponseMapperFn;
        this.coder = coder;
    }

    @Override
    ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    @Override
    @Nullable SerializableFunction<Void, ScanRequest> getScanRequestFn() {
        return this.scanRequestFn;
    }

    @Override
    @Nullable Integer getSegmentId() {
        return this.segmentId;
    }

    @Override
    @Nullable SerializableFunction<ScanResponse, T> getScanResponseMapperFn() {
        return this.scanResponseMapperFn;
    }

    @Override
    @Nullable Coder<T> getCoder() {
        return this.coder;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DynamoDBIO.Read) {
            DynamoDBIO.Read that = (DynamoDBIO.Read)((Object)o);
            return this.clientConfiguration.equals(that.getClientConfiguration()) && (this.scanRequestFn == null ? that.getScanRequestFn() == null : this.scanRequestFn.equals(that.getScanRequestFn())) && (this.segmentId == null ? that.getSegmentId() == null : this.segmentId.equals(that.getSegmentId())) && (this.scanResponseMapperFn == null ? that.getScanResponseMapperFn() == null : this.scanResponseMapperFn.equals(that.getScanResponseMapperFn())) && (this.coder == null ? that.getCoder() == null : this.coder.equals(that.getCoder()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.clientConfiguration.hashCode();
        h$ *= 1000003;
        h$ ^= this.scanRequestFn == null ? 0 : this.scanRequestFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.segmentId == null ? 0 : this.segmentId.hashCode();
        h$ *= 1000003;
        h$ ^= this.scanResponseMapperFn == null ? 0 : this.scanResponseMapperFn.hashCode();
        h$ *= 1000003;
        return h$ ^= this.coder == null ? 0 : this.coder.hashCode();
    }

    @Override
    DynamoDBIO.Read.Builder<T> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends DynamoDBIO.Read.Builder<T> {
        private ClientConfiguration clientConfiguration;
        private @Nullable SerializableFunction<Void, ScanRequest> scanRequestFn;
        private @Nullable Integer segmentId;
        private @Nullable SerializableFunction<ScanResponse, T> scanResponseMapperFn;
        private @Nullable Coder<T> coder;

        Builder() {
        }

        private Builder(DynamoDBIO.Read<T> source) {
            this.clientConfiguration = source.getClientConfiguration();
            this.scanRequestFn = source.getScanRequestFn();
            this.segmentId = source.getSegmentId();
            this.scanResponseMapperFn = source.getScanResponseMapperFn();
            this.coder = source.getCoder();
        }

        @Override
        DynamoDBIO.Read.Builder<T> setClientConfiguration(ClientConfiguration clientConfiguration) {
            if (clientConfiguration == null) {
                throw new NullPointerException("Null clientConfiguration");
            }
            this.clientConfiguration = clientConfiguration;
            return this;
        }

        @Override
        DynamoDBIO.Read.Builder<T> setScanRequestFn(SerializableFunction<Void, ScanRequest> scanRequestFn) {
            this.scanRequestFn = scanRequestFn;
            return this;
        }

        @Override
        DynamoDBIO.Read.Builder<T> setSegmentId(Integer segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        @Override
        DynamoDBIO.Read.Builder<T> setScanResponseMapperFn(SerializableFunction<ScanResponse, T> scanResponseMapperFn) {
            this.scanResponseMapperFn = scanResponseMapperFn;
            return this;
        }

        @Override
        DynamoDBIO.Read.Builder<T> setCoder(Coder<T> coder) {
            this.coder = coder;
            return this;
        }

        @Override
        DynamoDBIO.Read<T> build() {
            if (this.clientConfiguration == null) {
                String missing = " clientConfiguration";
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_DynamoDBIO_Read(this.clientConfiguration, this.scanRequestFn, this.segmentId, this.scanResponseMapperFn, this.coder);
        }
    }
}

