/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.util.StdConverter;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.aws2.common.AutoValue_RetryConfiguration;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.EqualJitterBackoffStrategy;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class RetryConfiguration
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized java.time.Duration BASE_BACKOFF = java.time.Duration.ofMillis(100L);
    private static final @UnknownKeyFor @NonNull @Initialized java.time.Duration THROTTLED_BASE_BACKOFF = java.time.Duration.ofSeconds(1L);
    private static final @UnknownKeyFor @NonNull @Initialized java.time.Duration MAX_BACKOFF = java.time.Duration.ofSeconds(20L);

    @JsonProperty
    @Pure
    public abstract @UnknownKeyFor @NonNull @Initialized int numRetries();

    @JsonProperty
    @JsonSerialize(converter=DurationToMillis.class)
    @Nullable
    @Pure
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Duration baseBackoff();

    @JsonProperty
    @JsonSerialize(converter=DurationToMillis.class)
    @Nullable
    @Pure
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Duration throttledBaseBackoff();

    @JsonProperty
    @JsonSerialize(converter=DurationToMillis.class)
    @Nullable
    @Pure
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Duration maxBackoff();

    public abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return Builder.builder().numRetries(3);
    }

    @UnknownKeyFor @NonNull @Initialized RetryPolicy toClientRetryPolicy() {
        if (this.numRetries() == 0) {
            return RetryPolicy.none();
        }
        RetryPolicy.Builder builder = RetryPolicy.builder().numRetries(Integer.valueOf(this.numRetries()));
        java.time.Duration base = RetryConfiguration.toJava(this.baseBackoff());
        java.time.Duration throttledBase = RetryConfiguration.toJava(this.throttledBaseBackoff());
        java.time.Duration max = RetryConfiguration.toJava(this.maxBackoff());
        if (base != null || max != null) {
            builder.backoffStrategy((BackoffStrategy)EqualJitterBackoffStrategy.builder().baseDelay(base != null ? base : BASE_BACKOFF).maxBackoffTime(max != null ? max : MAX_BACKOFF).build());
        }
        if (this.throttledBaseBackoff() != null || this.maxBackoff() != null) {
            builder.throttlingBackoffStrategy((BackoffStrategy)EqualJitterBackoffStrategy.builder().baseDelay(throttledBase != null ? throttledBase : THROTTLED_BASE_BACKOFF).maxBackoffTime(max != null ? max : MAX_BACKOFF).build());
        }
        return builder.build();
    }

    @Nullable
    private static @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized java.time.Duration toJava(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Duration duration) {
        return duration == null ? null : java.time.Duration.ofMillis(duration.getMillis());
    }

    static class MillisToDuration
    extends StdConverter<Long, Duration> {
        MillisToDuration() {
        }

        public @UnknownKeyFor @NonNull @Initialized Duration convert(@UnknownKeyFor @NonNull @Initialized Long millis) {
            return Duration.millis((long)millis);
        }
    }

    static class DurationToMillis
    extends StdConverter<Duration, Long> {
        DurationToMillis() {
        }

        public @UnknownKeyFor @NonNull @Initialized Long convert(@UnknownKeyFor @NonNull @Initialized Duration duration) {
            return duration.getMillis();
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_RetryConfiguration.Builder();
        }

        public abstract @UnknownKeyFor @NonNull @Initialized Builder numRetries(@UnknownKeyFor @NonNull @Initialized int var1);

        @JsonDeserialize(converter=MillisToDuration.class)
        public abstract @UnknownKeyFor @NonNull @Initialized Builder baseBackoff(@UnknownKeyFor @NonNull @Initialized Duration var1);

        @JsonDeserialize(converter=MillisToDuration.class)
        public abstract @UnknownKeyFor @NonNull @Initialized Builder throttledBaseBackoff(@UnknownKeyFor @NonNull @Initialized Duration var1);

        @JsonDeserialize(converter=MillisToDuration.class)
        public abstract @UnknownKeyFor @NonNull @Initialized Builder maxBackoff(@UnknownKeyFor @NonNull @Initialized Duration var1);

        abstract @UnknownKeyFor @NonNull @Initialized RetryConfiguration autoBuild();

        public @UnknownKeyFor @NonNull @Initialized RetryConfiguration build() {
            RetryConfiguration config = this.autoBuild();
            Duration baseBackoff = config.baseBackoff();
            Duration throttledBaseBackoff = config.throttledBaseBackoff();
            Duration maxBackoff = config.maxBackoff();
            Preconditions.checkArgument((config.numRetries() >= 0 ? 1 : 0) != 0, (Object)"numRetries must not be negative");
            Preconditions.checkArgument((baseBackoff == null || baseBackoff.isLongerThan((ReadableDuration)Duration.ZERO) ? 1 : 0) != 0, (Object)"baseBackoff must be greater than 0");
            Preconditions.checkArgument((throttledBaseBackoff == null || throttledBaseBackoff.isLongerThan((ReadableDuration)Duration.ZERO) ? 1 : 0) != 0, (Object)"throttledBaseBackoff must be greater than 0");
            Preconditions.checkArgument((maxBackoff == null || maxBackoff.isLongerThan((ReadableDuration)Duration.ZERO) ? 1 : 0) != 0, (Object)"maxBackoff must be greater than 0");
            return config;
        }
    }
}

