/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.common;

import java.io.Serializable;
import java.net.URI;
import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.aws2.common.ClientConfiguration;
import org.apache.beam.sdk.io.aws2.common.HttpClientConfiguration;
import org.apache.beam.sdk.io.aws2.options.AwsOptions;
import org.apache.beam.sdk.util.InstanceBuilder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.core.client.builder.SdkAsyncClientBuilder;
import software.amazon.awssdk.core.client.builder.SdkSyncClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.regions.Region;

public interface ClientBuilderFactory {
    default public <BuilderT extends AwsClientBuilder<BuilderT, ClientT>, ClientT> BuilderT create(BuilderT builder, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized AwsOptions defaults) {
        return this.create(builder, ClientConfiguration.builder().build(), defaults);
    }

    public <BuilderT extends AwsClientBuilder<BuilderT, ClientT>, ClientT> BuilderT create(BuilderT var1, @UnknownKeyFor @NonNull @Initialized ClientConfiguration var2, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized AwsOptions var3);

    public void checkConfiguration(@UnknownKeyFor @NonNull @Initialized ClientConfiguration var1, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized AwsOptions var2);

    public static @UnknownKeyFor @NonNull @Initialized ClientBuilderFactory defaultFactory() {
        return DefaultClientBuilder.INSTANCE;
    }

    public static @UnknownKeyFor @NonNull @Initialized ClientBuilderFactory getFactory(@UnknownKeyFor @NonNull @Initialized AwsOptions options) {
        if (options.getClientBuilderFactory().equals(DefaultClientBuilder.class)) {
            return ClientBuilderFactory.defaultFactory();
        }
        return (ClientBuilderFactory)InstanceBuilder.ofType(ClientBuilderFactory.class).fromClass(options.getClientBuilderFactory()).build();
    }

    public static void validate(@UnknownKeyFor @NonNull @Initialized AwsOptions options, @UnknownKeyFor @NonNull @Initialized ClientConfiguration config) {
        Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"AwsOptions cannot be null");
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"ClientConfiguration cannot be null");
        ClientBuilderFactory.getFactory(options).checkConfiguration(config, options);
    }

    public static <BuilderT extends AwsClientBuilder<BuilderT, ClientT>, ClientT> ClientT buildClient(@UnknownKeyFor @NonNull @Initialized AwsOptions options, BuilderT builder, @UnknownKeyFor @NonNull @Initialized ClientConfiguration config) {
        Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"AwsOptions cannot be null");
        Preconditions.checkArgument((builder != null ? 1 : 0) != 0, (Object)"AwsClientBuilder cannot be null");
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"ClientConfiguration cannot be null");
        return (ClientT)ClientBuilderFactory.getFactory(options).create(builder, config, options).build();
    }

    public static class DefaultClientBuilder
    implements ClientBuilderFactory,
    Serializable {
        private static final @UnknownKeyFor @NonNull @Initialized ClientBuilderFactory INSTANCE = new DefaultClientBuilder();

        DefaultClientBuilder() {
        }

        @Override
        public void checkConfiguration(@UnknownKeyFor @NonNull @Initialized ClientConfiguration config, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized AwsOptions options) {
            Region region = this.valueOrElse(config.region(), options, AwsOptions::getAwsRegion);
            AwsCredentialsProvider credentials = this.valueOrElse(config.credentialsProvider(), options, AwsOptions::getAwsCredentialsProvider);
            Preconditions.checkState((region != null ? 1 : 0) != 0, (Object)"No AWS region available");
            Preconditions.checkState((credentials != null && credentials.resolveCredentials() != null ? 1 : 0) != 0, (Object)"No AWS credentials provider available");
        }

        @Override
        public <BuilderT extends AwsClientBuilder<BuilderT, ClientT>, ClientT> BuilderT create(BuilderT builder, @UnknownKeyFor @NonNull @Initialized ClientConfiguration config, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized AwsOptions options) {
            Preconditions.checkNotNull((Object)config, (Object)"ClientConfiguration cannot be null!");
            Region region = this.valueOrElse(config.region(), options, AwsOptions::getAwsRegion);
            AwsCredentialsProvider credentials = this.valueOrElse(config.credentialsProvider(), options, AwsOptions::getAwsCredentialsProvider);
            URI endpoint = this.valueOrElse(config.endpoint(), options, AwsOptions::getEndpoint);
            this.setOptional(credentials, arg_0 -> builder.credentialsProvider(arg_0));
            this.setOptional(region, arg_0 -> builder.region(arg_0));
            this.setOptional(endpoint, arg_0 -> builder.endpointOverride(arg_0));
            if (config.retry() != null) {
                RetryPolicy retryPolicy = config.retry().toClientRetryPolicy();
                builder.overrideConfiguration((ClientOverrideConfiguration)ClientOverrideConfiguration.builder().retryPolicy(retryPolicy).build());
            }
            if (options == null) {
                return builder;
            }
            HttpClientConfiguration httpConfig = options.getHttpClientConfiguration();
            ProxyConfiguration proxyConfig = options.getProxyConfiguration();
            if (proxyConfig != null || httpConfig != null) {
                if (builder instanceof SdkSyncClientBuilder) {
                    ApacheHttpClient.Builder client = this.syncClientBuilder();
                    this.setOptional(proxyConfig, arg_0 -> ((ApacheHttpClient.Builder)client).proxyConfiguration(arg_0));
                    if (httpConfig != null) {
                        this.setOptional(httpConfig.connectionAcquisitionTimeout(), arg_0 -> ((ApacheHttpClient.Builder)client).connectionAcquisitionTimeout(arg_0));
                        this.setOptional(httpConfig.connectionMaxIdleTime(), arg_0 -> ((ApacheHttpClient.Builder)client).connectionMaxIdleTime(arg_0));
                        this.setOptional(httpConfig.connectionTimeout(), arg_0 -> ((ApacheHttpClient.Builder)client).connectionTimeout(arg_0));
                        this.setOptional(httpConfig.connectionTimeToLive(), arg_0 -> ((ApacheHttpClient.Builder)client).connectionTimeToLive(arg_0));
                        this.setOptional(httpConfig.socketTimeout(), arg_0 -> ((ApacheHttpClient.Builder)client).socketTimeout(arg_0));
                        this.setOptional((Object)httpConfig.maxConnections(), arg_0 -> ((ApacheHttpClient.Builder)client).maxConnections(arg_0));
                    }
                    ((SdkSyncClientBuilder)builder).httpClientBuilder((SdkHttpClient.Builder)client);
                } else if (builder instanceof SdkAsyncClientBuilder) {
                    NettyNioAsyncHttpClient.Builder client = this.asyncClientBuilder();
                    if (proxyConfig != null) {
                        client.proxyConfiguration(this.nettyProxyConfig(proxyConfig));
                    }
                    if (httpConfig != null) {
                        this.setOptional(httpConfig.connectionAcquisitionTimeout(), arg_0 -> ((NettyNioAsyncHttpClient.Builder)client).connectionAcquisitionTimeout(arg_0));
                        this.setOptional(httpConfig.connectionMaxIdleTime(), arg_0 -> ((NettyNioAsyncHttpClient.Builder)client).connectionMaxIdleTime(arg_0));
                        this.setOptional(httpConfig.connectionTimeout(), arg_0 -> ((NettyNioAsyncHttpClient.Builder)client).connectionTimeout(arg_0));
                        this.setOptional(httpConfig.connectionTimeToLive(), arg_0 -> ((NettyNioAsyncHttpClient.Builder)client).connectionTimeToLive(arg_0));
                        this.setOptional(httpConfig.socketTimeout(), arg_0 -> ((NettyNioAsyncHttpClient.Builder)client).readTimeout(arg_0));
                        this.setOptional(httpConfig.readTimeout(), arg_0 -> ((NettyNioAsyncHttpClient.Builder)client).readTimeout(arg_0));
                        this.setOptional(httpConfig.socketTimeout(), arg_0 -> ((NettyNioAsyncHttpClient.Builder)client).writeTimeout(arg_0));
                        this.setOptional(httpConfig.writeTimeout(), arg_0 -> ((NettyNioAsyncHttpClient.Builder)client).writeTimeout(arg_0));
                        this.setOptional((Object)httpConfig.maxConnections(), arg_0 -> ((NettyNioAsyncHttpClient.Builder)client).maxConcurrency(arg_0));
                    }
                    ((SdkAsyncClientBuilder)builder).httpClientBuilder((SdkAsyncHttpClient.Builder)client);
                }
            }
            return builder;
        }

        @VisibleForTesting
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ApacheHttpClient.Builder syncClientBuilder() {
            return ApacheHttpClient.builder();
        }

        @VisibleForTesting
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized NettyNioAsyncHttpClient.Builder asyncClientBuilder() {
            return NettyNioAsyncHttpClient.builder();
        }

        private @UnknownKeyFor @NonNull @Initialized software.amazon.awssdk.http.nio.netty.ProxyConfiguration nettyProxyConfig(@UnknownKeyFor @NonNull @Initialized ProxyConfiguration proxyConfig) {
            return (software.amazon.awssdk.http.nio.netty.ProxyConfiguration)software.amazon.awssdk.http.nio.netty.ProxyConfiguration.builder().host(proxyConfig.host()).port(proxyConfig.port()).scheme(proxyConfig.scheme()).username(proxyConfig.username()).password(proxyConfig.password()).nonProxyHosts(proxyConfig.nonProxyHosts()).build();
        }

        @Nullable
        private <T, X> @org.checkerframework.checker.nullness.qual.Nullable T valueOrElse(@Nullable @org.checkerframework.checker.nullness.qual.Nullable T value, @Nullable @org.checkerframework.checker.nullness.qual.Nullable X other, @UnknownKeyFor @NonNull @Initialized Function<X, T> transform) {
            return (T)(value != null ? value : (other != null ? transform.apply(other) : null));
        }

        private <T> void setOptional(@Nullable @org.checkerframework.checker.nullness.qual.Nullable T t, @UnknownKeyFor @NonNull @Initialized Consumer<T> setter) {
            if (t != null) {
                setter.accept(t);
            }
        }

        private void setOptional(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Integer millis, @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized Duration> setter) {
            if (millis != null) {
                setter.accept(Duration.ofMillis(millis.intValue()));
            }
        }
    }
}

