/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sqs;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.sdk.io.aws2.MockClientBuilderFactory;
import org.apache.beam.sdk.io.aws2.sqs.SqsIO;
import org.apache.beam.sdk.io.aws2.sqs.SqsMessage;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesResponse;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;

@RunWith(value=MockitoJUnitRunner.class)
public class SqsIOReadTest {
    @Rule
    public TestPipeline p = TestPipeline.create();
    @Mock
    public SqsClient sqs;

    @Before
    public void configureClientBuilderFactory() {
        MockClientBuilderFactory.set(this.p, SqsClientBuilder.class, this.sqs);
        Mockito.when((Object)this.sqs.getQueueAttributes((Consumer)ArgumentMatchers.any(Consumer.class))).thenReturn((Object)((GetQueueAttributesResponse)GetQueueAttributesResponse.builder().attributes((Map)ImmutableMap.of((Object)QueueAttributeName.VISIBILITY_TIMEOUT, (Object)"600")).build()));
    }

    @Test
    public void testReadOnce() {
        List expected = IntStream.range(0, 10).mapToObj(this::message).collect(Collectors.toList());
        Mockito.when((Object)this.sqs.receiveMessage((ReceiveMessageRequest)ArgumentMatchers.any(ReceiveMessageRequest.class))).thenReturn((Object)((ReceiveMessageResponse)ReceiveMessageResponse.builder().messages(expected).build()), (Object[])new ReceiveMessageResponse[]{(ReceiveMessageResponse)ReceiveMessageResponse.builder().build()});
        ArgumentCaptor deleteReq = ArgumentCaptor.forClass(DeleteMessageBatchRequest.class);
        Mockito.when((Object)this.sqs.deleteMessageBatch((DeleteMessageBatchRequest)deleteReq.capture())).thenReturn((Object)((DeleteMessageBatchResponse)DeleteMessageBatchResponse.builder().build()));
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)SqsIO.read().withMaxNumRecords((long)expected.size()))).apply((PTransform)ParDo.of((DoFn)new ToMessage()));
        PAssert.that((PCollection)result).containsInAnyOrder(expected);
        this.p.run();
        List deletedHandles = deleteReq.getAllValues().stream().flatMap(b -> b.entries().stream()).map(r -> r.receiptHandle()).collect(Collectors.toList());
        Assertions.assertThat(deletedHandles).containsExactlyInAnyOrderElementsOf((Iterable)Lists.transform(expected, Message::receiptHandle));
    }

    private Message message(int i) {
        return (Message)Message.builder().messageId("id" + i).body("body" + i).receiptHandle("handle" + i).attributes((Map)ImmutableMap.of((Object)MessageSystemAttributeName.SENT_TIMESTAMP, (Object)Integer.toString(i))).build();
    }

    static class ToMessage
    extends DoFn<SqsMessage, Message> {
        ToMessage() {
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element SqsMessage msg, DoFn.OutputReceiver<Message> out) {
            out.output((Object)((Message)Message.builder().messageId(msg.getMessageId()).body(msg.getBody()).receiptHandle(msg.getReceiptHandle()).attributes((Map)ImmutableMap.of((Object)MessageSystemAttributeName.SENT_TIMESTAMP, (Object)Long.toString(msg.getTimeStamp()))).build()));
        }
    }
}

