/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sqs;

import java.net.URI;
import org.apache.commons.lang3.RandomStringUtils;
import org.elasticmq.rest.sqs.SQSRestServer;
import org.elasticmq.rest.sqs.SQSRestServerBuilder;
import org.junit.rules.ExternalResource;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;

class EmbeddedSqsServer
extends ExternalResource {
    private SQSRestServer sqsRestServer;
    private URI endpoint;

    EmbeddedSqsServer() {
    }

    protected void before() {
        this.sqsRestServer = SQSRestServerBuilder.withDynamicPort().start();
        int port = this.sqsRestServer.waitUntilStarted().localAddress().getPort();
        this.endpoint = URI.create(String.format("http://localhost:%d", port));
    }

    protected void after() {
        this.sqsRestServer.stopAndWait();
    }

    public static class TestCaseEnv
    extends ExternalResource {
        private final EmbeddedSqsServer sqsServer;
        private SqsClient client;
        private String queueUrl;

        public TestCaseEnv(EmbeddedSqsServer sqsServer) {
            this.sqsServer = sqsServer;
        }

        protected void before() throws Throwable {
            this.client = (SqsClient)((SqsClientBuilder)((SqsClientBuilder)((SqsClientBuilder)SqsClient.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)"x", (String)"x")))).endpointOverride(this.sqsServer.endpoint)).region(Region.US_WEST_2)).build();
            this.queueUrl = this.client.createQueue(b -> b.queueName(RandomStringUtils.randomAlphanumeric((int)5))).queueUrl();
        }

        protected void after() {
            this.client.close();
        }

        public SqsClient getClient() {
            return this.client;
        }

        public String getQueueUrl() {
            return this.queueUrl;
        }
    }
}

