/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sns;

import java.io.Serializable;
import java.util.function.Consumer;
import org.apache.beam.sdk.io.aws2.MockClientBuilderFactory;
import org.apache.beam.sdk.io.aws2.sns.SnsIO;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.SnsClientBuilder;
import software.amazon.awssdk.services.sns.model.InvalidParameterException;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.services.sns.model.PublishResponse;

@RunWith(value=MockitoJUnitRunner.class)
public class SnsIOTest
implements Serializable {
    private static final String topicArn = "arn:aws:sns:us-west-2:5880:topic-FMFEHJ47NRFO";
    @Rule
    public TestPipeline p = TestPipeline.create();
    @Mock
    public SnsClient sns;

    @Before
    public void configureClientBuilderFactory() {
        MockClientBuilderFactory.set(this.p, SnsClientBuilder.class, this.sns);
    }

    @Test
    public void testFailOnTopicValidation() {
        PCollection input = (PCollection)Mockito.mock(PCollection.class);
        Mockito.when((Object)input.getPipeline()).thenReturn((Object)this.p);
        Mockito.when((Object)this.sns.getTopicAttributes((Consumer)ArgumentMatchers.any(Consumer.class))).thenThrow(new Throwable[]{(Throwable)InvalidParameterException.builder().message("Topic does not exist").build()});
        SnsIO.Write snsWrite = SnsIO.write().withTopicArn(topicArn).withPublishRequestBuilder((SerializableFunction & Serializable)msg -> SnsIOTest.requestBuilder(msg, "ignore"));
        Assertions.assertThatThrownBy(() -> snsWrite.expand(input)).hasMessage("Topic arn arn:aws:sns:us-west-2:5880:topic-FMFEHJ47NRFO does not exist");
    }

    @Test
    public void testSkipTopicValidation() {
        PCollection input = (PCollection)Mockito.mock(PCollection.class);
        Mockito.when((Object)input.getPipeline()).thenReturn((Object)this.p);
        Mockito.when((Object)input.apply((PTransform)ArgumentMatchers.any(PTransform.class))).thenReturn((Object)((POutput)Mockito.mock(PCollection.class)));
        SnsIO.Write snsWrite = SnsIO.write().withPublishRequestBuilder((SerializableFunction & Serializable)msg -> SnsIOTest.requestBuilder(msg, topicArn));
        snsWrite.expand(input);
        ((SnsClient)Mockito.verify((Object)this.sns, (VerificationMode)Mockito.times((int)0))).getTopicAttributes((Consumer)ArgumentMatchers.any(Consumer.class));
    }

    @Test
    public void testWriteWithTopicArn() {
        ImmutableList input = ImmutableList.of((Object)"message1", (Object)"message2");
        Mockito.when((Object)this.sns.publish((PublishRequest)ArgumentMatchers.any(PublishRequest.class))).thenReturn((Object)((PublishResponse)PublishResponse.builder().messageId("id").build()));
        SnsIO.Write snsWrite = SnsIO.write().withTopicArn(topicArn).withPublishRequestBuilder((SerializableFunction & Serializable)msg -> SnsIOTest.requestBuilder(msg, "ignore"));
        PCollection results = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Iterable)input))).apply((PTransform)snsWrite);
        PAssert.that((PCollection)((PCollection)results.apply(Count.globally()))).containsInAnyOrder((Object[])new Long[]{2L});
        this.p.run();
        ((SnsClient)Mockito.verify((Object)this.sns)).getTopicAttributes((Consumer)ArgumentMatchers.any(Consumer.class));
        for (String msg2 : input) {
            ((SnsClient)Mockito.verify((Object)this.sns)).publish((PublishRequest)SnsIOTest.requestBuilder(msg2, topicArn).build());
        }
    }

    @Test
    public void testWriteWithoutTopicArn() {
        ImmutableList input = ImmutableList.of((Object)"message1", (Object)"message2");
        Mockito.when((Object)this.sns.publish((PublishRequest)ArgumentMatchers.any(PublishRequest.class))).thenReturn((Object)((PublishResponse)PublishResponse.builder().messageId("id").build()));
        SnsIO.Write snsWrite = SnsIO.write().withPublishRequestBuilder((SerializableFunction & Serializable)msg -> SnsIOTest.requestBuilder(msg, topicArn));
        PCollection results = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Iterable)input))).apply((PTransform)snsWrite);
        PAssert.that((PCollection)((PCollection)results.apply(Count.globally()))).containsInAnyOrder((Object[])new Long[]{2L});
        this.p.run();
        ((SnsClient)Mockito.verify((Object)this.sns, (VerificationMode)Mockito.times((int)0))).getTopicAttributes((Consumer)ArgumentMatchers.any(Consumer.class));
        for (String msg2 : input) {
            ((SnsClient)Mockito.verify((Object)this.sns)).publish((PublishRequest)SnsIOTest.requestBuilder(msg2, topicArn).build());
        }
    }

    private static PublishRequest.Builder requestBuilder(String msg, String topic) {
        return PublishRequest.builder().message(msg).topicArn(topic);
    }
}

