/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.schemas;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.builder.SdkBuilder;

public class Sample
implements SdkPojo,
Serializable {
    private static final SdkField<String> STRING_F = Sample.sdkField(MarshallingType.STRING, "String", Sample::stringField, Builder::stringField).build();
    private static final SdkField<Short> SHORT_F = Sample.sdkField(MarshallingType.SHORT, "Short", Sample::shortField, Builder::shortField).build();
    private static final SdkField<Integer> INTEGER_F = Sample.sdkField(MarshallingType.INTEGER, "Integer", Sample::integerField, Builder::integerField).build();
    private static final SdkField<Long> LONG_F = Sample.sdkField(MarshallingType.LONG, "Long", Sample::longField, Builder::longField).build();
    private static final SdkField<Float> FLOAT_F = Sample.sdkField(MarshallingType.FLOAT, "Float", Sample::floatField, Builder::floatField).build();
    private static final SdkField<Double> DOUBLE_F = Sample.sdkField(MarshallingType.DOUBLE, "Double", Sample::doubleField, Builder::doubleField).build();
    private static final SdkField<BigDecimal> DECIMAL_F = Sample.sdkField(MarshallingType.BIG_DECIMAL, "Decimal", Sample::decimalField, Builder::decimalField).build();
    private static final SdkField<Boolean> BOOLEAN_F = Sample.sdkField(MarshallingType.BOOLEAN, "Boolean", Sample::booleanField, Builder::booleanField).build();
    private static final SdkField<Instant> INSTANT_F = Sample.sdkField(MarshallingType.INSTANT, "Instant", Sample::instantField, Builder::instantField).build();
    private static final SdkField<SdkBytes> BYTES_F = Sample.sdkField(MarshallingType.SDK_BYTES, "Bytes", Sample::bytesField, Builder::bytesField).build();
    private static final SdkField<List<String>> LIST_F = Sample.sdkField(MarshallingType.LIST, "List", Sample::listField, Builder::listField).traits(new Trait[]{ListTrait.builder().memberFieldInfo(Sample.sdkField(MarshallingType.STRING).build()).build()}).build();
    private static final SdkField<Map<String, String>> MAP_F = Sample.sdkField(MarshallingType.MAP, "Map", Sample::mapField, Builder::mapField).traits(new Trait[]{MapTrait.builder().valueFieldInfo(Sample.sdkField(MarshallingType.STRING).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = ImmutableList.of(STRING_F, SHORT_F, INTEGER_F, LONG_F, FLOAT_F, DOUBLE_F, DECIMAL_F, BOOLEAN_F, INSTANT_F, BYTES_F, LIST_F, MAP_F, (Object[])new SdkField[0]);
    private final String stringField;
    private final Short shortField;
    private final Integer integerField;
    private final Long longField;
    private final Float floatField;
    private final Double doubleField;
    private final BigDecimal decimalField;
    private final Boolean booleanField;
    private final Instant instantField;
    private final SdkBytes bytesField;
    private final List<String> listField;
    private final Map<String, String> mapField;

    private static <T> SdkField.Builder<T> sdkField(MarshallingType<T> type) {
        return SdkField.builder(type).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).build()});
    }

    private static <T> SdkField.Builder<T> sdkField(MarshallingType<? super T> type, String name, Function<Sample, T> g, BiConsumer<Builder, T> s) {
        return Sample.sdkField(type).memberName(name).getter(obj -> g.apply((Sample)obj)).setter((obj, val) -> s.accept((Builder)obj, val));
    }

    private Sample(BuilderImpl builder) {
        this.stringField = builder.stringField;
        this.shortField = builder.shortField;
        this.integerField = builder.integerField;
        this.longField = builder.longField;
        this.floatField = builder.floatField;
        this.doubleField = builder.doubleField;
        this.decimalField = builder.decimalField;
        this.booleanField = builder.booleanField;
        this.instantField = builder.instantField;
        this.bytesField = builder.bytesField;
        this.listField = builder.listField;
        this.mapField = builder.mapField;
    }

    public final String stringField() {
        return this.stringField;
    }

    public final Short shortField() {
        return this.shortField;
    }

    public final Integer integerField() {
        return this.integerField;
    }

    public final Long longField() {
        return this.longField;
    }

    public final Float floatField() {
        return this.floatField;
    }

    public final Double doubleField() {
        return this.doubleField;
    }

    public final BigDecimal decimalField() {
        return this.decimalField;
    }

    public final Boolean booleanField() {
        return this.booleanField;
    }

    public final Instant instantField() {
        return this.instantField;
    }

    public final SdkBytes bytesField() {
        return this.bytesField;
    }

    public final List<String> listField() {
        return this.listField;
    }

    public final Map<String, String> mapField() {
        return this.mapField;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public final int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public final boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public final String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    static final class BuilderImpl
    implements Builder {
        private String stringField;
        private Short shortField;
        private Integer integerField;
        private Long longField;
        private Float floatField;
        private Double doubleField;
        private BigDecimal decimalField;
        private Boolean booleanField;
        private Instant instantField;
        private SdkBytes bytesField;
        private List<String> listField;
        private Map<String, String> mapField;

        BuilderImpl() {
        }

        @Override
        public Builder stringField(String stringField) {
            this.stringField = stringField;
            return this;
        }

        @Override
        public Builder shortField(Short shortField) {
            this.shortField = shortField;
            return this;
        }

        @Override
        public Builder integerField(Integer integerField) {
            this.integerField = integerField;
            return this;
        }

        @Override
        public Builder longField(Long longField) {
            this.longField = longField;
            return this;
        }

        @Override
        public Builder floatField(Float floatField) {
            this.floatField = floatField;
            return this;
        }

        @Override
        public Builder doubleField(Double doubleField) {
            this.doubleField = doubleField;
            return this;
        }

        @Override
        public Builder decimalField(BigDecimal decimalField) {
            this.decimalField = decimalField;
            return this;
        }

        @Override
        public Builder booleanField(Boolean booleanField) {
            this.booleanField = booleanField;
            return this;
        }

        @Override
        public Builder instantField(Instant instantField) {
            this.instantField = instantField;
            return this;
        }

        @Override
        public Builder bytesField(SdkBytes bytesField) {
            this.bytesField = bytesField;
            return this;
        }

        @Override
        public Builder listField(List<String> listField) {
            this.listField = listField;
            return this;
        }

        @Override
        public Builder mapField(Map<String, String> mapField) {
            this.mapField = mapField;
            return this;
        }

        public Sample build() {
            return new Sample(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    SdkBuilder<Builder, Sample> {
        public Builder stringField(String var1);

        public Builder shortField(Short var1);

        public Builder integerField(Integer var1);

        public Builder longField(Long var1);

        public Builder floatField(Float var1);

        public Builder doubleField(Double var1);

        public Builder decimalField(BigDecimal var1);

        public Builder booleanField(Boolean var1);

        public Builder instantField(Instant var1);

        public Builder bytesField(SdkBytes var1);

        public Builder listField(List<String> var1);

        public Builder mapField(Map<String, String> var1);
    }
}

