/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.schemas;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.io.aws2.schemas.Sample;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.schemas.utils.SchemaTestUtils;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.junit.Test;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;

public class AwsSchemaProviderTest {
    private final SchemaRegistry registry = SchemaRegistry.createDefault();
    private final Instant now = Instant.now().truncatedTo(ChronoUnit.MINUTES);

    @Test
    public void testSampleSchema() throws NoSuchSchemaException {
        Schema schema = this.registry.getSchema(Sample.class);
        SchemaTestUtils.assertSchemaEquivalent((Schema)Schemas.SAMPLE, (Schema)schema);
    }

    @Test
    public void testAwsExampleSchema() throws NoSuchSchemaException {
        Schema schema = this.registry.getSchema(SendMessageRequest.class);
        SchemaTestUtils.assertSchemaEquivalent((Schema)Schemas.SEND_MESSAGE_REQUEST, (Schema)schema);
    }

    @Test
    public void testRecursiveSchema() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.registry.getSchema(AttributeValue.class)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Self-recursive types are not supported: " + AttributeValue.class);
    }

    @Test
    public void testToRowSerializable() throws NoSuchSchemaException {
        SerializableUtils.ensureSerializableRoundTrip((Serializable)this.registry.getToRowFunction(Sample.class));
        SerializableUtils.ensureSerializableRoundTrip((Serializable)this.registry.getToRowFunction(SendMessageRequest.class));
    }

    @Test
    public void testFromRowSerializable() throws NoSuchSchemaException {
        SerializableUtils.ensureSerializableRoundTrip((Serializable)this.registry.getFromRowFunction(Sample.class));
        SerializableUtils.ensureSerializableRoundTrip((Serializable)this.registry.getFromRowFunction(SendMessageRequest.class));
    }

    @Test
    public void testSampleToRow() throws NoSuchSchemaException {
        Sample sample = (Sample)Sample.builder().stringField("0").shortField((short)1).integerField(2).longField(3L).floatField(Float.valueOf(4.0f)).doubleField(5.0).decimalField(BigDecimal.valueOf(6L)).instantField(this.now).bytesField(SdkBytes.fromUtf8String((String)"7")).listField((List<String>)ImmutableList.of((Object)"8")).mapField((Map<String, String>)ImmutableMap.of((Object)"9", (Object)"9")).build();
        Row row = (Row)this.registry.getToRowFunction(Sample.class).apply((Object)sample);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)row).has(this.field("string", "0"))).has(this.field("short", (short)1))).has(this.field("integer", 2))).has(this.field("long", 3L))).has(this.field("float", Float.valueOf(4.0f)))).has(this.field("double", 5.0))).has(this.field("decimal", BigDecimal.valueOf(6L)))).has(this.field("instant", org.joda.time.Instant.ofEpochMilli((long)this.now.toEpochMilli())))).has(this.field("bytes", "7".getBytes(StandardCharsets.UTF_8)))).has(this.field("list", ImmutableList.of((Object)"8")))).has(this.field("map", ImmutableMap.of((Object)"9", (Object)"9")));
    }

    @Test
    public void testAwsExampleToRow() throws NoSuchSchemaException {
        SendMessageRequest request = (SendMessageRequest)SendMessageRequest.builder().queueUrl("queue").messageBody("body").delaySeconds(Integer.valueOf(100)).messageDeduplicationId("dedupId").messageGroupId("groupId").messageAttributes((Map)ImmutableMap.of((Object)"string", (Object)AwsSchemaProviderTest.attribute(b -> b.stringValue("v").dataType("String")), (Object)"binary", (Object)AwsSchemaProviderTest.attribute(b -> b.binaryValue(AwsSchemaProviderTest.sdkBytes("v")).dataType("Binary")), (Object)"stringList", (Object)AwsSchemaProviderTest.attribute(b -> b.stringListValues(new String[]{"v1", "v2"})), (Object)"binaryList", (Object)AwsSchemaProviderTest.attribute(b -> b.binaryListValues(new SdkBytes[]{AwsSchemaProviderTest.sdkBytes("v1"), AwsSchemaProviderTest.sdkBytes("v2")})))).build();
        Row row = (Row)this.registry.getToRowFunction(SendMessageRequest.class).apply((Object)request);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)row).has(this.field("queueUrl", "queue"))).has(this.field("messageBody", "body"))).has(this.field("delaySeconds", 100))).has(this.field("messageDeduplicationId", "dedupId"))).has(this.field("messageGroupId", "groupId"));
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)((Row)row.getMap("messageAttributes").get("string"))).has(this.field("dataType", "String"))).has(this.field("stringValue", "v"))).has(this.field("binaryValue", null))).has(this.field("stringListValues", null))).has(this.field("binaryListValues", null));
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)((Row)row.getMap("messageAttributes").get("binary"))).has(this.field("dataType", "Binary"))).has(this.field("stringValue", null))).has(this.field("binaryValue", AwsSchemaProviderTest.bytes("v")))).has(this.field("stringListValues", null))).has(this.field("binaryListValues", null));
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)((Row)row.getMap("messageAttributes").get("stringList"))).has(this.field("dataType", null))).has(this.field("stringValue", null))).has(this.field("binaryValue", null))).has(this.field("stringListValues", ImmutableList.of((Object)"v1", (Object)"v2")))).has(this.field("binaryListValues", null));
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)((Row)row.getMap("messageAttributes").get("binaryList"))).has(this.field("dataType", null))).has(this.field("stringValue", null))).has(this.field("binaryValue", null))).has(this.field("stringListValues", null))).has(this.field("binaryListValues", ImmutableList.of((Object)AwsSchemaProviderTest.bytes("v1"), (Object)AwsSchemaProviderTest.bytes("v2"))));
    }

    @Test
    public void testSampleFromRow() throws NoSuchSchemaException, CoderException {
        Sample sample = (Sample)Sample.builder().stringField("0").shortField((short)1).integerField(2).longField(3L).floatField(Float.valueOf(4.0f)).doubleField(5.0).decimalField(BigDecimal.valueOf(6L)).instantField(this.now).bytesField(SdkBytes.fromUtf8String((String)"7")).listField((List<String>)ImmutableList.of((Object)"8")).mapField((Map<String, String>)ImmutableMap.of((Object)"9", (Object)"9")).build();
        SchemaCoder coder = this.registry.getSchemaCoder(Sample.class);
        Row row = (Row)coder.getToRowFunction().apply((Object)sample);
        Assertions.assertThat((Object)((Sample)coder.getFromRowFunction().apply((Object)row))).isEqualTo((Object)sample);
        byte[] sampleBytes = CoderUtils.encodeToByteArray((Coder)coder, (Object)sample);
        Sample sampleFromBytes = (Sample)CoderUtils.decodeFromByteArray((Coder)coder, (byte[])sampleBytes);
        Assertions.assertThat((Object)sampleFromBytes).isEqualTo((Object)sample);
        SerializableUtils.ensureSerializableRoundTrip((Serializable)coder.getToRowFunction());
        SerializableUtils.ensureSerializableRoundTrip((Serializable)coder.getFromRowFunction());
    }

    @Test
    public void testAwsExampleFromRow() throws NoSuchSchemaException, CoderException {
        SendMessageRequest request = (SendMessageRequest)SendMessageRequest.builder().queueUrl("queue").messageBody("body").delaySeconds(Integer.valueOf(100)).messageDeduplicationId("dedupId").messageGroupId("groupId").messageAttributes((Map)ImmutableMap.of((Object)"string", (Object)AwsSchemaProviderTest.attribute(b -> b.stringValue("v").dataType("String")), (Object)"binary", (Object)AwsSchemaProviderTest.attribute(b -> b.binaryValue(AwsSchemaProviderTest.sdkBytes("v")).dataType("Binary")), (Object)"stringList", (Object)AwsSchemaProviderTest.attribute(b -> b.stringListValues(new String[]{"v1", "v2"})), (Object)"binaryList", (Object)AwsSchemaProviderTest.attribute(b -> b.binaryListValues(new SdkBytes[]{AwsSchemaProviderTest.sdkBytes("v1"), AwsSchemaProviderTest.sdkBytes("v2")})))).build();
        SchemaCoder coder = this.registry.getSchemaCoder(SendMessageRequest.class);
        Row row = (Row)coder.getToRowFunction().apply((Object)request);
        Assertions.assertThat((Object)((SendMessageRequest)coder.getFromRowFunction().apply((Object)row))).isEqualTo((Object)request);
        byte[] requestBytes = CoderUtils.encodeToByteArray((Coder)coder, (Object)request);
        SendMessageRequest requestFromBytes = (SendMessageRequest)CoderUtils.decodeFromByteArray((Coder)coder, (byte[])requestBytes);
        Assertions.assertThat((Object)requestFromBytes).isEqualTo((Object)request);
        SerializableUtils.ensureSerializableRoundTrip((Serializable)coder.getToRowFunction());
        SerializableUtils.ensureSerializableRoundTrip((Serializable)coder.getFromRowFunction());
    }

    @Test
    public void testFromRowWithPartialSchema() throws NoSuchSchemaException {
        SerializableFunction fromRow = this.registry.getFromRowFunction(SendMessageRequest.class);
        Schema partialSchema = Schema.builder().addNullableField("queueUrl", Schema.FieldType.STRING).addNullableField("messageBody", Schema.FieldType.STRING).addNullableField("delaySeconds", Schema.FieldType.INT32).build();
        SendMessageRequest request = (SendMessageRequest)SendMessageRequest.builder().queueUrl("queue").messageBody("body").delaySeconds(Integer.valueOf(100)).build();
        Row row = Row.withSchema((Schema)partialSchema).addValues(new Object[]{"queue", "body", 100}).build();
        Assertions.assertThat((Object)((SendMessageRequest)fromRow.apply((Object)row))).isEqualTo((Object)request);
    }

    @Test
    public void testFailFromRowOnUnknownField() throws NoSuchSchemaException {
        SerializableFunction fromRow = this.registry.getFromRowFunction(SendMessageRequest.class);
        Schema partialSchema = Schema.builder().addNullableField("queueUrl", Schema.FieldType.STRING).addNullableField("messageBody", Schema.FieldType.STRING).addNullableField("unknownField", Schema.FieldType.INT32).build();
        Row row = Row.withSchema((Schema)partialSchema).addValues(new Object[]{"queue", "body", 100}).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            SendMessageRequest cfr_ignored_0 = (SendMessageRequest)fromRow.apply((Object)row);
        }).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Row schema contains unknown fields: [unknownField]");
    }

    private static MessageAttributeValue attribute(Function<MessageAttributeValue.Builder, MessageAttributeValue.Builder> b) {
        return (MessageAttributeValue)b.apply(MessageAttributeValue.builder()).build();
    }

    private static SdkBytes sdkBytes(String str) {
        return SdkBytes.fromByteArrayUnsafe((byte[])AwsSchemaProviderTest.bytes(str));
    }

    private static byte[] bytes(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    private <T> Condition<Row> field(String name, T value) {
        return new Condition(row -> {
            Schema.FieldType type = row.getSchema().getField(name).getType();
            SoftAssertions soft = new SoftAssertions();
            Object actual = row.getValue(name);
            if (type.getTypeName() == Schema.TypeName.ARRAY && value != null && value instanceof List) {
                soft.assertThat((List)actual).containsExactlyElementsOf((Iterable)((List)value));
            } else {
                soft.assertThat(actual).isEqualTo(value);
            }
            soft.errorsCollected().forEach(System.out::println);
            return soft.errorsCollected().isEmpty();
        }, "field %s of: %s", new Object[]{name, value});
    }

    private static interface Schemas {
        public static final Schema MESSAGE_ATTRIBUTES = Schema.builder().addNullableField("stringValue", Schema.FieldType.STRING).addNullableField("binaryValue", Schema.FieldType.BYTES).addNullableField("stringListValues", Schema.FieldType.array((Schema.FieldType)Schema.FieldType.STRING)).addNullableField("binaryListValues", Schema.FieldType.array((Schema.FieldType)Schema.FieldType.BYTES)).addNullableField("dataType", Schema.FieldType.STRING).build();
        public static final Schema SEND_MESSAGE_REQUEST = Schema.builder().addNullableField("queueUrl", Schema.FieldType.STRING).addNullableField("messageBody", Schema.FieldType.STRING).addNullableField("delaySeconds", Schema.FieldType.INT32).addNullableField("messageAttributes", Schema.FieldType.map((Schema.FieldType)Schema.FieldType.STRING, (Schema.FieldType)Schema.FieldType.row((Schema)MESSAGE_ATTRIBUTES))).addNullableField("messageSystemAttributes", Schema.FieldType.map((Schema.FieldType)Schema.FieldType.STRING, (Schema.FieldType)Schema.FieldType.row((Schema)MESSAGE_ATTRIBUTES))).addNullableField("messageDeduplicationId", Schema.FieldType.STRING).addNullableField("messageGroupId", Schema.FieldType.STRING).build();
        public static final Schema SAMPLE = Schema.builder().addNullableField("string", Schema.FieldType.STRING).addNullableField("short", Schema.FieldType.INT16).addNullableField("integer", Schema.FieldType.INT32).addNullableField("long", Schema.FieldType.INT64).addNullableField("float", Schema.FieldType.FLOAT).addNullableField("double", Schema.FieldType.DOUBLE).addNullableField("decimal", Schema.FieldType.DECIMAL).addNullableField("boolean", Schema.FieldType.BOOLEAN).addNullableField("instant", Schema.FieldType.DATETIME).addNullableField("bytes", Schema.FieldType.BYTES).addNullableField("list", Schema.FieldType.array((Schema.FieldType)Schema.FieldType.STRING)).addNullableField("map", Schema.FieldType.map((Schema.FieldType)Schema.FieldType.STRING, (Schema.FieldType)Schema.FieldType.STRING)).build();
    }
}

