/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.s3.testing;

import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.aws2.ITEnvironment;
import org.apache.beam.sdk.io.aws2.options.S3Options;
import org.apache.beam.sdk.io.common.HashingFn;
import org.apache.beam.sdk.io.common.TestRow;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.joda.time.DateTime;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExternalResource;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.testcontainers.containers.localstack.LocalStackContainer;
import software.amazon.awssdk.services.s3.S3Client;

@RunWith(value=JUnit4.class)
public class S3FileSystemIT {
    @ClassRule
    public static ITEnvironment<S3ITOptions> env = new ITEnvironment<S3ITOptions>(LocalStackContainer.Service.S3, S3ITOptions.class, new String[0]);
    @Rule
    public TestPipeline pipelineWrite = env.createTestPipeline();
    @Rule
    public TestPipeline pipelineRead = env.createTestPipeline();
    @Rule
    public S3Bucket s3Bucket = new S3Bucket();

    @Test
    public void testWriteThenRead() {
        int rows = env.options().getNumberOfRows();
        ((PCollection)((PCollection)((PCollection)this.pipelineWrite.apply("Generate Sequence", (PTransform)GenerateSequence.from((long)0L).to((long)rows))).apply("Prepare TestRows", (PTransform)ParDo.of((DoFn)new TestRow.DeterministicallyConstructTestRowFn()))).apply("Prepare file rows", (PTransform)ParDo.of((DoFn)new TestRow.SelectNameFn()))).apply("Write to S3 file", (PTransform)TextIO.write().to("s3://" + this.s3Bucket.name + "/test"));
        this.pipelineWrite.run().waitUntilFinish();
        PCollection output = (PCollection)this.pipelineRead.apply((PTransform)TextIO.read().from("s3://" + this.s3Bucket.name + "/test*"));
        PAssert.thatSingleton((PCollection)((PCollection)output.apply(Count.globally()))).isEqualTo((Object)rows);
        PAssert.that((PCollection)((PCollection)output.apply((PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)new HashingFn()).withoutDefaults()))).containsInAnyOrder((Object[])new String[]{TestRow.getExpectedHashForRowCount((int)rows)});
        this.pipelineRead.run().waitUntilFinish();
    }

    static class S3Bucket
    extends ExternalResource {
        public final String name = "beam-s3io-it-" + new DateTime().toString("yyyyMMdd-HHmmss");

        S3Bucket() {
        }

        protected void before() throws Throwable {
            try (S3Client client = (S3Client)env.buildClient(S3Client.builder());){
                client.createBucket(b -> b.bucket(this.name));
            }
        }
    }

    public static interface S3ITOptions
    extends ITEnvironment.ITOptions,
    S3Options {
    }
}

